/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FilterType implements Enumerator
{
    EXCLUDE(0, "Exclude", "Exclude"),
    INCLUDE(1, "Include", "Include");

    public static final int EXCLUDE_VALUE = 0;
    public static final int INCLUDE_VALUE = 1;
    private static final FilterType[] VALUES_ARRAY;
    public static final List<FilterType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FilterType[]{EXCLUDE, INCLUDE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FilterType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FilterType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FilterType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FilterType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FilterType get(int value) {
        switch (value) {
            case 0: {
                return EXCLUDE;
            }
            case 1: {
                return INCLUDE;
            }
        }
        return null;
    }

    private FilterType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

