/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service.helpers;

import fr.cnav.saturne.app.service.exception.ExceptionKind;
import fr.cnav.saturne.app.service.helpers.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerHelper {
    private final Logger logger;

    public LoggerHelper(Class c) {
        this.logger = LoggerFactory.getLogger((Class)c);
    }

    public void logError(Exception exception) {
        this.logInErrorFile(exception);
        exception.printStackTrace();
    }

    public void logInErrorFile(Exception exception) {
        if (exception.getCause() != null) {
            this.logger.error(exception.getMessage(), exception.getCause());
        } else {
            this.logger.error(exception.getMessage());
        }
    }

    public void logError(String message, Object ... args) {
        this.logError(this.format(message, args));
    }

    public void logError(String message) {
        this.logger.error("[Saturne] " + message);
    }

    public void logDebug(String message, Object ... args) {
        this.logDebug(this.format(message, args));
    }

    public void logDebug(String message) {
        this.logger.debug("[Saturne] " + message);
    }

    public void logInfo(String message, Object ... args) {
        this.logInfo(this.format(message, args));
    }

    public void logInfo(String message) {
        this.logger.info("[Saturne] " + message);
    }

    public void logConsoleInfo(String message, Object ... args) {
        this.logConsoleInfo(this.format(message, args));
    }

    public void logConsoleInfo(String message) {
        this.logInfo(message);
        System.out.println("------> " + message);
    }

    public void logConsoleInfoPrefix(String message, String prefix) {
        this.logInfo(message);
        System.out.println(String.valueOf(prefix) + message);
    }

    public void validationServiceHelp() {
        System.out.println(Messages.HELP_LINE_01);
        ExceptionKind[] exceptionKindArray = ExceptionKind.values();
        int n = exceptionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionKind error = exceptionKindArray[n2];
            System.out.println("- " + error.getCode() + " : " + error.getMessage());
            ++n2;
        }
    }

    private String format(String msg, Object ... args) {
        return String.format(msg, args);
    }
}

