/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.normselector;

import fr.cnav.autocontrole.INormSerializer;
import fr.cnav.autocontrole.INormSerializerFactory;
import java.util.Map;
import java.util.Set;

public class SerializerFactoryImpl
implements INormSerializerFactory {
    private Map<String, INormSerializer> contentTypeToIReportSerializer;
    private String defaultContentType;

    public SerializerFactoryImpl(Map<String, INormSerializer> contentTypeToIReportSerializer, String defaultContentType) {
        this.defaultContentType = defaultContentType;
        this.contentTypeToIReportSerializer = contentTypeToIReportSerializer;
    }

    @Override
    public INormSerializer getNormSerializer(String contentType) {
        return this.contentTypeToIReportSerializer.get(contentType);
    }

    @Override
    public Set<String> getHandledContentTypes() {
        return this.contentTypeToIReportSerializer.keySet();
    }

    @Override
    public String getDefaultContentType() {
        return this.defaultContentType;
    }

    @Override
    public String getSerializerLabel(String contentType) {
        INormSerializer iNormSerializer = this.contentTypeToIReportSerializer.get(contentType);
        if (iNormSerializer != null) {
            return iNormSerializer.getLabel();
        }
        return null;
    }

    @Override
    public String getSerializerExtension(String contentType) {
        INormSerializer iNormSerializer = this.contentTypeToIReportSerializer.get(contentType);
        if (iNormSerializer != null) {
            return iNormSerializer.getExtension();
        }
        return null;
    }
}

