/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.helpers;

import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public final class ZipApacheUtil {
    private static final int NBBYTE = 1024;

    private ZipApacheUtil() {
    }

    public static InputStream getInputStream(ZipFile zf) {
        InputStream result;
        ZipArchiveEntry zipEntry = null;
        zipEntry = ZipApacheUtil.getFirstEntrie(zf);
        try {
            result = zf.getInputStream(zipEntry);
        }
        catch (ZipException zipException) {
            result = null;
        }
        catch (IOException iOException) {
            result = null;
        }
        return result;
    }

    private static ZipArchiveEntry getFirstEntrie(ZipFile zip) {
        ZipArchiveEntry firstEntry = null;
        if (zip != null) {
            while (zip.getEntries().hasMoreElements() && firstEntry == null) {
                firstEntry = (ZipArchiveEntry)zip.getEntries().nextElement();
            }
        }
        return firstEntry;
    }

    public static void extactFirstFile(File inputFile, String encoding, File unzippedFile) {
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            try {
                ZipFile zipFile = new ZipFile(inputFile, encoding);
                inputStream = ZipApacheUtil.getInputStream(zipFile);
                if (inputStream == null) {
                    throw new AutoCtrlException(ExceptionKind.ERROR_ZIP_FILE_ACCESS, inputFile.getAbsolutePath());
                }
                outputStream = new FileOutputStream(unzippedFile);
                int read = 0;
                byte[] bytes = new byte[1024];
                while (inputStream != null && (read = inputStream.read(bytes)) != -1) {
                    outputStream.write(bytes, 0, read);
                }
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.ERROR_ZIP_FILE_ACCESS, inputFile.getAbsolutePath(), e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_ZIP_FILE, inputFile.getAbsolutePath(), e.getMessage());
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_FILE, unzippedFile.getAbsolutePath(), e.getMessage());
                }
            }
            throw throwable;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_ZIP_FILE, inputFile.getAbsolutePath(), e.getMessage());
            }
        }
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new AutoCtrlException(ExceptionKind.CANNOT_CLOSE_FILE, unzippedFile.getAbsolutePath(), e.getMessage());
            }
        }
    }
}

