/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer.html.exporter.provider.html;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import n4ds.dsn.serializer.html.ExceptionKind;
import n4ds.dsn.serializer.html.HTMLSerializerException;
import n4ds.dsn.serializer.html.MessagesSerializer;
import n4ds.dsn.serializer.html.exporter.provider.IExportInputTemplateProvider;

public class HTMLExportInputTemplateProvider
implements IExportInputTemplateProvider {
    public static final String HTML_TEMPLATE_PATH = "/templates/html/HTMLTemplate.html";
    public static final String DECLARATION_ANOMALIE = MessagesSerializer.HTMLExportInputTemplateProvider_1;
    public static final String DECLARATION_ANOMALIE_SALARIE = MessagesSerializer.HTMLExportInputTemplateProvider_2;
    public static final String ENVOI_ANOMALIE = MessagesSerializer.HTMLExportInputTemplateProvider_3;
    public static final String FOOTER = MessagesSerializer.HTMLExportInputTemplateProvider_4;
    public static final String HEADER = MessagesSerializer.HTMLExportInputTemplateProvider_5;
    private List<String> templatesHeader = new ArrayList<String>();
    private List<String> templatesEnvoiAnomalie = new ArrayList<String>();
    private List<String> templatesEnvoiAnomalieHeader;
    private List<String> templatesEnvoiAnomalieFooter;
    private List<String> templatesDeclarationAnomalie = new ArrayList<String>();
    private List<String> templatesDeclarationAnomalieHeader;
    private List<String> templatesDeclarationAnomalieFooter;
    private List<String> templatesDeclarationAnomalieSalarie = new ArrayList<String>();
    private List<String> templatesDeclarationAnomalieSalarieHeader;
    private List<String> templatesDeclarationAnomalieSalarieFooter;
    private List<String> templatesFooter;

    public HTMLExportInputTemplateProvider() {
        this.templatesDeclarationAnomalieHeader = new ArrayList<String>();
        this.templatesDeclarationAnomalieSalarieHeader = new ArrayList<String>();
        this.templatesDeclarationAnomalieFooter = new ArrayList<String>();
        this.templatesEnvoiAnomalieFooter = new ArrayList<String>();
        this.templatesEnvoiAnomalieHeader = new ArrayList<String>();
        this.templatesDeclarationAnomalieSalarieFooter = new ArrayList<String>();
        this.templatesFooter = new ArrayList<String>();
    }

    @Override
    public void importTemplates() throws HTMLSerializerException {
        this.importFileTemplate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<String> importFileTemplate() throws HTMLSerializerException {
        ArrayList<String> templates = new ArrayList<String>();
        InputStream fileInputStream = null;
        try {
            try {
                fileInputStream = HTMLExportInputTemplateProvider.class.getClassLoader().getResourceAsStream(HTML_TEMPLATE_PATH);
                if (fileInputStream == null) {
                    throw new HTMLSerializerException(ExceptionKind.ERROR_EXPORT_IMPORT_TEMPLATE);
                }
                InputStreamReader ipsr = new InputStreamReader(fileInputStream, MessagesSerializer.ExportUtil_0);
                BufferedReader br = new BufferedReader(ipsr);
                String result = "";
                String header = br.readLine();
                if (!header.contains(START_TEMPLATE_TAG)) {
                    throw new HTMLSerializerException(ExceptionKind.ERROR_EXPORT_IMPORT_BAD_TEMPLATE);
                }
                while (true) {
                    String line;
                    if ((line = br.readLine()) == null) {
                        this.addToTemplatesList(header, result);
                        br.close();
                        return templates;
                    }
                    if (line.contains(START_TEMPLATE_TAG)) {
                        this.addToTemplatesList(header, result);
                        header = line;
                        result = "";
                        continue;
                    }
                    result = String.valueOf(result) + line + System.getProperty(MessagesSerializer.HTMLExportInputTemplateProvider_11);
                }
            }
            catch (FileNotFoundException e) {
                throw new HTMLSerializerException(ExceptionKind.ERROR_TECHNIC_EXPORT, (Throwable)e);
            }
            catch (IOException e) {
                throw new HTMLSerializerException(ExceptionKind.ERROR_TECHNIC_EXPORT, (Throwable)e);
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException ex) {
                throw new HTMLSerializerException(ExceptionKind.ERROR_TECHNIC_EXPORT, (Throwable)ex);
            }
        }
    }

    private void addToTemplatesList(String header, String result) {
        if (header.contains(HEADER)) {
            this.templatesHeader.add(result);
        } else if (header.contains(FOOTER)) {
            this.templatesFooter.add(result);
        } else if (header.contains(String.valueOf(ENVOI_ANOMALIE) + MessagesSerializer.HTMLExportInputTemplateProvider_12)) {
            this.templatesEnvoiAnomalieHeader.add(result);
        } else if (header.contains(String.valueOf(ENVOI_ANOMALIE) + MessagesSerializer.HTMLExportInputTemplateProvider_13)) {
            this.templatesEnvoiAnomalieFooter.add(result);
        } else if (header.contains(ENVOI_ANOMALIE)) {
            this.templatesEnvoiAnomalie.add(result);
        } else if (header.contains(String.valueOf(DECLARATION_ANOMALIE_SALARIE) + MessagesSerializer.HTMLExportInputTemplateProvider_14)) {
            this.templatesDeclarationAnomalieSalarieHeader.add(result);
        } else if (header.contains(String.valueOf(DECLARATION_ANOMALIE_SALARIE) + MessagesSerializer.HTMLExportInputTemplateProvider_15)) {
            this.templatesDeclarationAnomalieSalarieFooter.add(result);
        } else if (header.contains(DECLARATION_ANOMALIE_SALARIE)) {
            this.templatesDeclarationAnomalieSalarie.add(result);
        } else if (header.contains(String.valueOf(DECLARATION_ANOMALIE) + MessagesSerializer.HTMLExportInputTemplateProvider_16)) {
            this.templatesDeclarationAnomalieHeader.add(result);
        } else if (header.contains(String.valueOf(DECLARATION_ANOMALIE) + MessagesSerializer.HTMLExportInputTemplateProvider_17)) {
            this.templatesDeclarationAnomalieFooter.add(result);
        } else if (header.contains(DECLARATION_ANOMALIE)) {
            this.templatesDeclarationAnomalie.add(result);
        }
    }

    public List<String> getTemplatesHeader() {
        return this.templatesHeader;
    }

    public List<String> getTemplatesEnvoiAnomalie() {
        return this.templatesEnvoiAnomalie;
    }

    public List<String> getTemplatesEnvoiAnomalieHeader() {
        return this.templatesEnvoiAnomalieHeader;
    }

    public List<String> getTemplatesEnvoiAnomalieFooter() {
        return this.templatesEnvoiAnomalieFooter;
    }

    public List<String> getTemplatesDeclarationAnomalie() {
        return this.templatesDeclarationAnomalie;
    }

    public List<String> getTemplatesDeclarationAnomalieHeader() {
        return this.templatesDeclarationAnomalieHeader;
    }

    public List<String> getTemplatesDeclarationAnomalieFooter() {
        return this.templatesDeclarationAnomalieFooter;
    }

    public List<String> getTemplatesDeclarationAnomalieSalarie() {
        return this.templatesDeclarationAnomalieSalarie;
    }

    public List<String> getTemplatesDeclarationAnomalieSalarieHeader() {
        return this.templatesDeclarationAnomalieSalarieHeader;
    }

    public List<String> getTemplatesDeclarationAnomalieSalarieFooter() {
        return this.templatesDeclarationAnomalieSalarieFooter;
    }

    public List<String> getTemplatesFooter() {
        return this.templatesFooter;
    }
}

