/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

public class ValidatorJavaPkgIdFormat {
    private static final String[] JAVA_KEYWORD = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private FailureResultType failureResultType;
    private String charOrWordTriggerFailure;

    public boolean isValideCaseInsessitive(String idenfifier) {
        boolean result = true;
        if (idenfifier != null && !"".equals(idenfifier.trim())) {
            char firstChar = idenfifier.charAt(0);
            if (this.isAJavaFirstCharForbidden(firstChar)) {
                result = false;
                this.failureResultType = FailureResultType.ID_FIRST_CHAR_IS_FORRDIDEN_CHAR;
                this.charOrWordTriggerFailure = String.valueOf(firstChar);
            } else if (this.containForbiddenJavaChar(idenfifier)) {
                result = false;
                this.failureResultType = FailureResultType.ID_CONTAIN_FORRDIDEN_CHAR;
            } else if (this.isJavaKeyWord(idenfifier.toLowerCase())) {
                result = false;
                this.failureResultType = FailureResultType.ID_IS_KEYWORD;
                this.charOrWordTriggerFailure = idenfifier;
            }
        } else {
            result = false;
            this.failureResultType = FailureResultType.ID_IS_EMPTY_OR_NULL;
        }
        return result;
    }

    private boolean isJavaKeyWord(String idenfifier) {
        String[] stringArray = JAVA_KEYWORD;
        int n = JAVA_KEYWORD.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            if (keyword.equals(idenfifier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean containForbiddenJavaChar(String identifier) {
        int i = 0;
        while (i < identifier.length()) {
            char curChar = identifier.charAt(i);
            if (!Character.isJavaIdentifierPart(curChar)) {
                this.charOrWordTriggerFailure = String.valueOf(curChar);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAJavaFirstCharForbidden(char aChar) {
        return !Character.isJavaIdentifierStart(aChar);
    }

    public FailureResultType getFailureResultType() {
        return this.failureResultType;
    }

    public String getCharOrWordTriggerFailure() {
        return this.charOrWordTriggerFailure;
    }

    public static enum FailureResultType {
        ID_IS_EMPTY_OR_NULL,
        ID_IS_KEYWORD,
        ID_CONTAIN_FORRDIDEN_CHAR,
        ID_FIRST_CHAR_IS_FORRDIDEN_CHAR;

    }
}

