/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.impl;

import fr.cnav.saturne.Alias;
import fr.cnav.saturne.AlphanumericDataType;
import fr.cnav.saturne.BindingSet;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockContext;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.BoundRefinement;
import fr.cnav.saturne.CSVDataSource;
import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.ControlType;
import fr.cnav.saturne.CsvDataValue;
import fr.cnav.saturne.DataSourceSet;
import fr.cnav.saturne.DataTypeSet;
import fr.cnav.saturne.DateDataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.ExternalFunctionDefinition;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldContext;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.FilterType;
import fr.cnav.saturne.ForeignKeyBinding;
import fr.cnav.saturne.FunctionBinding;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.JavaRule;
import fr.cnav.saturne.Macro;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.NumericDataType;
import fr.cnav.saturne.ReportConfiguration;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.ReusedBlockSet;
import fr.cnav.saturne.ReusedField;
import fr.cnav.saturne.Rule;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.RuleSet;
import fr.cnav.saturne.RulesConfiguration;
import fr.cnav.saturne.SaturneFactory;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.impl.AliasImpl;
import fr.cnav.saturne.impl.AlphanumericDataTypeImpl;
import fr.cnav.saturne.impl.BindingSetImpl;
import fr.cnav.saturne.impl.BlockContextImpl;
import fr.cnav.saturne.impl.BlockFieldQualifiedIdAdapter;
import fr.cnav.saturne.impl.BlockImpl;
import fr.cnav.saturne.impl.BlockRefinementImpl;
import fr.cnav.saturne.impl.BlockRefinementUsageAdapter;
import fr.cnav.saturne.impl.BlockUsageAdapter;
import fr.cnav.saturne.impl.BoundRefinementImpl;
import fr.cnav.saturne.impl.CSVDataSourceImpl;
import fr.cnav.saturne.impl.CSVExternalDataTableImpl;
import fr.cnav.saturne.impl.CsvDataValueImpl;
import fr.cnav.saturne.impl.DataSourceSetImpl;
import fr.cnav.saturne.impl.DataTypeSetImpl;
import fr.cnav.saturne.impl.DateDataTypeImpl;
import fr.cnav.saturne.impl.DeclarationBlockImpl;
import fr.cnav.saturne.impl.DeclarationImpl;
import fr.cnav.saturne.impl.EnumDataTypeImpl;
import fr.cnav.saturne.impl.ExternalDataTypeImpl;
import fr.cnav.saturne.impl.ExternalFunctionDefinitionImpl;
import fr.cnav.saturne.impl.FieldContextImpl;
import fr.cnav.saturne.impl.FieldImpl;
import fr.cnav.saturne.impl.FieldRefinementImpl;
import fr.cnav.saturne.impl.FieldToValueMapImpl;
import fr.cnav.saturne.impl.ForeignKeyBindingImpl;
import fr.cnav.saturne.impl.FunctionBindingImpl;
import fr.cnav.saturne.impl.HeaderBlockImpl;
import fr.cnav.saturne.impl.JavaRuleImpl;
import fr.cnav.saturne.impl.MacroImpl;
import fr.cnav.saturne.impl.MessageImpl;
import fr.cnav.saturne.impl.NumericDataTypeImpl;
import fr.cnav.saturne.impl.ReportConfigurationImpl;
import fr.cnav.saturne.impl.ReusedBlockImpl;
import fr.cnav.saturne.impl.ReusedBlockSetImpl;
import fr.cnav.saturne.impl.ReusedFieldImpl;
import fr.cnav.saturne.impl.RuleImpl;
import fr.cnav.saturne.impl.RuleSetImpl;
import fr.cnav.saturne.impl.RulesConfigurationImpl;
import fr.cnav.saturne.impl.StandardImpl;
import fr.cnav.saturne.impl.ValueImpl;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class SaturneFactoryImpl
extends EFactoryImpl
implements SaturneFactory {
    public static SaturneFactory init() {
        try {
            SaturneFactory theSaturneFactory = (SaturneFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.cnav.fr/saturne/1.0");
            if (theSaturneFactory != null) {
                return theSaturneFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new SaturneFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 2: {
                return this.createStandard();
            }
            case 4: {
                return this.createMessage();
            }
            case 5: {
                return this.createBlock();
            }
            case 6: {
                return this.createHeaderBlock();
            }
            case 7: {
                return this.createDeclarationBlock();
            }
            case 8: {
                return this.createField();
            }
            case 9: {
                return this.createValue();
            }
            case 11: {
                return this.createEnumDataType();
            }
            case 12: {
                return this.createAlphanumericDataType();
            }
            case 13: {
                return this.createNumericDataType();
            }
            case 14: {
                return this.createDateDataType();
            }
            case 15: {
                return this.createExternalDataType();
            }
            case 17: {
                return this.createCSVDataSource();
            }
            case 19: {
                return this.createCSVExternalDataTable();
            }
            case 21: {
                return this.createAlias();
            }
            case 22: {
                return this.createMacro();
            }
            case 23: {
                return this.createExternalFunctionDefinition();
            }
            case 24: {
                return this.createRulesConfiguration();
            }
            case 25: {
                return this.createDeclaration();
            }
            case 26: {
                return (EObject)this.createFieldToValueMap();
            }
            case 28: {
                return this.createBlockRefinement();
            }
            case 29: {
                return this.createBoundRefinement();
            }
            case 30: {
                return this.createFieldRefinement();
            }
            case 31: {
                return this.createReportConfiguration();
            }
            case 32: {
                return this.createFieldContext();
            }
            case 33: {
                return this.createBlockContext();
            }
            case 34: {
                return this.createRuleSet();
            }
            case 35: {
                return this.createDataTypeSet();
            }
            case 36: {
                return this.createDataSourceSet();
            }
            case 37: {
                return this.createJavaRule();
            }
            case 38: {
                return this.createRule();
            }
            case 39: {
                return this.createCsvDataValue();
            }
            case 40: {
                return this.createReusedBlock();
            }
            case 41: {
                return this.createReusedBlockSet();
            }
            case 42: {
                return this.createReusedField();
            }
            case 44: {
                return this.createForeignKeyBinding();
            }
            case 45: {
                return this.createFunctionBinding();
            }
            case 46: {
                return this.createBindingSet();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 47: {
                return this.createNatureTypeFromString(eDataType, initialValue);
            }
            case 48: {
                return this.createUsageTypeFromString(eDataType, initialValue);
            }
            case 49: {
                return this.createControlTypeFromString(eDataType, initialValue);
            }
            case 50: {
                return this.createRuleCriticityFromString(eDataType, initialValue);
            }
            case 51: {
                return this.createFilterTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 47: {
                return this.convertNatureTypeToString(eDataType, instanceValue);
            }
            case 48: {
                return this.convertUsageTypeToString(eDataType, instanceValue);
            }
            case 49: {
                return this.convertControlTypeToString(eDataType, instanceValue);
            }
            case 50: {
                return this.convertRuleCriticityToString(eDataType, instanceValue);
            }
            case 51: {
                return this.convertFilterTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public Standard createStandard() {
        StandardImpl standard = new StandardImpl();
        return standard;
    }

    @Override
    public Message createMessage() {
        MessageImpl message = new MessageImpl();
        return message;
    }

    @Override
    public Block createBlock() {
        BlockImpl block = new BlockImpl();
        block.eAdapters().add((Object)new BlockFieldQualifiedIdAdapter());
        block.eAdapters().add((Object)new BlockUsageAdapter());
        return block;
    }

    @Override
    public HeaderBlock createHeaderBlock() {
        HeaderBlockImpl headerBlock = new HeaderBlockImpl();
        headerBlock.eAdapters().add((Object)new BlockFieldQualifiedIdAdapter());
        return headerBlock;
    }

    @Override
    public DeclarationBlock createDeclarationBlock() {
        DeclarationBlockImpl declarationBlock = new DeclarationBlockImpl();
        declarationBlock.eAdapters().add((Object)new BlockFieldQualifiedIdAdapter());
        return declarationBlock;
    }

    @Override
    public Field createField() {
        FieldImpl field = new FieldImpl();
        return field;
    }

    @Override
    public Value createValue() {
        ValueImpl value = new ValueImpl();
        return value;
    }

    @Override
    public EnumDataType createEnumDataType() {
        EnumDataTypeImpl enumDataType = new EnumDataTypeImpl();
        enumDataType.setNature(NatureType.ENUMERATION);
        return enumDataType;
    }

    @Override
    public AlphanumericDataType createAlphanumericDataType() {
        AlphanumericDataTypeImpl alphanumericDataType = new AlphanumericDataTypeImpl();
        alphanumericDataType.setNature(NatureType.ALPHANUMERIC);
        return alphanumericDataType;
    }

    @Override
    public NumericDataType createNumericDataType() {
        NumericDataTypeImpl numericDataType = new NumericDataTypeImpl();
        numericDataType.setNature(NatureType.NUMERIC);
        return numericDataType;
    }

    @Override
    public DateDataType createDateDataType() {
        DateDataTypeImpl dateDataType = new DateDataTypeImpl();
        dateDataType.setNature(NatureType.DATE);
        return dateDataType;
    }

    @Override
    public ExternalDataType createExternalDataType() {
        ExternalDataTypeImpl externalDataType = new ExternalDataTypeImpl();
        externalDataType.setNature(NatureType.EXTERNAL_REFERENTIAL);
        return externalDataType;
    }

    @Override
    public CSVDataSource createCSVDataSource() {
        CSVDataSourceImpl csvDataSource = new CSVDataSourceImpl();
        return csvDataSource;
    }

    @Override
    public CSVExternalDataTable createCSVExternalDataTable() {
        CSVExternalDataTableImpl csvExternalDataTable = new CSVExternalDataTableImpl();
        return csvExternalDataTable;
    }

    @Override
    public Alias createAlias() {
        AliasImpl alias = new AliasImpl();
        return alias;
    }

    @Override
    public Macro createMacro() {
        MacroImpl macro = new MacroImpl();
        return macro;
    }

    @Override
    public ExternalFunctionDefinition createExternalFunctionDefinition() {
        ExternalFunctionDefinitionImpl externalFunctionDefinition = new ExternalFunctionDefinitionImpl();
        return externalFunctionDefinition;
    }

    @Override
    public RulesConfiguration createRulesConfiguration() {
        RulesConfigurationImpl rulesConfiguration = new RulesConfigurationImpl();
        return rulesConfiguration;
    }

    @Override
    public Declaration createDeclaration() {
        DeclarationImpl declaration = new DeclarationImpl();
        return declaration;
    }

    public Map.Entry<Field, EList<Value>> createFieldToValueMap() {
        FieldToValueMapImpl fieldToValueMap = new FieldToValueMapImpl();
        return fieldToValueMap;
    }

    @Override
    public BlockRefinement createBlockRefinement() {
        BlockRefinementImpl blockRefinement = new BlockRefinementImpl();
        blockRefinement.eAdapters().add((Object)new BlockRefinementUsageAdapter());
        return blockRefinement;
    }

    @Override
    public BoundRefinement createBoundRefinement() {
        BoundRefinementImpl boundRefinement = new BoundRefinementImpl();
        return boundRefinement;
    }

    @Override
    public FieldRefinement createFieldRefinement() {
        FieldRefinementImpl fieldRefinement = new FieldRefinementImpl();
        return fieldRefinement;
    }

    @Override
    public ReportConfiguration createReportConfiguration() {
        ReportConfigurationImpl reportConfiguration = new ReportConfigurationImpl();
        return reportConfiguration;
    }

    @Override
    public FieldContext createFieldContext() {
        FieldContextImpl fieldContext = new FieldContextImpl();
        return fieldContext;
    }

    @Override
    public BlockContext createBlockContext() {
        BlockContextImpl blockContext = new BlockContextImpl();
        return blockContext;
    }

    @Override
    public RuleSet createRuleSet() {
        RuleSetImpl ruleSet = new RuleSetImpl();
        return ruleSet;
    }

    @Override
    public DataTypeSet createDataTypeSet() {
        DataTypeSetImpl dataTypeSet = new DataTypeSetImpl();
        return dataTypeSet;
    }

    @Override
    public DataSourceSet createDataSourceSet() {
        DataSourceSetImpl dataSourceSet = new DataSourceSetImpl();
        return dataSourceSet;
    }

    @Override
    public JavaRule createJavaRule() {
        JavaRuleImpl javaRule = new JavaRuleImpl();
        return javaRule;
    }

    @Override
    public Rule createRule() {
        RuleImpl rule = new RuleImpl();
        return rule;
    }

    @Override
    public CsvDataValue createCsvDataValue() {
        CsvDataValueImpl csvDataValue = new CsvDataValueImpl();
        return csvDataValue;
    }

    @Override
    public ReusedBlock createReusedBlock() {
        ReusedBlockImpl reusedBlock = new ReusedBlockImpl();
        return reusedBlock;
    }

    @Override
    public ForeignKeyBinding createForeignKeyBinding() {
        ForeignKeyBindingImpl foreignKeyBinding = new ForeignKeyBindingImpl();
        return foreignKeyBinding;
    }

    @Override
    public ReusedBlockSet createReusedBlockSet() {
        ReusedBlockSetImpl reusedBlockSet = new ReusedBlockSetImpl();
        return reusedBlockSet;
    }

    @Override
    public FunctionBinding createFunctionBinding() {
        FunctionBindingImpl functionBinding = new FunctionBindingImpl();
        return functionBinding;
    }

    @Override
    public ReusedField createReusedField() {
        ReusedFieldImpl reusedField = new ReusedFieldImpl();
        return reusedField;
    }

    @Override
    public BindingSet createBindingSet() {
        BindingSetImpl bindingSet = new BindingSetImpl();
        return bindingSet;
    }

    public NatureType createNatureTypeFromString(EDataType eDataType, String initialValue) {
        NatureType result = NatureType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertNatureTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public UsageType createUsageTypeFromString(EDataType eDataType, String initialValue) {
        UsageType result = UsageType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertUsageTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ControlType createControlTypeFromString(EDataType eDataType, String initialValue) {
        ControlType result = ControlType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertControlTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RuleCriticity createRuleCriticityFromString(EDataType eDataType, String initialValue) {
        RuleCriticity result = RuleCriticity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRuleCriticityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public FilterType createFilterTypeFromString(EDataType eDataType, String initialValue) {
        FilterType result = FilterType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertFilterTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public SaturnePackage getSaturnePackage() {
        return (SaturnePackage)this.getEPackage();
    }

    @Deprecated
    public static SaturnePackage getPackage() {
        return SaturnePackage.eINSTANCE;
    }
}

