/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service.handlers;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.app.service.helpers.FilesManager;
import fr.cnav.saturne.app.service.helpers.LoggerHelper;
import fr.cnav.saturne.app.service.helpers.Messages;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.conversion.OriginalValueOptionValue;
import fr.cnav.saturne.validator.functions.ValidationFunctionException;
import fr.cnav.saturne.validator.functions.ValidationFunctions;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.impl.KBDescriptorFactoryException;
import fr.cnav.saturne.validator.impl.SystemPropertyKBDescriptorFactory;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import fr.cnav.saturne.validator.report.impl.GenericXMLReportSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.util.Calendar;

public class DSNToReportHandler {
    public static final String ALL_IN_ONE_SUFFIXE = "-nor";
    protected static final LoggerHelper LOGGER = new LoggerHelper(DSNToReportHandler.class);
    private static final String DOT = ".";
    private static final String VALIDATION_FILE_EXTENSION = "xml";
    private static final String CONVERTED_FILE_EXTENSION = "xml";
    private final String validatedFolderPath;
    private final String runningFolderPath;
    private SaturneLayer saturneLayer;

    public DSNToReportHandler(String validatedFolderPath, String runningFolderPath) {
        this.validatedFolderPath = validatedFolderPath;
        File fileRunningFolder = new File(runningFolderPath);
        if (!fileRunningFolder.exists() || !fileRunningFolder.isDirectory()) {
            LOGGER.logError(Messages.LOG_RUNNING_19, runningFolderPath);
            throw new RuntimeException(String.format(Messages.LOG_RUNNING_19, runningFolderPath));
        }
        this.runningFolderPath = runningFolderPath;
        try {
            this.saturneLayer = this.getSaturneLayer();
        }
        catch (ValidationFunctionException e) {
            LOGGER.logError((Exception)((Object)e));
        }
    }

    private SaturneLayer getSaturneLayer() throws ValidationFunctionException {
        SaturneLayer layer = null;
        AbstractKBDescriptor registeredKBDescriptor = null;
        Object objNormeInstance = System.getProperties().get("fr.cnav.norme.descriptor.instance");
        if (objNormeInstance != null && objNormeInstance instanceof AbstractKBDescriptor) {
            registeredKBDescriptor = (AbstractKBDescriptor)objNormeInstance;
        }
        if (registeredKBDescriptor == null) {
            String normeDescriptorQualifiedName = System.getProperty("fr.cnav.norme.descriptor");
            if (normeDescriptorQualifiedName == null) {
                throw new ValidationFunctionException("The knowledge base descriptor system property is not set");
            }
            SystemPropertyKBDescriptorFactory loader = new SystemPropertyKBDescriptorFactory();
            try {
                Class descriptorClass = loader.loadClass(normeDescriptorQualifiedName);
                registeredKBDescriptor = (AbstractKBDescriptor)loader.instantiate(descriptorClass);
            }
            catch (KBDescriptorFactoryException e) {
                throw new ValidationFunctionException((Throwable)e);
            }
        }
        if (registeredKBDescriptor != null) {
            OptionMap options = this.assignAndGetParameters();
            options.setOption(new Key("stop.on.conversion.error"), (Object)this.stopControlOnConversionError());
            options.setOption(new Key("stop.on.syntactic.error"), (Object)this.stopControlOnSyntacticError());
            Standard standard = registeredKBDescriptor.getModelAccessor().getStandard();
            ValidationFunctions validationFunctions = new ValidationFunctions(new ControlMessages(registeredKBDescriptor.getResourceBundle()), options, registeredKBDescriptor);
            options.setOption(new Key("fr.cnav.saturne.rules.properties"), (Object)validationFunctions.getControlsProperties());
            Key key = new Key("fr.cnav.saturne.validator.validationSerializer");
            options.setOption(key, (Object)((IReportSerializer)registeredKBDescriptor.getOptions().getOption(key)));
            layer = new SaturneLayer(validationFunctions, standard, options);
        }
        return layer;
    }

    public void validateDSN(File file) {
        if (file == null) {
            LOGGER.logError(Messages.LOG_RUNNING_28, "file");
            throw new RuntimeException(String.format(Messages.LOG_RUNNING_28, "file"));
        }
        if (!file.exists()) {
            LOGGER.logError(Messages.LOG_RUNNING_29, file.getAbsolutePath());
            throw new RuntimeException(String.format(Messages.LOG_RUNNING_29, file.getAbsolutePath()));
        }
        String id = file.getName();
        String dsnFilePath = file.getAbsolutePath();
        String abslolutPathRunningFolderPath = new File(this.runningFolderPath).getAbsolutePath();
        LOGGER.logInfo(Messages.LOG_RUNNING_20, file, abslolutPathRunningFolderPath);
        FilesManager inputFileManager = new FilesManager(dsnFilePath, this.runningFolderPath);
        inputFileManager.moveFiles();
        LOGGER.logInfo(Messages.LOG_RUNNING_21, file, abslolutPathRunningFolderPath);
        String newValidatedFilePath = String.valueOf(this.runningFolderPath) + File.separator + id;
        File validatedFile = new File(newValidatedFilePath);
        if (!validatedFile.exists()) {
            LOGGER.logError(Messages.LOG_RUNNING_29, validatedFile.getAbsolutePath());
            throw new RuntimeException(String.format(Messages.LOG_RUNNING_29, validatedFile.getAbsolutePath()));
        }
        LOGGER.logInfo(Messages.LOG_RUNNING_22, file.getAbsolutePath());
        File convertedFileInRunningFolder = null;
        File reportFileInRunningFolder = null;
        IReportLogger report = null;
        LOGGER.logInfo(Messages.LOG_RUNNING_49);
        IReportSerializer serializer = this.initSerializer(this.saturneLayer);
        LOGGER.logInfo(Messages.LOG_RUNNING_50);
        try {
            LOGGER.logInfo(Messages.LOG_RUNNING_51, "Temporary Report");
            reportFileInRunningFolder = this.createTempFile(String.valueOf(id) + ALL_IN_ONE_SUFFIXE + DOT + "xml");
            LOGGER.logInfo(Messages.LOG_RUNNING_52, "Temporary Report");
            if (this.saturneLayer != null) {
                LOGGER.logInfo(Messages.LOG_RUNNING_53);
                report = this.createNewReportLogger(id, serializer);
                LOGGER.logInfo(Messages.LOG_RUNNING_54);
                LOGGER.logInfo(Messages.LOG_RUNNING_51, "Temporary Converted");
                convertedFileInRunningFolder = this.createTempFile(String.valueOf(id) + DOT + "xml");
                LOGGER.logInfo(Messages.LOG_RUNNING_52, "Temporary Converted");
                LOGGER.logInfo(Messages.LOG_RUNNING_55);
                this.saturneLayer.getValidationFunctions().validateFromText(validatedFile, convertedFileInRunningFolder, report);
                LOGGER.logInfo(Messages.LOG_RUNNING_56);
                this.finishValidation(convertedFileInRunningFolder, reportFileInRunningFolder, report, serializer);
            }
        }
        catch (IOException e) {
            LOGGER.logError(e);
        }
        catch (ValidationFunctionException e) {
            LOGGER.logError((Exception)((Object)e));
        }
        catch (TooManyAnomaliesException e) {
            LOGGER.logInErrorFile((Exception)((Object)e));
            try {
                this.finishValidation(convertedFileInRunningFolder, reportFileInRunningFolder, report, serializer);
            }
            catch (IOException e1) {
                LOGGER.logError(e1);
            }
            catch (ValidationFunctionException e1) {
                LOGGER.logError((Exception)((Object)e1));
            }
        }
        LOGGER.logInfo(Messages.LOG_RUNNING_23, file);
        this.moveRunningFilesInOutput(newValidatedFilePath, convertedFileInRunningFolder, reportFileInRunningFolder);
    }

    private void finishValidation(File convertedFileInRunningFolder, File reportFileInRunningFolder, IReportLogger report, IReportSerializer reportSerializer) throws IOException, ValidationFunctionException, FileNotFoundException {
        LOGGER.logInfo(Messages.LOG_RUNNING_57);
        this.launchComputeContext(convertedFileInRunningFolder, report);
        LOGGER.logInfo(Messages.LOG_RUNNING_58);
        LOGGER.logInfo(Messages.LOG_RUNNING_59, reportFileInRunningFolder.getAbsolutePath());
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileOutputStream reportOutput = new FileOutputStream(reportFileInRunningFolder);){
            String absolutePath = reportFileInRunningFolder.getAbsolutePath();
            this.saturneLayer.getValidationFunctions().writeReport((OutputStream)reportOutput, absolutePath, report, reportSerializer);
            LOGGER.logInfo(Messages.LOG_RUNNING_60, reportFileInRunningFolder.getAbsolutePath());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void moveRunningFilesInOutput(String newValidatedFilePath, File convertedFileInRunningFolder, File reportFileInRunningFolder) {
        String absoluteNewValidatedFilePath = new File(newValidatedFilePath).getAbsolutePath();
        String absoluteValidatedFilePath = new File(this.validatedFolderPath).getAbsolutePath();
        if (convertedFileInRunningFolder != null) {
            LOGGER.logInfo(Messages.LOG_RUNNING_24, absoluteNewValidatedFilePath);
        } else {
            LOGGER.logError(Messages.LOG_RUNNING_41, this.runningFolderPath);
        }
        LOGGER.logInfo(Messages.LOG_RUNNING_20, absoluteNewValidatedFilePath, absoluteValidatedFilePath);
        FilesManager newInputFileManager = new FilesManager(newValidatedFilePath, this.validatedFolderPath);
        newInputFileManager.moveFiles();
        LOGGER.logInfo(Messages.LOG_RUNNING_21, absoluteNewValidatedFilePath, absoluteValidatedFilePath);
        this.moveConversionIntoValidationFolder(convertedFileInRunningFolder, reportFileInRunningFolder);
        LOGGER.logInfo(Messages.LOG_RUNNING_25, absoluteNewValidatedFilePath);
    }

    private void moveConversionIntoValidationFolder(File convertedTempFile, File reportTempFile) {
        if (convertedTempFile != null && reportTempFile != null) {
            LOGGER.logInfo(Messages.LOG_RUNNING_45, convertedTempFile.getAbsolutePath(), this.validatedFolderPath);
            FilesManager conversionFileManager = new FilesManager(convertedTempFile.getAbsolutePath(), this.validatedFolderPath);
            conversionFileManager.moveFiles();
            LOGGER.logInfo(Messages.LOG_RUNNING_46, convertedTempFile.getAbsolutePath(), this.validatedFolderPath);
            LOGGER.logInfo(Messages.LOG_RUNNING_47, reportTempFile.getAbsolutePath(), this.validatedFolderPath);
            FilesManager reportFileManager = new FilesManager(reportTempFile.getAbsolutePath(), this.validatedFolderPath);
            reportFileManager.moveFiles();
            LOGGER.logInfo(Messages.LOG_RUNNING_48, reportTempFile.getAbsolutePath(), this.validatedFolderPath);
        } else if (reportTempFile == null) {
            LOGGER.logError(Messages.LOG_RUNNING_44, this.runningFolderPath);
        }
    }

    private IReportLogger createNewReportLogger(String id, IReportSerializer serializer) {
        IReportLogger report = this.saturneLayer.getNewReportLogger(serializer);
        report.setCustomAttribute("fr.cnav.saturne.validator.report.validationIdAttributeKey", id);
        report.setCustomAttribute("fr.cnav.saturne.validator.report.timeStampAttributeKey", Calendar.getInstance().getTime().toString());
        return report;
    }

    private File createTempFile(String tempFileName) throws IOException {
        File tempFile = new File(String.valueOf(this.runningFolderPath) + File.separator + tempFileName);
        boolean fileIsCreated = tempFile.createNewFile();
        if (!fileIsCreated) {
            LOGGER.logError(Messages.LOG_RUNNING_40, String.valueOf(this.runningFolderPath) + File.separator + tempFileName);
        }
        return tempFile;
    }

    private IReportSerializer initSerializer(SaturneLayer mySaturneLayer) {
        GenericXMLReportSerializer serializer = null;
        if (mySaturneLayer != null) {
            serializer = (IReportSerializer)mySaturneLayer.options.getOption(new Key("fr.cnav.saturne.validator.validationSerializer"));
        }
        if (serializer == null) {
            serializer = new GenericXMLReportSerializer();
        }
        return serializer;
    }

    private OptionMap assignAndGetParameters() {
        OptionMap options = new OptionMap();
        this.assignParameter("fr.cnav.norme.report.mutualisation.threshold", Integer.class, options);
        this.assignParameter("maximal.number.errors", Integer.class, options);
        this.assignParameter("line.number.location", Boolean.class, options);
        this.assignParameter("fr.cnav.norme.val.originalValue", OriginalValueOptionValue.class, options);
        this.assignParameter("sequence.provider.keep.faulty.fields", Boolean.class, options);
        this.assignParameter("fr.cnav.norme.val.anomaliesInhibiting", Boolean.class, options);
        this.assignParameter("fr.cnav.saturne.validator.inputFormatValidation", FormatType.class, options);
        return options;
    }

    private <T> void assignParameter(String key, Class<T> expectedType, OptionMap options) {
        String value = System.getProperty(key);
        if (value != null) {
            options.setOption(new Key(key), this.convert(expectedType, value));
        }
    }

    private <T> T convert(Class<T> expectedType, String value) {
        Constable result = null;
        if (expectedType == Integer.class) {
            result = Integer.valueOf(value);
        } else if (expectedType == Boolean.class) {
            result = Boolean.valueOf(value);
        } else if (expectedType == OriginalValueOptionValue.class) {
            result = OriginalValueOptionValue.valueOf((String)value);
        } else if (expectedType == FormatType.class) {
            result = FormatType.getByName((String)value);
        }
        return (T)result;
    }

    private void launchComputeContext(File xmlFile, IReportLogger reportLogger) throws IOException, ValidationFunctionException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileInputStream xmlInput = new FileInputStream(xmlFile);){
                this.saturneLayer.getValidationFunctions().computeContexts((InputStream)xmlInput, reportLogger);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.logError(e);
        }
    }

    private boolean stopControlOnConversionError() {
        String stopControlOption = System.getProperty("stop.on.conversion.error");
        return stopControlOption != null && "true".equals(stopControlOption);
    }

    private boolean stopControlOnSyntacticError() {
        String stopControlOption = System.getProperty("stop.on.syntactic.error");
        return stopControlOption != null && "true".equals(stopControlOption);
    }

    private static final class SaturneLayer {
        private Standard standard;
        private ValidationFunctions validationFunctions;
        private OptionMap options;

        SaturneLayer(ValidationFunctions validationFunctions, Standard standard, OptionMap options) {
            this.standard = standard;
            this.validationFunctions = validationFunctions;
            this.options = options;
        }

        public ValidationFunctions getValidationFunctions() {
            return this.validationFunctions;
        }

        public IReportLogger getNewReportLogger(IReportSerializer serializer) {
            return serializer.getReportLogger(this.standard, false, this.options);
        }
    }
}

