/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.csv.importer;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.PositionalFactory;
import fr.cnav.saturne.validator.positional.PositionalPackage;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.csv.IValidationRule;
import fr.cnav.saturne.validator.positional.csv.ValidationResult;
import fr.cnav.saturne.validator.positional.csv.Validator;
import fr.cnav.saturne.validator.positional.csv.importer.AttributeMapping;
import fr.cnav.saturne.validator.positional.csv.importer.BlockIdPositionalMapping;
import fr.cnav.saturne.validator.positional.csv.importer.BlockPositionalMappingRule;
import fr.cnav.saturne.validator.positional.csv.importer.FeatureMapping;
import fr.cnav.saturne.validator.positional.csv.importer.FieldFullQualifiedIdPositionalMapping;
import fr.cnav.saturne.validator.positional.csv.importer.FieldPositionalMappingRule;
import fr.cnav.saturne.validator.positional.csv.importer.RecordLengthPositionalMapping;
import fr.cnav.saturne.validator.positional.csv.importer.RecordRegexPositionalMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class PositionalFixModelCSVMapping {
    public static final String BLOCK_ID_COLUMN_TITLE = "Id bloc";
    public static final String FIELD_FQID_COLUMN_TITLE = "Full qualified id rubrique";
    public static final String START_POSITION_FIELD = "Position de d\u00e9part de la rubrique";
    public static final String END_POSITION_FIELD = "Position de fin de la rubrique";
    public static final String ABSCENCE_REGEX_FIELD = "Expression r\u00e9guli\u00e8re marquant l'abscence de la rubrique";
    public static final String RECORD_TYPE_REGEX = "Expression r\u00e9guli\u00e8re du record type associ\u00e9 \u00e0 la rubrique";
    public static final String RECORD_TYPE_LENGTH = "Longueur du record type associ\u00e9 \u00e0 la rubrique";
    public static final List<String> TITLES = Collections.unmodifiableList(Arrays.asList("Id bloc", "Full qualified id rubrique", "Position de d\u00e9part de la rubrique", "Position de fin de la rubrique", "Expression r\u00e9guli\u00e8re marquant l'abscence de la rubrique", "Expression r\u00e9guli\u00e8re du record type associ\u00e9 \u00e0 la rubrique", "Longueur du record type associ\u00e9 \u00e0 la rubrique"));
    private static final String INVALID_LINE_ERROR_MESSAGE = "The line does not contain the ids.";
    private static final Map<String, FeatureMapping> MAPPING = new HashMap<String, FeatureMapping>();
    private Standard standard;
    private boolean updateEmptyValues;
    private FormatSpecification positionalFixModel;
    private final EditingDomain domain;

    public PositionalFixModelCSVMapping(boolean isUpdateEmptyValues, FormatSpecification thePositionlModel, EditingDomain theDomain, Standard theStandard) {
        if (theStandard == null) {
            throw new IllegalArgumentException("Standard cannot be null.");
        }
        if (thePositionlModel == null) {
            throw new IllegalArgumentException("PositionalFix Model cannot be null.");
        }
        this.standard = theStandard;
        MAPPING.put(BLOCK_ID_COLUMN_TITLE, new BlockIdPositionalMapping(PositionalPackage.Literals.RECORD_SPECIFICATION__BLOCK, theDomain, this.standard));
        MAPPING.put(FIELD_FQID_COLUMN_TITLE, new FieldFullQualifiedIdPositionalMapping(PositionalPackage.Literals.FIELD_SPECIFICATION__FIELD, theDomain, this.standard));
        MAPPING.put(START_POSITION_FIELD, new AttributeMapping(PositionalPackage.Literals.FIELD_SPECIFICATION__START_POSITION, theDomain));
        MAPPING.put(END_POSITION_FIELD, new AttributeMapping(PositionalPackage.Literals.FIELD_SPECIFICATION__END_POSITION, theDomain));
        MAPPING.put(ABSCENCE_REGEX_FIELD, new AttributeMapping(PositionalPackage.Literals.FIELD_SPECIFICATION__EMPTY_REGEX, theDomain));
        MAPPING.put(RECORD_TYPE_REGEX, new RecordRegexPositionalMapping());
        MAPPING.put(RECORD_TYPE_LENGTH, new RecordLengthPositionalMapping());
        this.updateEmptyValues = isUpdateEmptyValues;
        this.positionalFixModel = thePositionlModel;
        this.domain = theDomain;
    }

    public FieldSpecification getFieldSpecificationFromId(String blockId, String fielFullQualifiedId) {
        FieldSpecification fieldSpecificationResult = null;
        Iterator recordIterator = this.positionalFixModel.getRecords().iterator();
        while (recordIterator.hasNext() && fieldSpecificationResult == null) {
            RecordSpecification recordSpecification = (RecordSpecification)recordIterator.next();
            if (recordSpecification.getBlock() == null || !blockId.equals(recordSpecification.getBlock().getId())) continue;
            Iterator fieldsIterator = recordSpecification.getFields().iterator();
            while (fieldsIterator.hasNext() && fieldSpecificationResult == null) {
                FieldSpecification fieldSpecification = (FieldSpecification)fieldsIterator.next();
                if (fieldSpecification.getField() == null || !fielFullQualifiedId.equals(fieldSpecification.getField().getFullQualifiedId())) continue;
                fieldSpecificationResult = fieldSpecification;
            }
        }
        return fieldSpecificationResult;
    }

    public RecordSpecification getRecordSpecification(String blockId) {
        RecordSpecification recordSpecificationResult = null;
        Iterator recordIterator = this.positionalFixModel.getRecords().iterator();
        while (recordIterator.hasNext() && recordSpecificationResult == null) {
            RecordSpecification recordSpecification = (RecordSpecification)recordIterator.next();
            if (recordSpecification.getBlock() == null || !blockId.equals(recordSpecification.getBlock().getId())) continue;
            recordSpecificationResult = recordSpecification;
        }
        return recordSpecificationResult;
    }

    public FieldSpecification getFieldSpecification(String[] line) {
        FieldSpecification fieldSpecification = null;
        if (line == null || line.length <= TITLES.indexOf(FIELD_FQID_COLUMN_TITLE)) {
            throw new IllegalArgumentException(INVALID_LINE_ERROR_MESSAGE);
        }
        fieldSpecification = this.getFieldSpecificationFromId(line[TITLES.indexOf(BLOCK_ID_COLUMN_TITLE)], line[TITLES.indexOf(FIELD_FQID_COLUMN_TITLE)]);
        if (fieldSpecification == null) {
            Command command;
            EditingDomain editingDomain;
            RecordSpecification recordSpecification = this.getRecordSpecification(line[TITLES.indexOf(BLOCK_ID_COLUMN_TITLE)]);
            if (recordSpecification == null) {
                recordSpecification = PositionalFactory.eINSTANCE.createRecordSpecification();
                recordSpecification.setRecordLength(Integer.parseInt(line[TITLES.indexOf(RECORD_TYPE_LENGTH)]));
                recordSpecification.setRecordTypeRegex(line[TITLES.indexOf(RECORD_TYPE_REGEX)]);
                editingDomain = this.getEditingDomain();
                if (editingDomain != null) {
                    command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.positionalFixModel, (Object)PositionalPackage.Literals.FORMAT_SPECIFICATION__RECORDS, (Object)recordSpecification);
                    this.getEditingDomain().getCommandStack().execute(command);
                } else {
                    throw new IllegalArgumentException("The editing domain must be specified.");
                }
            }
            fieldSpecification = PositionalFactory.eINSTANCE.createFieldSpecification();
            editingDomain = this.getEditingDomain();
            if (editingDomain != null) {
                command = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)recordSpecification, (Object)PositionalPackage.Literals.RECORD_SPECIFICATION__FIELDS, (Object)fieldSpecification);
                this.getEditingDomain().getCommandStack().execute(command);
            } else {
                throw new IllegalArgumentException("The editing domain must be specified.");
            }
        }
        return fieldSpecification;
    }

    public ValidationResult validateMsg(String[] line) {
        ArrayList<IValidationRule> rules = new ArrayList<IValidationRule>();
        rules.add(new FieldPositionalMappingRule(TITLES.indexOf(FIELD_FQID_COLUMN_TITLE), this.standard));
        rules.add(new BlockPositionalMappingRule(TITLES.indexOf(BLOCK_ID_COLUMN_TITLE), this.standard));
        Validator validator = new Validator(rules);
        return validator.validate(line, this.getLineId(line));
    }

    public List<Integer> getIdColumnsRanks() {
        ArrayList<Integer> columnIndexToForgeId = new ArrayList<Integer>();
        columnIndexToForgeId.add(0);
        columnIndexToForgeId.add(1);
        return columnIndexToForgeId;
    }

    protected String getLineId(String[] line) {
        return null;
    }

    private FeatureMapping getAttribute(int titleRank) {
        return MAPPING.get(TITLES.get(titleRank));
    }

    public List<String> getLine(FieldSpecification theFieldSpecification) {
        int size = TITLES.size();
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < size) {
            FeatureMapping mappingAttribute = this.getAttribute(i);
            String strValue = mappingAttribute.stringValue(theFieldSpecification);
            result.add(strValue);
            ++i;
        }
        return result;
    }

    public void updateEObject(FieldSpecification fieldSpecification, String[] line) {
        if (fieldSpecification == null) {
            throw new IllegalArgumentException("The target must not be null.");
        }
        if (line == null || line.length < 1) {
            throw new IllegalArgumentException("The line must not be null or empty.");
        }
        int size = TITLES.size();
        int i = 0;
        while (i < size) {
            FeatureMapping mappingAttribute = this.getAttribute(i);
            String value = line[i];
            if (!"".equals(value) || this.updateEmptyValues) {
                mappingAttribute.updateWithValue(value, fieldSpecification);
            }
            ++i;
        }
    }

    public EObject getPositionalFixModel() {
        return this.positionalFixModel;
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public boolean doUpdateEmptyValues() {
        return this.updateEmptyValues;
    }

    public void setUpdateEmptyValues(boolean updateEmptyValues) {
        this.updateEmptyValues = updateEmptyValues;
    }
}

