/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.msgtest;

import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.List;
import java.util.Map;

public class MessageTestSerializer {
    Map<IMessageBlock, String> blockTagMap;
    Map<IMessageField<?>, String> fieldTagMap;

    public String messageToIext(IMessageBlock message, Map<IMessageBlock, String> aBlockTagMap, Map<IMessageField<?>, String> aFieldTagMap) {
        this.blockTagMap = aBlockTagMap;
        this.fieldTagMap = aFieldTagMap;
        StringBuilder builder = new StringBuilder();
        this.messageToText(message, builder, "");
        this.blockTagMap = null;
        this.fieldTagMap = null;
        return builder.toString();
    }

    private void messageToText(IMessageBlock message, StringBuilder builder, String increment) {
        builder.append(String.valueOf(increment) + "<" + message.getStandardBlockDescription().getFullQualifiedId());
        if (this.blockTagMap != null && this.blockTagMap.containsKey(message)) {
            builder.append("#" + this.blockTagMap.get(message));
        }
        builder.append('\n');
        for (IMessageField<?> iMessageField : message.getFields()) {
            builder.append(String.valueOf(increment) + " +" + iMessageField.getStandardFieldDescription().getFullQualifiedId() + "," + iMessageField.getValueAsString());
            if (this.fieldTagMap != null && this.fieldTagMap.containsKey(iMessageField)) {
                builder.append("#" + this.fieldTagMap.get(iMessageField));
            }
            builder.append('\n');
        }
        for (List list : message.getChildren()) {
            for (IMessageBlock block : list) {
                this.messageToText(block, builder, String.valueOf(increment) + " ");
            }
        }
        builder.append(String.valueOf(increment) + ">");
        builder.append('\n');
    }
}

