/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.conversion.csv;

import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.enums.CSVReaderNullFieldIndicator;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.Anomaly;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.functions.CSVConfiguration;
import fr.cnav.saturne.validator.impl.LineAndColumnLocalizer;
import fr.cnav.saturne.validator.impl.ValidatorEncodingHandler;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVSequenceReader
implements ISequenceProvider {
    public static final int DEFAULT_MAX_LENGTH = 256;
    public static final int DEFAULT_MIN_LENGTH = 1;
    private static final String MSG_FIRST_LINE_READING_WARNING = "The first line of the CSV stream (to get the charset) has not been read successfully. So, the charset defined in the Standard will be used instead.";
    private Logger logger;
    private CSVReader reader;
    private OptionMap options;
    private MessageElementFactory messageElementFactory;
    private StandardAccessor modelAccessor;
    private ControlMessages controlMessages;
    private IMessageBlock lastBlock;
    private int nbSkippedLine;
    private char delimiter = (char)34;
    private char separator = (char)59;
    private int currentLineNumber;
    private List<Anomaly> currentAnomalies = new ArrayList<Anomaly>();
    private Charset charset;
    private int fieldMinLength;
    private int fieldMaxLength;

    public CSVSequenceReader(StandardDescription standard, OptionMap optionsMap, ControlMessages theControlMessages, StandardAccessor theModelAccessor, InputStream input) throws SaturneValidatorException {
        this.initalizeCsvSequenceReader(optionsMap, theControlMessages, theModelAccessor, input);
    }

    public CSVSequenceReader(StandardDescription standard, OptionMap optionsMap, ControlMessages theControlMessages, StandardAccessor theModelAccessor, InputStream input, CSVConfiguration csvFormat) throws SaturneValidatorException {
        if (csvFormat != null) {
            this.delimiter = csvFormat.getFieldDelimiter();
            this.separator = csvFormat.getSeparator();
            this.nbSkippedLine = csvFormat.getSkipLines();
        }
        this.initalizeCsvSequenceReader(optionsMap, theControlMessages, theModelAccessor, input);
    }

    private void initalizeCsvSequenceReader(OptionMap optionsMap, ControlMessages theControlMessages, StandardAccessor theModelAccessor, InputStream input) throws SaturneValidatorException {
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
        this.options = optionsMap;
        this.modelAccessor = theModelAccessor;
        this.controlMessages = theControlMessages;
        this.messageElementFactory = new MessageElementFactory(theModelAccessor);
        CSVParserBuilder parserBuilder = new CSVParserBuilder();
        CSVParser parser = parserBuilder.withSeparator(this.separator).withQuoteChar(this.delimiter).withEscapeChar('\\').withStrictQuotes(true).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build();
        HeaderResponse headerResponse = this.getEncodingAndNbLinesToSkip(theModelAccessor.getStandard(), input);
        this.charset = headerResponse.getCharset();
        if (this.nbSkippedLine < headerResponse.getNbLinesToSkip()) {
            this.nbSkippedLine = headerResponse.getNbLinesToSkip();
        }
        this.currentLineNumber = this.nbSkippedLine;
        this.reader = new CSVReader((Reader)new InputStreamReader(headerResponse.getBody(), this.charset), this.nbSkippedLine, parser);
        this.fieldMaxLength = this.maxLength(this.options);
        this.fieldMinLength = this.minLength(this.options);
    }

    @Override
    public IMessageBlock getNextBlock() throws SaturneValidatorException {
        if (this.lastBlock == null) {
            this.lastBlock = this.readNextBlock();
            if (this.lastBlock == null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new SaturneValidatorException(e);
                }
            }
        }
        return this.lastBlock;
    }

    @Override
    public void consummeBlock() {
        this.lastBlock = null;
    }

    @Override
    public OptionMap getOptions() {
        return this.options;
    }

    public Charset getCharset() {
        return this.charset;
    }

    private HeaderResponse getCharset(Standard standard, InputStream input, ValidatorEncodingHandler validatorEncodingHandler) throws SaturneValidatorException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)input, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        byte[] data = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        HeaderResponse result = new HeaderResponse();
        InputStreamReader isr = new InputStreamReader((InputStream)in, validatorEncodingHandler.getDefaultEncoding());
        try {
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (BufferedReader br = new BufferedReader(isr);){
                    String firstLine = this.readFirstNonEmptyLine(br, result);
                    if (firstLine != null) {
                        String[] fields = firstLine.split(String.valueOf(this.separator));
                        String candidate = fields[0];
                        candidate = candidate.replaceAll(String.valueOf(this.delimiter), "");
                        if (fields.length == 1 && candidate.trim().length() > 0 && this.isEncodingSupported(candidate)) {
                            result.setCharset(validatorEncodingHandler.getEncodingToUse(candidate, standard));
                            result.setNbLinesToSkip(result.getNbLinesToSkip() + 1);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                this.logger.warn(MSG_FIRST_LINE_READING_WARNING);
                try {
                    ((Reader)isr).close();
                }
                catch (IOException e) {
                    throw new SaturneValidatorException(e);
                }
                result.setBody(new ByteArrayInputStream(data));
            }
        }
        finally {
            try {
                ((Reader)isr).close();
            }
            catch (IOException e) {
                throw new SaturneValidatorException(e);
            }
            result.setBody(new ByteArrayInputStream(data));
        }
        return result;
    }

    private String readFirstNonEmptyLine(BufferedReader br, HeaderResponse response) throws IOException {
        String result = br.readLine();
        if (result != null && (result = result.trim()).length() == 0) {
            response.setNbLinesToSkip(response.getNbLinesToSkip() + 1);
            result = this.readFirstNonEmptyLine(br, response);
        }
        return result;
    }

    private boolean isEncodingSupported(String encoding) {
        boolean supported = false;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {}
        return supported;
    }

    private IMessageBlock readNextBlock() throws SaturneValidatorException {
        IMessageBlock result = null;
        String[] line = null;
        try {
            line = this.reader.readNext();
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        ++this.currentLineNumber;
        if (line != null) {
            if (line.length > 0) {
                result = this.readLine(line);
                if (result == null) {
                    result = this.readNextBlock();
                }
            } else {
                result = this.readNextBlock();
            }
        } else {
            this.attachPreviousAnomalies(this.lastBlock);
        }
        return result;
    }

    private IMessageBlock readLine(String[] line) throws SaturneValidatorException {
        MessageBlock result = null;
        if (line.length != 1 || line[0] != null) {
            Anomaly anomaly;
            String blockId = line[0];
            if (blockId != null) {
                if (this.modelAccessor.getBlock(blockId) != null) {
                    result = this.messageElementFactory.createMessageBlock(blockId.trim());
                    result.setFirstLine(this.currentLineNumber);
                    this.attachPreviousAnomalies(result);
                } else {
                    anomaly = new Anomaly(this.messageElementFactory.createMessageField(blockId, "", new LineAndColumnLocalizer(this.currentLineNumber, 0)), "CV13", this.controlMessages.getMessage("conversion.messages.CV13", new Object[]{blockId, this.currentLineNumber}), this.currentLineNumber, RuleCriticity.BLOCKING);
                    this.pushAnomaly(anomaly);
                }
            } else {
                anomaly = new Anomaly(this.messageElementFactory.createMessageField("", "", new LineAndColumnLocalizer(this.currentLineNumber, 0)), "CSV02", this.controlMessages.getMessage("conversion.messages.CSV02", new Object[]{this.currentLineNumber}), this.currentLineNumber, RuleCriticity.BLOCKING);
                this.pushAnomaly(anomaly);
            }
            if (line.length > 0 && result != null) {
                BlockDescription block = (BlockDescription)result.getStandardBlockDescription();
                List fields = block.getFields();
                if (fields.size() != line.length - 1 || line.length == 2 && line[1] == null) {
                    Anomaly anomaly2 = new Anomaly(this.messageElementFactory.createMessageField(blockId, "", new LineAndColumnLocalizer(this.currentLineNumber, 0)), "CSV01", this.controlMessages.getMessage("conversion.messages.CSV01", new Object[]{blockId, this.currentLineNumber}), this.currentLineNumber, RuleCriticity.BLOCKING);
                    this.addAnomalies(result, Stream.of(anomaly2).collect(Collectors.toList()));
                } else {
                    this.fillMessageBlock(line, result, fields);
                }
            }
        }
        return result;
    }

    private void fillMessageBlock(String[] line, IMessageBlock msgBlock, List<FieldDescription> fields) {
        int i = 0;
        while (i < fields.size()) {
            String value = line[i + 1];
            if (value != null) {
                MessageField<?> msgField = this.messageElementFactory.createMessageField(fields.get(i).getFullQualifiedId(), value, new LineAndColumnLocalizer(this.currentLineNumber, i + 2));
                msgBlock.addField(msgField);
                if (value.length() > this.fieldMaxLength || value.length() < this.fieldMinLength) {
                    Anomaly anomaly = new Anomaly(msgField, "CV02", this.controlMessages.getMessage("conversion.messages.CV02", new Object[]{this.fieldMinLength, this.fieldMaxLength}), this.currentLineNumber, RuleCriticity.BLOCKING);
                    this.addAnomalies(msgBlock, Stream.of(anomaly).collect(Collectors.toList()));
                }
            }
            ++i;
        }
    }

    private void attachPreviousAnomalies(IMessageBlock msgBlock) {
        List<Anomaly> anomalies = this.popAnomalies();
        if (!anomalies.isEmpty()) {
            this.addAnomalies(msgBlock, anomalies);
        }
    }

    private void addAnomalies(IMessageBlock msgBlock, List<Anomaly> anomalies) {
        ValidationInformation info = ((MessageBlock)msgBlock).getAnnotations().stream().filter(ValidationInformation.class::isInstance).map(ValidationInformation.class::cast).findFirst().orElse(null);
        if (info == null) {
            info = new ValidationInformation();
            ((MessageBlock)msgBlock).addAnnotation(info);
        }
        info.getAnomalies().addAll(anomalies);
    }

    private void pushAnomaly(Anomaly anomaly) {
        this.currentAnomalies.add(anomaly);
    }

    private List<Anomaly> popAnomalies() {
        List<Anomaly> result = this.currentAnomalies.stream().collect(Collectors.toList());
        this.currentAnomalies.clear();
        return result;
    }

    private int minLength(OptionMap opt) {
        Integer value = (Integer)opt.getOption(new Key("sequence.provider.min.length"));
        if (value == null) {
            value = 1;
        }
        return value;
    }

    private int maxLength(OptionMap opt) {
        Integer value = (Integer)opt.getOption(new Key("sequence.provider.max.length"));
        if (value == null) {
            value = 256;
        }
        return value;
    }

    private HeaderResponse getEncodingAndNbLinesToSkip(Standard standard, InputStream input) throws SaturneValidatorException {
        ValidatorEncodingHandler validatorEncodingHandler = new ValidatorEncodingHandler();
        HeaderResponse headerResponse = this.getCharset(standard, input, validatorEncodingHandler);
        Charset cs = headerResponse.getCharset();
        if (cs == null) {
            cs = validatorEncodingHandler.getEncodingToUse(standard);
            headerResponse.setCharset(cs);
        }
        return headerResponse;
    }

    private static class HeaderResponse {
        private Charset charset;
        private int nbLinesToSkip;
        private InputStream body;

        private HeaderResponse() {
        }

        public InputStream getBody() {
            return this.body;
        }

        public void setBody(InputStream body) {
            this.body = body;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }

        public int getNbLinesToSkip() {
            return this.nbLinesToSkip;
        }

        public void setNbLinesToSkip(int nbLinesToSkip) {
            this.nbLinesToSkip = nbLinesToSkip;
        }
    }
}

