/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.IContentHelper;
import fr.cnav.saturne.impl.FieldToValueMapImpl;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;

public abstract class AbstractContentHelper<T>
implements IContentHelper<T> {
    protected Map<EObject, Adapter> adapteursMap;
    protected SaturneItemProviderAdapterFactory saturneFactory;

    public AbstractContentHelper(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory) {
        this.adapteursMap = adapteursMap;
        this.saturneFactory = saturneFactory;
    }

    @Override
    public boolean hasChildren(T inputElt, MessageTreeObject currentMessageTreeObject) {
        return !this.getChildrenElt(inputElt, currentMessageTreeObject, false).isEmpty();
    }

    protected Standard getStandard(EObject eObject) {
        Standard result = null;
        if (eObject != null && eObject instanceof Standard) {
            result = (Standard)eObject;
        } else if (eObject != null) {
            result = this.getStandard(eObject.eContainer());
        }
        return result;
    }

    protected DeclarationBlock getParentDeclarationBlock(EObject obj) {
        DeclarationBlock declBlock = null;
        if (obj instanceof DeclarationBlock) {
            declBlock = (DeclarationBlock)obj;
        } else if (obj != null) {
            EObject eObj = obj;
            declBlock = this.getParentDeclarationBlock(eObj.eContainer());
        }
        return declBlock;
    }

    protected boolean hasParentDeclarationBlock(EObject obj) {
        return this.getParentDeclarationBlock(obj) != null;
    }

    protected boolean isDisplayed(EObject element, Declaration decl) {
        EObject parent = element.eContainer();
        boolean displayed = true;
        while (displayed && parent instanceof Block && !(parent instanceof DeclarationBlock)) {
            Block parentBlock = (Block)parent;
            BlockRefinement refinement = (BlockRefinement)decl.getBlockRefinements().get(parentBlock);
            displayed = refinement != null ? !UsageType.FORBIDDEN.equals((Object)refinement.getUsage()) && (refinement.getUpperBound() == null || refinement.getUpperBound().getNewBound() != 0) : !UsageType.FORBIDDEN.equals((Object)parentBlock.getUsage()) && parentBlock.getUpperBound() != 0;
            parent = parent.eContainer();
        }
        return displayed;
    }

    protected void registerAdapter(EObject obj, boolean registerAdapter) {
        if (obj == null || !registerAdapter) {
            return;
        }
        if (this.adapteursMap == null) {
            this.adapteursMap = new HashMap<EObject, Adapter>();
        }
        if (!this.adapteursMap.containsKey(obj)) {
            Adapter newAdapter = this.saturneFactory.createAdapter((Notifier)obj);
            obj.eAdapters().add((Object)newAdapter);
            this.adapteursMap.put(obj, newAdapter);
        }
    }

    protected void registerAdapterFieldToValueMap(Declaration declaration, boolean registerAdapter) {
        if (declaration == null || !registerAdapter || declaration.getKeyValues() == null || declaration.getKeyValues().entrySet() == null) {
            return;
        }
        if (this.adapteursMap == null) {
            this.adapteursMap = new HashMap<EObject, Adapter>();
        }
        for (Object fieldToValueMap : declaration.getKeyValues().entrySet()) {
            if (!(fieldToValueMap instanceof FieldToValueMapImpl) || this.adapteursMap.containsKey(fieldToValueMap)) continue;
            ((FieldToValueMapImpl)fieldToValueMap).eAdapters().add((Object)this.saturneFactory.createFieldToValueMapAdapter());
        }
    }

    protected boolean isFieldExistInDecl(MessageElement element, Declaration decl) {
        if (element != null) {
            boolean result = false;
            if (element instanceof Block) {
                Block block = (Block)element;
                if (decl.getUsage(element) == UsageType.FORBIDDEN) {
                    result = false;
                } else if (decl.getBlockUpperBound(block) == 0) {
                    result = false;
                } else if (element.eContainer() instanceof MessageElement) {
                    MessageElement parent = (MessageElement)element.eContainer();
                    result = this.isFieldExistInDecl(parent, decl);
                } else {
                    result = true;
                }
            } else if (element instanceof Message) {
                result = true;
            } else if (element instanceof Field) {
                if (element.eContainer() instanceof MessageElement) {
                    MessageElement parent = (MessageElement)element.eContainer();
                    result = this.isFieldExistInDecl(parent, decl);
                } else {
                    result = false;
                }
            }
            return result;
        }
        return false;
    }
}

