/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn;

import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;

public class MessageTreeDiagnosticDecorator
extends DiagnosticDecorator {
    private static final String IMG_SRC = "<img src='";
    private static final String DIV = "<div>";

    public MessageTreeDiagnosticDecorator(EditingDomain editingDomain, StructuredViewer viewer) {
        super(editingDomain, viewer);
    }

    public MessageTreeDiagnosticDecorator(EditingDomain editingDomain, StructuredViewer viewer, IDialogSettings dialogSettings) {
        super(editingDomain, viewer, dialogSettings);
    }

    public MessageTreeDiagnosticDecorator(ResourceSet resourceSet, StructuredViewer viewer) {
        super(resourceSet, viewer);
    }

    private Optional<MessageTreeObject> getMessageTreeObject(Object object) {
        if (object instanceof MessageTreeObject) {
            return Optional.of((MessageTreeObject)object);
        }
        return Optional.empty();
    }

    protected BasicDiagnostic getDiagnostic(Map<Object, BasicDiagnostic> objects, Object object, List<Integer> path) {
        Optional<MessageTreeObject> optionalObject = this.getMessageTreeObject(object);
        if (optionalObject.isPresent()) {
            return super.getDiagnostic(objects, optionalObject.get().getElement(), path);
        }
        return super.getDiagnostic(objects, object, path);
    }

    protected void buildToolTipText(StringBuilder result, ILabelProvider labelProvider, Diagnostic diagnostic, Object object) {
        Optional<MessageTreeObject> optionalObject = this.getMessageTreeObject(object);
        Object targetObject = object;
        if (optionalObject.isPresent()) {
            targetObject = optionalObject.get().getElement();
        }
        super.buildToolTipText(result, labelProvider, diagnostic, targetObject);
    }

    protected void buildToolTipMessage(StringBuilder result, ILabelProvider labelProvider, Object object, Diagnostic diagnostic, int indentation) {
        String message = diagnostic.getMessage();
        ImageDescriptor imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
        if (diagnostic.getSeverity() == 1) {
            imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(SaturneEditorPlugin.INSTANCE.getImage("full/ovr16/info_ovr.gif"));
        }
        URI severityURI = ImageURIRegistry.INSTANCE.getImageURI(imageDescriptor);
        result.append(DIV);
        int i = 0;
        while (i < indentation) {
            result.append("&#160;&#160;&#160;");
            ++i;
        }
        result.append(IMG_SRC);
        result.append(severityURI);
        result.append("'/> ");
        result.append(MessageTreeDiagnosticDecorator.escapeContent((String)message));
        result.append("</div>\n");
        for (Diagnostic child : diagnostic.getChildren()) {
            this.buildToolTipMessage(result, labelProvider, child.getData().get(0), child, indentation + 1);
        }
    }

    protected void buildMoreToolTipText(StringBuilder result, ILabelProvider labelProvider, Diagnostic diagnostic) {
        List data = diagnostic.getData();
        Object object = data.get(0);
        Optional<MessageTreeObject> optionalObject = this.getMessageTreeObject(object);
        Object targetObject = object;
        if (optionalObject.isPresent()) {
            targetObject = optionalObject.get().getElement();
        }
        List children = diagnostic.getChildren();
        Diagnostic child = (Diagnostic)children.get(0);
        int index = 0;
        if (child.getData().contains(targetObject)) {
            ++index;
            if (data.size() > 1) {
                result.append((CharSequence)this.buildValidationDiagToolTip(labelProvider.getImage(object), labelProvider.getText(object), (Integer[])data.get(1)));
                for (Diagnostic grandChild : child.getChildren()) {
                    this.buildToolTipMessage(result, labelProvider, object, grandChild, 1);
                }
            }
        }
        int size = children.size();
        while (index < size) {
            child = (Diagnostic)children.get(index);
            this.buildMoreToolTipText(result, labelProvider, child);
            ++index;
        }
    }

    private StringBuilder buildValidationDiagToolTip(Image objectImage, String objectLabel, Integer[] path) {
        StringBuilder result = new StringBuilder();
        String text = objectLabel;
        result.append(DIV);
        if (objectImage != null) {
            URI imageURI = ImageURIRegistry.INSTANCE.getImageURI(objectImage);
            result.append(IMG_SRC);
            result.append(imageURI);
            result.append("'/> ");
        }
        result.append("<a href='");
        result.append("path:");
        Integer[] integerArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            Integer segment = integerArray[n2];
            result.append('/');
            result.append(segment);
            ++n2;
        }
        if (text != null) {
            text = MessageTreeDiagnosticDecorator.escapeContent((String)objectLabel);
        }
        if (text == null || text.length() == 0) {
            text = "<i>null</i>";
        }
        result.append("'>");
        result.append(objectLabel);
        result.append("</a></div>\n");
        return result;
    }
}

