/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor;

import fr.cnav.saturne.BindingSet;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.CSVExternalDataTable;
import fr.cnav.saturne.DataSource;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.ForeignKeyBinding;
import fr.cnav.saturne.FunctionBinding;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.MessageElement;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.ReusedBlockSet;
import fr.cnav.saturne.ReusedField;
import fr.cnav.saturne.SaturnePackage;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.UsageType;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.provider.CSVExternalDataTableItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class MessageTreeLabelProvider
extends AdapterFactoryLabelProvider
implements IColorProvider {
    private static final String SEPARATOR = " - ";
    private AdapterFactoryLabelProvider labelProvider;

    public MessageTreeLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    }

    public Image getImage(Object element) {
        Image image = null;
        if (element instanceof MessageTreeObject) {
            Object msgElement = ((MessageTreeObject)element).getElement();
            if (msgElement instanceof DeclarationBlock) {
                image = this.labelProvider.getImage(msgElement);
            } else if (msgElement instanceof FieldRefinement) {
                image = this.labelProvider.getImage(msgElement);
            } else if (msgElement instanceof BlockRefinement) {
                image = this.labelProvider.getImage(msgElement);
            } else if (msgElement instanceof ReusedField) {
                image = this.labelProvider.getImage(msgElement);
            } else if (msgElement instanceof Field && ((MessageTreeObject)element).getDeclaration() != null) {
                Declaration declaration = ((MessageTreeObject)element).getDeclaration();
                Field field = (Field)msgElement;
                image = this.getFieldImage(field, declaration);
            } else if (msgElement instanceof Block && ((MessageTreeObject)element).getDeclaration() != null) {
                Declaration declaration = ((MessageTreeObject)element).getDeclaration();
                Block block = (Block)msgElement;
                image = this.getBlockImage(block, declaration);
            } else {
                image = this.labelProvider.getImage(msgElement);
            }
        } else if (element instanceof ReusedBlockSet) {
            image = this.labelProvider.getImage(element);
        }
        return image;
    }

    private Image getBlockImage(Block block, Declaration declaration) {
        BlockRefinement blockRefinement = (BlockRefinement)declaration.getBlockRefinements().get(block);
        UsageType blockRefinementUsage = UsageType.UNSET;
        if (blockRefinement != null) {
            blockRefinementUsage = blockRefinement.getUsage();
        }
        Block blockWithRefinementUsage = (Block)EcoreUtil.create((EClass)SaturnePackage.Literals.BLOCK);
        if (UsageType.UNSET.equals((Object)blockRefinementUsage)) {
            blockWithRefinementUsage.setUsage(block.getUsage());
        } else {
            blockWithRefinementUsage.setUsage(blockRefinementUsage);
        }
        return this.labelProvider.getImage((Object)blockWithRefinementUsage);
    }

    private Image getFieldImage(Field field, Declaration declaration) {
        FieldRefinement fieldRefinement = (FieldRefinement)declaration.getFieldRefinements().get(field);
        UsageType fieldRefinementUsage = UsageType.UNSET;
        if (fieldRefinement != null) {
            fieldRefinementUsage = fieldRefinement.getUsage();
        }
        Field fieldWithRefinementUsage = (Field)EcoreUtil.create((EClass)SaturnePackage.Literals.FIELD);
        if (fieldRefinementUsage == UsageType.UNSET) {
            fieldWithRefinementUsage.setUsage(field.getUsage());
        } else {
            fieldWithRefinementUsage.setUsage(fieldRefinementUsage);
        }
        return this.labelProvider.getImage((Object)fieldWithRefinementUsage);
    }

    public String getText(Object element) {
        String label = null;
        if (element instanceof MessageTreeObject) {
            Declaration decl = ((MessageTreeObject)element).getDeclaration();
            EObject msgElement = (EObject)((MessageTreeObject)element).getElement();
            if (msgElement instanceof Standard) {
                Standard standard = (Standard)msgElement;
                label = standard.getName();
            } else if (msgElement instanceof DeclarationBlock) {
                DeclarationBlock block = (DeclarationBlock)msgElement;
                StringBuilder builder = new StringBuilder();
                builder.append(block.getFullQualifiedId()).append(SEPARATOR).append(decl.getName());
                label = builder.toString();
            } else if (msgElement instanceof Declaration) {
                Declaration declaration = (Declaration)msgElement;
                label = declaration.getName();
            } else if (msgElement instanceof Block) {
                Block block = (Block)msgElement;
                int lb = ((Block)msgElement).getLowerBound();
                int ub = ((Block)msgElement).getUpperBound();
                if (decl != null) {
                    lb = decl.getBlockLowerBound(block);
                    ub = decl.getBlockUpperBound(block);
                }
                String upperBound = String.valueOf(ub);
                if (ub == -1) {
                    upperBound = "*";
                }
                StringBuilder builder = new StringBuilder();
                builder.append(block.getFullQualifiedId()).append(SEPARATOR).append(block.getName()).append(" (").append(lb).append(',').append(upperBound).append(')');
                label = builder.toString();
            } else if (msgElement instanceof Field) {
                Field field = (Field)msgElement;
                StringBuilder builder = new StringBuilder();
                builder.append(field.getId()).append(SEPARATOR).append(field.getName());
                label = builder.toString();
            } else if (msgElement instanceof FieldRefinement) {
                FieldRefinement fieldRefinement = (FieldRefinement)msgElement;
                StringBuilder builder = new StringBuilder();
                builder.append(fieldRefinement.getField().getId()).append(SEPARATOR).append(fieldRefinement.getField().getName());
                label = builder.toString();
            } else if (msgElement instanceof BlockRefinement) {
                BlockRefinement blockRefinement = (BlockRefinement)msgElement;
                Block block = blockRefinement.getBlock();
                int lb = decl.getBlockLowerBound(block);
                int ub = decl.getBlockUpperBound(block);
                String upperBound = String.valueOf(ub);
                if (ub == -1) {
                    upperBound = "*";
                }
                StringBuilder builder = new StringBuilder();
                builder.append(block.getFullQualifiedId()).append(SEPARATOR).append(block.getName()).append(" (").append(lb).append(',').append(upperBound).append(')');
                label = builder.toString();
            } else if (msgElement instanceof GenericRule) {
                GenericRule genericRule = (GenericRule)msgElement;
                StringBuilder builder = new StringBuilder();
                builder.append(genericRule.getFullId());
                label = builder.toString();
            } else if (msgElement instanceof DataType) {
                StringBuilder builder = new StringBuilder();
                builder.append(((DataType)msgElement).getName());
                label = builder.toString();
            } else if (msgElement instanceof Value) {
                Value value = (Value)msgElement;
                StringBuilder builder = new StringBuilder();
                builder.append(value.getId()).append(SEPARATOR).append(value.getName());
                label = builder.toString();
            } else if (msgElement instanceof ExternalDataTable) {
                ExternalDataTable extDataTable = (ExternalDataTable)msgElement;
                DataSource dataSource = extDataTable.getDataSource();
                if (dataSource != null) {
                    label = this.getDataSourceLabel(dataSource, extDataTable);
                }
            } else if (msgElement instanceof ReusedBlockSet) {
                StringBuilder builder = new StringBuilder();
                builder.append("ReusedBlocks");
                label = builder.toString();
            } else if (msgElement instanceof ReusedBlock) {
                ReusedBlock reusedBlock = (ReusedBlock)msgElement;
                StringBuilder builder = new StringBuilder();
                builder.append(reusedBlock.getName());
                label = builder.toString();
            } else if (msgElement instanceof BindingSet) {
                label = "Binding Set";
            } else if (msgElement instanceof ForeignKeyBinding) {
                label = "Foreign Key Binding";
            } else if (msgElement instanceof FunctionBinding) {
                label = "Function Binding";
            }
        } else {
            super.getText(element);
        }
        return label;
    }

    private String getDataSourceLabel(DataSource dataSource, ExternalDataTable extDataTable) {
        StringBuilder builder = new StringBuilder();
        if (extDataTable instanceof CSVExternalDataTable) {
            CSVExternalDataTableItemProvider csvExternalDataTableItemProvider = new CSVExternalDataTableItemProvider(this.getAdapterFactory());
            builder.append(csvExternalDataTableItemProvider.getText((Object)extDataTable));
        } else {
            builder.append(dataSource.getName());
        }
        String label = builder.toString();
        return label;
    }

    public Color getForeground(Object object) {
        Color result = null;
        if (object instanceof MessageTreeObject) {
            MessageTreeObject messageTreeObject = (MessageTreeObject)object;
            Object element = messageTreeObject.getElement();
            Declaration declaration = messageTreeObject.getDeclaration();
            result = this.getMessageTreeObjectForeground(messageTreeObject, element, declaration);
        }
        if (result == null) {
            return super.getForeground(object);
        }
        return result;
    }

    private Color getMessageTreeObjectForeground(MessageTreeObject messageTreeObject, Object element, Declaration declaration) {
        Color result = null;
        if (this.isForbiddenFieldRefinement(element, declaration)) {
            result = Display.getCurrent().getSystemColor(15);
        } else if (element instanceof Field && UsageType.FORBIDDEN == ((Field)element).getUsage()) {
            result = Display.getCurrent().getSystemColor(15);
        } else if (this.isForbiddenBlock(element)) {
            result = Display.getCurrent().getSystemColor(15);
        } else if (this.isForbiddenBlockRefinement(element, declaration)) {
            result = Display.getCurrent().getSystemColor(15);
        } else if (element instanceof GenericRule && declaration != null && messageTreeObject.getParentElement() instanceof Field) {
            result = this.getRuleForeground(messageTreeObject, element, declaration);
        }
        return result;
    }

    private boolean isForbiddenFieldRefinement(Object element, Declaration declaration) {
        return element instanceof FieldRefinement && UsageType.FORBIDDEN == declaration.getUsage((MessageElement)((FieldRefinement)element).getField());
    }

    private boolean isForbiddenBlock(Object element) {
        return element instanceof Block && (UsageType.FORBIDDEN == ((Block)element).getUsage() || ((Block)element).getUpperBound() == 0);
    }

    private boolean isForbiddenBlockRefinement(Object element, Declaration declaration) {
        return element instanceof BlockRefinement && (UsageType.FORBIDDEN == declaration.getUsage((MessageElement)((BlockRefinement)element).getBlock()) || declaration.getBlockUpperBound(((BlockRefinement)element).getBlock()) == 0);
    }

    private Color getRuleForeground(MessageTreeObject messageTreeObject, Object element, Declaration declaration) {
        Color result = null;
        GenericRule genericRule = (GenericRule)element;
        boolean isGenericRuleInhibited = declaration.getRefinements().stream().anyMatch(refinement -> refinement.getInhibitedRules().contains((Object)genericRule));
        if (isGenericRuleInhibited) {
            result = Display.getCurrent().getSystemColor(15);
        }
        return result;
    }
}

