/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Cst02ForbiddenChildrenSyntaxControl
extends AbstractBlockSyntaxControl {
    private final Set<String> authorizedBlockNames;

    public Cst02ForbiddenChildrenSyntaxControl(int id, String code, BlockDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.authorizedBlockNames = this.getAuthorizedBlockNames(target);
    }

    private Set<String> getAuthorizedBlockNames(BlockDescription block) {
        HashSet<String> result = new HashSet<String>();
        for (BlockDescription child : block.getChildrenBlocks()) {
            if (this.declaration != null && this.declaration.getBlockUpperBound(child) <= 0) continue;
            result.add(child.getFullQualifiedId());
        }
        return result;
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        IRuleResult result = IRule.SUCCESS;
        ArrayList<IMessageBlock> contextContents = new ArrayList<IMessageBlock>();
        if (context.getStandardBlockDescription() instanceof BlockDescription) {
            int numberOfBlock = ((BlockDescription)context.getStandardBlockDescription()).getChildrenBlocks().size();
            int i = 0;
            while (i < numberOfBlock) {
                contextContents.addAll(context.getBlock(i));
                ++i;
            }
            int contextContentSize = contextContents.size();
            int i2 = 0;
            while (i2 < contextContentSize) {
                IMessageBlock currentBlock = (IMessageBlock)contextContents.get(i2);
                String sgName = currentBlock.getStandardBlockDescription().getFullQualifiedId();
                if (!this.authorizedBlockNames.contains(sgName)) {
                    IMessageField<?> firstMsgField = this.getFirstField(context);
                    String message = this.controlMessage.getMessage("syntactic.messages.CST02_2", new Object[]{sgName, this.declaration.getName()});
                    result = new RuleFailure(this, firstMsgField, firstMsgField.getParent(), message);
                }
                ++i2;
            }
        }
        return result;
    }

    private IMessageField<?> getFirstField(IMessageBlock block) {
        IMessageField<?> firstMessageField = null;
        if (block.getStandardBlockDescription() instanceof BlockDescription) {
            int numberOfField = ((BlockDescription)block.getStandardBlockDescription()).getFields().size();
            int i = 0;
            while (i < numberOfField) {
                IMessageField<?> currentMessageField = block.getField(i);
                if (currentMessageField != null && (firstMessageField == null || currentMessageField.getFieldLocalizer().getLineNumber() < firstMessageField.getFieldLocalizer().getLineNumber())) {
                    firstMessageField = currentMessageField;
                }
                ++i;
            }
        }
        return firstMessageField;
    }
}

