/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import fr.cnav.saturne.validator.syntax.MessageExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Cst01SyntaxControl
extends AbstractBlockSyntaxControl {
    public Cst01SyntaxControl(int id, String code, BlockDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        IRuleResult result = IRule.SUCCESS;
        String fullQualifiedId = null;
        ArrayList<IMessageBlock> children = new ArrayList<IMessageBlock>();
        for (List<IMessageBlock> childList : context.getChildren()) {
            children.addAll(childList);
        }
        HashMap<IMessageBlock, Integer> messageBlockToIndex = new HashMap<IMessageBlock, Integer>();
        int index = 0;
        for (IMessageBlock messageBlock : children) {
            messageBlockToIndex.put(messageBlock, index);
            ++index;
        }
        List<IMessageBlock> orderedMessageBlocks = this.getOrderedContextContents(children);
        int i = 0;
        while (i < children.size() - 1) {
            IMessageBlock element = orderedMessageBlocks.get(i);
            IMessageBlock nextElement = orderedMessageBlocks.get(i + 1);
            if ((Integer)messageBlockToIndex.get(element) > (Integer)messageBlockToIndex.get(nextElement)) {
                fullQualifiedId = nextElement.getStandardBlockDescription().getFullQualifiedId();
                IMessageField<?> lastReadField = this.getLastFieldReadBefore(nextElement);
                String previousCategoryFullQualifiedId = lastReadField == null ? null : lastReadField.getStandardFieldDescription().getFullQualifiedId();
                String message = null;
                message = previousCategoryFullQualifiedId != null ? this.controlMessage.getMessage("syntactic.messages.CST01", new Object[]{fullQualifiedId, previousCategoryFullQualifiedId}) : this.controlMessage.getMessage("syntactic.messages.CST01_2", new Object[]{fullQualifiedId});
                IMessageField<?> firstRubrique = MessageExtractor.getFirstField(nextElement);
                messageBlockToIndex.clear();
                return new RuleFailure(this, firstRubrique, firstRubrique.getParent(), message);
            }
            ++i;
        }
        messageBlockToIndex.clear();
        return result;
    }

    private List<IMessageBlock> getOrderedContextContents(List<IMessageBlock> children) {
        IMessageBlock[] content = new IMessageBlock[children.size()];
        children.toArray(content);
        Arrays.sort(content, 0, content.length, new Comparator<IMessageBlock>(){

            @Override
            public int compare(IMessageBlock o1, IMessageBlock o2) {
                return o1.getFirstLine() - o2.getFirstLine();
            }
        });
        return Stream.of(content).collect(Collectors.toList());
    }
}

