/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractFieldSyntaxControl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Csl01SyntaxControl
extends AbstractFieldSyntaxControl {
    private final int miniLengthLimit;
    private final int maxLengthLimit;
    private final String fullQualifiedId;

    public Csl01SyntaxControl(int id, String code, FieldDescription target, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, code, target, controlMessage, declaration);
        this.fullQualifiedId = target.getFullQualifiedId();
        this.miniLengthLimit = target.getDataType().getMinLength();
        this.maxLengthLimit = target.getDataType().getMaxLength();
    }

    @Override
    public List<FieldDescription> getUsedData() {
        if (this.getTarget() instanceof FieldDescription) {
            return Stream.of((FieldDescription)this.getTarget()).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
        }
        return new ArrayList<FieldDescription>();
    }

    @Override
    public IRuleResult run(IMessageField<?> subject) {
        IRuleResult result = IRule.SUCCESS;
        boolean miniLengthViolation = false;
        boolean maxLengthViolation = false;
        String value = subject.getValueAsString();
        String message = null;
        if (value != null && !"".equals(subject.getValueAsString())) {
            int valueLength = value.length();
            if (valueLength < this.miniLengthLimit) {
                message = this.controlMessage.getMessage("syntactic.messages.CSL01_MINI", new Object[]{this.fullQualifiedId, this.miniLengthLimit});
                miniLengthViolation = true;
            } else if (valueLength > this.maxLengthLimit) {
                message = this.controlMessage.getMessage("syntactic.messages.CSL01_MAXI", new Object[]{this.fullQualifiedId, this.maxLengthLimit});
                maxLengthViolation = true;
            }
            if (!miniLengthViolation && !maxLengthViolation) {
                result = IRule.SUCCESS;
            } else {
                RuleFailure resultFailure = new RuleFailure(this, subject, subject.getParent(), message);
                result = resultFailure;
            }
        }
        return result;
    }
}

