/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.report.impl;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import fr.cnav.saturne.report.model.ContextField;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.impl.ConfigurationDsn;
import fr.cnav.saturne.validator.report.impl.DsnAnomalyComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class DsnXmlSerializer {
    private static final String EMPTY_STRING = "";
    private static final String LIBELLE = "libelle";
    private static final String RUBRIQUE_DECLENCHANTE = "rubrique_declenchante";
    private static final String VALEUR = "valeur";
    private static final String VALEURS = "valeurs";
    private static final String NUMERO_LIGNE = "numero_ligne";
    private static final String MESSAGE = "message";
    private static final String BLOQUANT = "bloquant";
    private static final String NON_BLOQUANT = "non-bloquant";
    private static final String CATEGORIE = "categorie";
    private static final String CODE = "code";
    private static final String DESCRIPTION = "description";
    private static final String NOMBRE = "nombre";
    private static final String ENVOI_CATEGORIE = "envoi_categorie";
    private static final String ENVOI_COMPTEURS = "envoi_compteurs";
    private static final String IDENTIFIANT = "identifiant";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI = "xsi";
    private final XMLStreamWriter writer;
    private final Context report;
    private final IReportLogger reportLogger;
    private int nbAnoBloquante;
    private int nbAnoNonbloquante;
    private StandardAccessor accessor;

    public DsnXmlSerializer(XMLStreamWriter writer, IReportLogger reportLogger, StandardAccessor accessor) {
        this.writer = writer;
        this.report = reportLogger.getReport().getRootContext();
        this.reportLogger = reportLogger;
        this.accessor = accessor;
    }

    public void serialize() throws XMLStreamException {
        this.serializeHeader();
        this.serializeEnvoiIdentification();
        this.serializeEnvoiBilan();
        this.serializeEnvoiAnomalies();
        List<Context> secondLevelContexts = this.report.getContextChildren();
        for (Context secondLevelContext : secondLevelContexts) {
            this.serializeSecondLevelContext(secondLevelContext);
        }
        this.serializeFooter();
    }

    private void serializeHeader() throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeComment("Version : " + this.accessor.getStandard().getDescription());
        this.writer.writeComment("Date : " + ConfigurationDsn.getTimeStamp());
        this.writer.setPrefix("gipmds", "http://www.gip-mds.fr/");
        this.writer.setPrefix(XSI, XML_SCHEMA);
        this.writer.writeStartElement("http://www.gip-mds.fr/", "rapport");
        this.writer.writeAttribute("profil", "DSN");
        this.writer.writeAttribute("type", "BAN");
        this.writer.writeAttribute("version", "v01r06");
        this.writer.writeAttribute(XSI, XML_SCHEMA, "schemaLocation", "http://www.gip-mds.fr/dsn_bilans_v01r06.xsd");
        this.writer.writeNamespace("gipmds", "http://www.gip-mds.fr/");
        this.writer.writeNamespace(XSI, XML_SCHEMA);
    }

    private void serializeEnvoiIdentification() throws XMLStreamException {
        String messageID = this.reportLogger.getCustomAttributeValue("fr.cnav.saturne.validator.report.validationIdAttributeKey");
        List<ContextField> categories = this.report.getContextFields();
        this.writer.writeStartElement("envoi");
        this.writer.writeStartElement("envoi_identification");
        this.writer.writeStartElement(IDENTIFIANT);
        if (messageID != null) {
            this.writeCharactersAndNullValue(messageID);
        }
        this.writer.writeEndElement();
        String version_norme = EMPTY_STRING;
        String point_de_depot = EMPTY_STRING;
        String type_envoi = EMPTY_STRING;
        String essai_reel = EMPTY_STRING;
        String emetteur_siren = EMPTY_STRING;
        String emetteur_nic = EMPTY_STRING;
        String nom_logiciel = EMPTY_STRING;
        String editeur_logiciel = EMPTY_STRING;
        String version_logiciel = EMPTY_STRING;
        for (ContextField category : categories) {
            if (category.getReportSerializationName().equals("version_norme") && category.getValue() != null) {
                version_norme = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("point_de_depot") && category.getValue() != null) {
                point_de_depot = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("type_envoi") && category.getValue() != null) {
                type_envoi = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("essai_reel") && category.getValue() != null) {
                essai_reel = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("siren") && category.getValue() != null) {
                emetteur_siren = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("nic") && category.getValue() != null) {
                emetteur_nic = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("nom_logiciel") && category.getValue() != null) {
                nom_logiciel = category.getValue();
                continue;
            }
            if (category.getReportSerializationName().equals("editeur_logiciel") && category.getValue() != null) {
                editeur_logiciel = category.getValue();
                continue;
            }
            if (!category.getReportSerializationName().equals("version_logiciel") || category.getValue() == null) continue;
            version_logiciel = category.getValue();
        }
        if (!EMPTY_STRING.equals(version_norme)) {
            this.writer.writeStartElement("version_norme");
            this.writeCharactersAndNullValue(version_norme);
            this.writer.writeEndElement();
        }
        if (!EMPTY_STRING.equals(point_de_depot)) {
            this.writer.writeStartElement("point_de_depot");
            this.writeCharactersAndNullValue(point_de_depot);
            this.writer.writeEndElement();
        }
        if (!EMPTY_STRING.equals(type_envoi)) {
            this.writer.writeStartElement("type_envoi");
            this.writeCharactersAndNullValue(type_envoi);
            this.writer.writeEndElement();
        }
        if (!EMPTY_STRING.equals(essai_reel)) {
            this.writer.writeStartElement("essai_reel");
            this.writeCharactersAndNullValue(essai_reel);
            this.writer.writeEndElement();
        }
        this.writer.writeStartElement("emetteur_siret");
        this.writeCharactersAndNullValue(String.valueOf(emetteur_siren) + emetteur_nic);
        this.writer.writeEndElement();
        if (!EMPTY_STRING.equals(nom_logiciel)) {
            this.writer.writeStartElement("nom_logiciel");
            this.writeCharactersAndNullValue(nom_logiciel);
            this.writer.writeEndElement();
        }
        if (!EMPTY_STRING.equals(editeur_logiciel)) {
            this.writer.writeStartElement("editeur_logiciel");
            this.writeCharactersAndNullValue(editeur_logiciel);
            this.writer.writeEndElement();
        }
        if (!EMPTY_STRING.equals(editeur_logiciel)) {
            this.writer.writeStartElement("version_logiciel");
            this.writeCharactersAndNullValue(version_logiciel);
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private void serializeEnvoiBilan() throws XMLStreamException {
        List<Context> declarations = this.report.getContextChildren();
        int nbAnoDeclaration = 0;
        for (Context context : declarations) {
            nbAnoDeclaration += this.calculateDeclarationAnomaliesNumber(context);
        }
        int nbAnoEnvoi = 0;
        List<Anomaly> envoiAnomalies = this.report.getAnomalies();
        for (Anomaly anomaly : envoiAnomalies) {
            nbAnoEnvoi += anomaly.getNumber();
        }
        int nbAnoTotal = nbAnoEnvoi + nbAnoDeclaration;
        this.writer.writeStartElement("envoi_bilan");
        this.writer.writeStartElement("envoi_etat");
        if (this.isReportValid(this.report)) {
            this.writer.writeCharacters("OK");
        } else {
            this.writer.writeCharacters("KO");
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement("envoi_contenu");
        this.writer.writeStartElement("declarations");
        this.writeCharactersAndNullValue(Integer.toString(declarations.size()));
        this.writer.writeEndElement();
        this.writer.writeStartElement("salaries");
        this.writeCharactersAndNullValue(Integer.toString(this.getThirdLevelContextNumber(this.report)));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement(ENVOI_COMPTEURS);
        this.writer.writeStartElement(ENVOI_CATEGORIE);
        this.writeCharactersAndNullValue("generale");
        this.writer.writeEndElement();
        this.writer.writeStartElement(NOMBRE);
        this.writeCharactersAndNullValue(Integer.toString(nbAnoEnvoi));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement(ENVOI_COMPTEURS);
        this.writer.writeStartElement(ENVOI_CATEGORIE);
        this.writeCharactersAndNullValue("declaration");
        this.writer.writeEndElement();
        this.writer.writeStartElement(NOMBRE);
        this.writeCharactersAndNullValue(Integer.toString(nbAnoDeclaration));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement(ENVOI_COMPTEURS);
        this.writer.writeStartElement(ENVOI_CATEGORIE);
        this.writeCharactersAndNullValue("total");
        this.writer.writeEndElement();
        this.writer.writeStartElement(NOMBRE);
        this.writeCharactersAndNullValue(Integer.toString(nbAnoTotal));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    private boolean isReportValid(Context reportToCheck) {
        boolean reportIsValid = false;
        if (reportToCheck.isValid()) {
            Iterator<Context> iterator = reportToCheck.getContextChildren().iterator();
            while (iterator.hasNext() && !reportIsValid) {
                Context context = iterator.next();
                this.nbAnoBloquante = 0;
                this.nbAnoNonbloquante = 0;
                this.calculatesBlockingAndNoBlockingAnomaliesNumbers(context, 2);
                if (!context.isValid() || this.nbAnoBloquante != 0) continue;
                reportIsValid = true;
            }
        }
        return reportIsValid;
    }

    private int calculateDeclarationAnomaliesNumber(Context context) {
        int anomaliesNumber = 0;
        List<Anomaly> anomalies = context.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            anomaliesNumber += anomaly.getNumber();
        }
        List<Context> contextChildren = context.getContextChildren();
        for (Context subContext : contextChildren) {
            anomaliesNumber += this.calculateDeclarationAnomaliesNumber(subContext);
        }
        return anomaliesNumber;
    }

    private int getThirdLevelContextNumber(Context rootContext) {
        List<Context> subContexts = rootContext.getContextChildren();
        int thirdLevelContextNumber = 0;
        for (Context subContext : subContexts) {
            thirdLevelContextNumber += subContext.getContextChildren().size();
        }
        return thirdLevelContextNumber;
    }

    private void serializeEnvoiAnomalies() throws XMLStreamException {
        for (Anomaly anomaly : this.report.getAnomalies()) {
            this.writer.writeStartElement("envoi_anomalie");
            this.writer.writeStartElement(DESCRIPTION);
            this.writer.writeStartElement(CODE);
            this.writeCharactersAndNullValue(anomaly.getCode());
            this.writer.writeEndElement();
            this.writer.writeStartElement(CATEGORIE);
            if (!anomaly.isBlocking()) {
                this.writeCharactersAndNullValue(NON_BLOQUANT);
            } else {
                this.writeCharactersAndNullValue(BLOQUANT);
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement(MESSAGE);
            this.writeCharactersAndNullValue(anomaly.getMessage());
            this.writer.writeEndElement();
            if (anomaly.getFieldLocalizer().getLineNumber() != 0) {
                this.writer.writeStartElement(NUMERO_LIGNE);
                this.writeCharactersAndNullValue(Integer.toString(anomaly.getFieldLocalizer().getLineNumber()));
                this.writer.writeEndElement();
            }
            if (anomaly.getNumber() > 1) {
                this.writer.writeStartElement(NOMBRE);
                this.writeCharactersAndNullValue(Integer.toString(anomaly.getNumber()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement(VALEURS);
            this.writer.writeStartElement(RUBRIQUE_DECLENCHANTE);
            if (anomaly.getFieldId() != null) {
                this.writer.writeStartElement(IDENTIFIANT);
                this.writer.writeCharacters(anomaly.getFieldId());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(IDENTIFIANT);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (anomaly.getFieldLabel() != null) {
                this.writer.writeStartElement(LIBELLE);
                this.writer.writeCharacters(anomaly.getFieldLabel());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(LIBELLE);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (anomaly.getFieldValue() != null) {
                this.writer.writeStartElement(VALEUR);
                this.writer.writeCharacters(anomaly.getFieldValue());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(VALEUR);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
    }

    private Map<String, Integer> calculateSubContextNumber(Context context) {
        List<Context> contextChildren = context.getContextChildren();
        HashMap<String, Integer> contextSerialisationNameToContextNumber = new HashMap<String, Integer>();
        Set<String> directSubContextSerializationNames = this.reportLogger.geReportContextDescriptor().getDirectSubContextSerializationNames(context);
        for (String directSubContextSerializationName : directSubContextSerializationNames) {
            contextSerialisationNameToContextNumber.put(directSubContextSerializationName, 0);
        }
        for (Context subcontext : contextChildren) {
            Integer subContextNumber;
            Integer n = subContextNumber = (Integer)contextSerialisationNameToContextNumber.get(subcontext.getName());
            subContextNumber = n + 1;
            contextSerialisationNameToContextNumber.put(subcontext.getName(), n);
        }
        return contextSerialisationNameToContextNumber;
    }

    private void serializeSecondLevelContext(Context secondLevelContext) throws XMLStreamException {
        List<ContextField> categories = secondLevelContext.getContextFields();
        String rangDeclaration = Integer.toString(secondLevelContext.getRank());
        this.nbAnoBloquante = 0;
        this.nbAnoNonbloquante = 0;
        this.calculatesBlockingAndNoBlockingAnomaliesNumbers(secondLevelContext, 2);
        this.writer.writeStartElement(secondLevelContext.getName());
        this.writer.writeStartElement(String.valueOf(secondLevelContext.getName()) + "_identification");
        this.writer.writeStartElement("rang");
        this.writeCharactersAndNullValue(rangDeclaration);
        this.writer.writeEndElement();
        ContextField contextFieldSiren = null;
        ContextField contextFieldNicSiege = null;
        ContextField contextFieldNicAffection = null;
        for (ContextField contextField : categories) {
            if (contextField.getReportSerializationName().equals("nic_siege")) {
                contextFieldNicSiege = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equals("nic_affectation")) {
                contextFieldNicAffection = contextField;
                continue;
            }
            if (contextField.getReportSerializationName().equals("SIREN")) {
                contextFieldSiren = contextField;
                continue;
            }
            this.writer.writeStartElement(contextField.getReportSerializationName());
            this.writeCharactersAndNullValue(contextField.getValue());
            this.writer.writeEndElement();
        }
        if (contextFieldSiren == null) {
            this.writer.writeStartElement("SIREN");
            this.writeCharactersAndNullValue(EMPTY_STRING);
            this.writer.writeEndElement();
        } else {
            this.writer.writeStartElement(contextFieldSiren.getReportSerializationName());
            this.writeCharactersAndNullValue(contextFieldSiren.getValue());
            this.writer.writeEndElement();
        }
        if (contextFieldNicSiege == null) {
            this.writer.writeStartElement("nic_siege");
            this.writeCharactersAndNullValue(EMPTY_STRING);
            this.writer.writeEndElement();
        } else {
            this.writer.writeStartElement(contextFieldNicSiege.getReportSerializationName());
            this.writeCharactersAndNullValue(contextFieldNicSiege.getValue());
            this.writer.writeEndElement();
        }
        if (contextFieldNicAffection == null) {
            this.writer.writeStartElement("nic_affectation");
            this.writeCharactersAndNullValue(EMPTY_STRING);
            this.writer.writeEndElement();
        } else {
            this.writer.writeStartElement(contextFieldNicAffection.getReportSerializationName());
            this.writeCharactersAndNullValue(contextFieldNicAffection.getValue());
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement(String.valueOf(secondLevelContext.getName()) + "_bilan");
        this.writer.writeStartElement("etat");
        if (this.nbAnoBloquante == 0 && secondLevelContext.isValid() && (this.report.getAnomalies().size() <= 0 || !"LIM000".equals(this.report.getAnomalies().get(this.report.getAnomalies().size() - 1).getCode()))) {
            this.writer.writeCharacters("OK");
        } else {
            this.writer.writeCharacters("KO");
        }
        this.writer.writeEndElement();
        this.writer.writeStartElement(String.valueOf(secondLevelContext.getName()) + "_contenu");
        Map<String, Integer> reportSerializationNameToNumberInContext = this.calculateSubContextNumber(secondLevelContext);
        if (reportSerializationNameToNumberInContext.isEmpty()) {
            throw new IllegalStateException("The norm model should have a third level context for the second level one.");
        }
        String thirdLevelContextReportSerializationName = reportSerializationNameToNumberInContext.keySet().iterator().next();
        this.writer.writeStartElement(String.valueOf(thirdLevelContextReportSerializationName) + "s");
        this.writeCharactersAndNullValue(Integer.toString(secondLevelContext.getContextChildren().size()));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("declaration_compteurs");
        this.writer.writeStartElement(CATEGORIE);
        this.writeCharactersAndNullValue(BLOQUANT);
        this.writer.writeEndElement();
        this.writer.writeStartElement(NOMBRE);
        this.writeCharactersAndNullValue(Integer.toString(this.nbAnoBloquante));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeStartElement("declaration_compteurs");
        this.writer.writeStartElement(CATEGORIE);
        this.writeCharactersAndNullValue(NON_BLOQUANT);
        this.writer.writeEndElement();
        this.writer.writeStartElement(NOMBRE);
        this.writeCharactersAndNullValue(Integer.toString(this.nbAnoNonbloquante));
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        List<Anomaly> anomalies = secondLevelContext.getAnomalies();
        Collections.sort(anomalies, new DsnAnomalyComparator());
        for (Anomaly currentAnomaly : anomalies) {
            String codeAnomalie = currentAnomaly.getCode() == null || EMPTY_STRING.equals(currentAnomaly.getCode()) ? EMPTY_STRING : currentAnomaly.getCode();
            String bloquantAnomalie = !currentAnomaly.isBlocking() ? NON_BLOQUANT : BLOQUANT;
            String messageAnomalie = currentAnomaly.getMessage() == null || EMPTY_STRING.equals(currentAnomaly.getMessage()) ? EMPTY_STRING : currentAnomaly.getMessage();
            String numeroLigneAnomalie = String.valueOf(currentAnomaly.getFieldLocalizer().getLineNumber());
            this.writer.writeStartElement("declaration_anomalie");
            this.writer.writeStartElement(DESCRIPTION);
            this.writer.writeStartElement(CODE);
            this.writeCharactersAndNullValue(codeAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement(CATEGORIE);
            this.writeCharactersAndNullValue(bloquantAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement(MESSAGE);
            this.writeCharactersAndNullValue(messageAnomalie);
            this.writer.writeEndElement();
            if (!EMPTY_STRING.equals(numeroLigneAnomalie)) {
                this.writer.writeStartElement(NUMERO_LIGNE);
                this.writeCharactersAndNullValue(numeroLigneAnomalie);
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getNumber() > 1) {
                this.writer.writeStartElement(NOMBRE);
                this.writeCharactersAndNullValue(Integer.toString(currentAnomaly.getNumber()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement(VALEURS);
            this.writer.writeStartElement(RUBRIQUE_DECLENCHANTE);
            if (currentAnomaly.getFieldId() != null) {
                this.writer.writeStartElement(IDENTIFIANT);
                this.writer.writeCharacters(currentAnomaly.getFieldId());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(IDENTIFIANT);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldLabel() != null) {
                this.writer.writeStartElement(LIBELLE);
                this.writer.writeCharacters(currentAnomaly.getFieldLabel());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(LIBELLE);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldValue() != null) {
                this.writer.writeStartElement(VALEUR);
                this.writer.writeCharacters(currentAnomaly.getFieldValue());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(VALEUR);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        List<Context> employeeContexts = secondLevelContext.getContextChildren();
        for (Context employeeContext : employeeContexts) {
            this.serializesDeclarationAnomalies(thirdLevelContextReportSerializationName, employeeContext, null);
            List<Context> contractContexts = employeeContext.getContextChildren();
            for (Context contractContext : contractContexts) {
                this.serializesDeclarationAnomalies(thirdLevelContextReportSerializationName, employeeContext, contractContext);
            }
        }
        this.writer.writeEndElement();
    }

    private void serializesDeclarationAnomalies(String contextReportSerializationName, Context employeeContext, Context contractContext) throws XMLStreamException {
        List<ContextField> employeeContextFields = employeeContext.getContextFields();
        List<Anomaly> anomalies = contractContext == null ? employeeContext.getAnomalies() : contractContext.getAnomalies();
        for (Anomaly currentAnomaly : anomalies) {
            String codeAnomalie = currentAnomaly.getCode() == null || EMPTY_STRING.equals(currentAnomaly.getCode()) ? EMPTY_STRING : currentAnomaly.getCode();
            String bloquantAnomalie = !currentAnomaly.isBlocking() ? NON_BLOQUANT : BLOQUANT;
            String messageAnomalie = currentAnomaly.getMessage() == null || EMPTY_STRING.equals(currentAnomaly.getMessage()) ? EMPTY_STRING : currentAnomaly.getMessage();
            String numeroLigneAnomalie = String.valueOf(currentAnomaly.getFieldLocalizer().getLineNumber());
            this.writer.writeStartElement("declaration_anomalie");
            this.writer.writeStartElement(DESCRIPTION);
            this.writer.writeStartElement(CODE);
            this.writeCharactersAndNullValue(codeAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement(CATEGORIE);
            this.writeCharactersAndNullValue(bloquantAnomalie);
            this.writer.writeEndElement();
            this.writer.writeStartElement(MESSAGE);
            this.writeCharactersAndNullValue(messageAnomalie);
            this.writer.writeEndElement();
            if (!EMPTY_STRING.equals(numeroLigneAnomalie)) {
                this.writer.writeStartElement(NUMERO_LIGNE);
                this.writeCharactersAndNullValue(numeroLigneAnomalie);
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getNumber() > 1) {
                this.writer.writeStartElement(NOMBRE);
                this.writeCharactersAndNullValue(Integer.toString(currentAnomaly.getNumber()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeStartElement(VALEURS);
            this.writer.writeStartElement(RUBRIQUE_DECLENCHANTE);
            if (currentAnomaly.getFieldId() != null) {
                this.writer.writeStartElement(IDENTIFIANT);
                this.writer.writeCharacters(currentAnomaly.getFieldId());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(IDENTIFIANT);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldLabel() != null) {
                this.writer.writeStartElement(LIBELLE);
                this.writer.writeCharacters(currentAnomaly.getFieldLabel());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(LIBELLE);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            if (currentAnomaly.getFieldValue() != null) {
                this.writer.writeStartElement(VALEUR);
                this.writer.writeCharacters(currentAnomaly.getFieldValue());
                this.writer.writeEndElement();
            } else {
                this.writer.writeStartElement(VALEUR);
                this.writer.writeCharacters("rubrique absente dans le fichier");
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            if (currentAnomaly.getFieldId() != null) {
                this.writer.writeStartElement("environnement");
                this.writer.writeStartElement(contextReportSerializationName);
                this.writer.writeAttribute("origine", this.reportLogger.getReport().getNormUri());
                String nir = EMPTY_STRING;
                String nomUsage = EMPTY_STRING;
                String nomFamille = EMPTY_STRING;
                String prenoms = EMPTY_STRING;
                String sexe = EMPTY_STRING;
                String dateNaissance = EMPTY_STRING;
                String lieuNaissance = EMPTY_STRING;
                String codePays = EMPTY_STRING;
                String matricule = EMPTY_STRING;
                String rang = String.valueOf(employeeContext.getRank());
                String ntt = EMPTY_STRING;
                String dateDebutContrat = EMPTY_STRING;
                String numeroContrat = EMPTY_STRING;
                for (ContextField employeeContextField : employeeContextFields) {
                    if (employeeContextField.getReportSerializationName().equals("NIR") && employeeContextField.getValue() != null) {
                        nir = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("nom_usage") && employeeContextField.getValue() != null) {
                        nomUsage = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("nom_famille") && employeeContextField.getValue() != null) {
                        nomFamille = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("prenoms") && employeeContextField.getValue() != null) {
                        prenoms = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("sexe") && employeeContextField.getValue() != null) {
                        sexe = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("date_naissance") && employeeContextField.getValue() != null) {
                        dateNaissance = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("lieu_naissance") && employeeContextField.getValue() != null) {
                        lieuNaissance = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("code_pays") && employeeContextField.getValue() != null) {
                        codePays = employeeContextField.getValue();
                    }
                    if (employeeContextField.getReportSerializationName().equals("matricule") && employeeContextField.getValue() != null) {
                        matricule = employeeContextField.getValue();
                    }
                    if (!employeeContextField.getReportSerializationName().equals("NTT") || employeeContextField.getValue() == null) continue;
                    ntt = employeeContextField.getValue();
                }
                if (contractContext != null) {
                    List<ContextField> contractContextFields = contractContext.getContextFields();
                    for (ContextField field : contractContextFields) {
                        if (field.getReportSerializationName().equals(ConfigurationDsn.REPORT_RUB_SALARIE_DATE_DEBUT_CONTRAT) && field.getValue() != null) {
                            dateDebutContrat = field.getValue();
                        }
                        if (!field.getReportSerializationName().equals(ConfigurationDsn.REPORT_RUB_SALARIE_DATE_NUMERO_CONTRAT) || field.getValue() == null) continue;
                        numeroContrat = field.getValue();
                    }
                }
                if (!EMPTY_STRING.equals(nir)) {
                    this.writer.writeStartElement("NIR");
                    this.writeCharactersAndNullValue(nir);
                    this.writer.writeEndElement();
                } else if (!EMPTY_STRING.equals(ntt)) {
                    this.writer.writeStartElement("NTT");
                    this.writeCharactersAndNullValue(ntt);
                    this.writer.writeEndElement();
                } else {
                    this.writer.writeStartElement("NIR");
                    this.writeCharactersAndNullValue("rubrique absente dans le fichier");
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(nomFamille)) {
                    this.writer.writeStartElement("nom_famille");
                    this.writeCharactersAndNullValue(nomFamille);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(nomUsage)) {
                    this.writer.writeStartElement("nom_usage");
                    this.writeCharactersAndNullValue(nomUsage);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(prenoms)) {
                    this.writer.writeStartElement("prenoms");
                    this.writeCharactersAndNullValue(prenoms);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(sexe)) {
                    this.writer.writeStartElement("sexe");
                    this.writeCharactersAndNullValue(sexe);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(dateNaissance)) {
                    this.writer.writeStartElement("date_naissance");
                    this.writeCharactersAndNullValue(dateNaissance);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(lieuNaissance)) {
                    this.writer.writeStartElement("lieu_naissance");
                    this.writeCharactersAndNullValue(lieuNaissance);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(codePays)) {
                    this.writer.writeStartElement("code_pays");
                    this.writeCharactersAndNullValue(codePays);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(matricule)) {
                    this.writer.writeStartElement("matricule");
                    this.writeCharactersAndNullValue(matricule);
                    this.writer.writeEndElement();
                }
                if (!EMPTY_STRING.equals(rang)) {
                    this.writer.writeStartElement("rang");
                    this.writeCharactersAndNullValue(rang);
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
                if (!EMPTY_STRING.equals(dateDebutContrat)) {
                    this.writer.writeStartElement("contrat");
                    this.writer.writeStartElement("date_debut_contrat");
                    this.writeCharactersAndNullValue(dateDebutContrat);
                    this.writer.writeEndElement();
                    this.writer.writeStartElement("num_contrat");
                    if (!EMPTY_STRING.equals(numeroContrat)) {
                        this.writeCharactersAndNullValue(numeroContrat);
                    } else {
                        this.writeCharactersAndNullValue("rubrique absente dans le fichier");
                    }
                    this.writer.writeEndElement();
                    this.writer.writeEndElement();
                }
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
        }
    }

    private void calculatesBlockingAndNoBlockingAnomaliesNumbers(Context secondLevelContext, int level) {
        List<Anomaly> anomalies = secondLevelContext.getAnomalies();
        for (Anomaly anomaly : anomalies) {
            if (!anomaly.isBlocking()) {
                this.nbAnoNonbloquante += anomaly.getNumber();
                continue;
            }
            this.nbAnoBloquante += anomaly.getNumber();
        }
        if (level <= 3) {
            List<Context> subContexts = secondLevelContext.getContextChildren();
            for (Context context : subContexts) {
                this.calculatesBlockingAndNoBlockingAnomaliesNumbers(context, level + 1);
            }
        }
    }

    private void serializeFooter() throws XMLStreamException {
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
        this.writer.flush();
    }

    private void writeCharactersAndNullValue(String text) throws XMLStreamException {
        if (text != null) {
            this.writer.writeCharacters(text);
        } else {
            this.writer.writeCharacters(EMPTY_STRING);
        }
    }
}

