/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.conversion;

import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.Anomaly;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.ValidationInformation;
import fr.cnav.saturne.validator.impl.LineAndColumnLocalizer;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FooterEnum;
import fr.cnav.saturne.validator.positional.FooterSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.HeaderEnum;
import fr.cnav.saturne.validator.positional.HeaderSpecification;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.conversion.AbstractIdExtractor;
import fr.cnav.saturne.validator.positional.conversion.FileReaderException;
import fr.cnav.saturne.validator.positional.conversion.GenericIdExtractor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;

public class PositionalFixSequenceReader
implements ISequenceProvider {
    private static final String ID_EXTRACTOR_INITIALIZATION_FAIL_MESSAGE = "The id extractor initialization has failed. Be sure that you have given the right qualified name for the class to use as id extractor. The current qualified name is :";
    private static final String SEPARATOR = " : ";
    private static final String CANNOT_INSTANTIATE = "Cannot instantiate ";
    private final BufferedReader reader;
    private final OptionMap options;
    private final StandardAccessor modelAccessor;
    private final ControlMessages controlMessages;
    private boolean currentRecordAllRead;
    private int indexCurrentFieldInCorrespondingRecord;
    private int headerFieldIndex;
    private RecordSpecification currentRecordSpecification;
    private int fieldNumber;
    private int footerFieldIndex;
    private FormatSpecification formatSpecification;
    private EList<HeaderSpecification> headerSpecificationList;
    private EList<FooterSpecification> footerSpecificationList;
    private AbstractIdExtractor idExtractor;
    private IMessageBlock lastBlock;
    private List<Anomaly> currentAnomalies = new ArrayList<Anomaly>();
    private int currentLineNumber;
    private final MessageElementFactory messageElementFactory;
    private String blockId;
    private Map<String, RunAutomaton> regexpCache = new HashMap<String, RunAutomaton>();

    public PositionalFixSequenceReader(FormatSpecification theFormatSpecification, OptionMap optionsMap, ControlMessages controlMessages, StandardAccessor theModelAccessor, InputStream input, Charset charset) {
        this.options = optionsMap;
        this.modelAccessor = theModelAccessor;
        this.controlMessages = controlMessages;
        this.reader = new BufferedReader(new InputStreamReader(input, charset));
        this.messageElementFactory = new MessageElementFactory(theModelAccessor);
        this.currentRecordAllRead = true;
        this.indexCurrentFieldInCorrespondingRecord = -1;
        this.currentRecordSpecification = null;
        this.headerFieldIndex = 0;
        this.footerFieldIndex = 0;
        this.fieldNumber = 0;
        this.formatSpecification = theFormatSpecification;
        this.headerSpecificationList = this.formatSpecification.getHeaderSpecifications();
        this.footerSpecificationList = this.formatSpecification.getFooterSpecifications();
        this.currentLineNumber = 0;
        String idExtractorClassName = this.formatSpecification.getIdExtractorClassName();
        this.idExtractor = idExtractorClassName != null && !"".equals(idExtractorClassName) ? (AbstractIdExtractor)this.instantiate(idExtractorClassName, input) : new GenericIdExtractor(this.formatSpecification, input);
    }

    @Override
    public OptionMap getOptions() {
        return this.options;
    }

    @Override
    public IMessageBlock getNextBlock() throws SaturneValidatorException {
        if (this.lastBlock == null) {
            this.lastBlock = this.readNextBlock();
            if (this.lastBlock == null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new SaturneValidatorException(e);
                }
            }
        }
        return this.lastBlock;
    }

    @Override
    public void consummeBlock() {
        this.lastBlock = null;
    }

    private IMessageBlock readNextBlock() throws SaturneValidatorException {
        IMessageBlock result = null;
        String readLineResult = null;
        if (this.headerSpecificationList.size() > 0 && this.headerFieldIndex == 0) {
            return this.getHeaderBlock();
        }
        try {
            readLineResult = this.reader.readLine();
        }
        catch (IOException e) {
            throw new SaturneValidatorException(e);
        }
        ++this.currentLineNumber;
        if (readLineResult != null) {
            if (readLineResult.length() > 0) {
                result = this.readLine(readLineResult);
                while (result == null) {
                    result = this.readNextBlock();
                }
            } else {
                result = this.readNextBlock();
            }
        } else if (this.footerSpecificationList.size() > 0 && this.footerFieldIndex == 0) {
            result = this.getFooterBlock();
        } else if (this.lastBlock != null) {
            this.attachPreviousAnomalies(this.lastBlock);
        } else if (!this.currentAnomalies.isEmpty()) {
            result = this.messageElementFactory.createMessageBlock(this.modelAccessor.getStandard().getMessage().getFooterBlock().getFullQualifiedId().trim());
            this.attachPreviousAnomalies(result);
            --this.currentLineNumber;
        }
        return result;
    }

    private IMessageBlock getHeaderBlock() {
        MessageBlock headerBlock = this.messageElementFactory.createMessageBlock(this.modelAccessor.getStandard().getMessage().getHeaderBlock().getFullQualifiedId().trim());
        headerBlock.setFirstLine(this.currentLineNumber);
        while (this.headerSpecificationList.size() > this.headerFieldIndex) {
            IMessageField<?> resultField = this.getCurrentFieldWithHeaderField();
            ++this.headerFieldIndex;
            headerBlock.addField(resultField);
            ++this.fieldNumber;
        }
        return headerBlock;
    }

    private IMessageBlock getFooterBlock() {
        MessageBlock footerBlock = this.messageElementFactory.createMessageBlock(this.modelAccessor.getStandard().getMessage().getFooterBlock().getFullQualifiedId().trim());
        footerBlock.setFirstLine(this.currentLineNumber);
        while (this.footerSpecificationList.size() > this.footerFieldIndex) {
            IMessageField<?> resultField = this.getCurrentFieldWithFooterField();
            ++this.footerFieldIndex;
            footerBlock.addField(resultField);
        }
        MessageBlock result = footerBlock;
        return result;
    }

    private IMessageBlock readLine(String line) throws SaturneValidatorException {
        MessageBlock result = null;
        this.updateCurrentRecordSpecification(line);
        if (this.blockId != null && this.currentRecordSpecification != null) {
            if (this.modelAccessor.getBlock(this.blockId) != null) {
                result = this.messageElementFactory.createMessageBlock(this.blockId.trim());
                result.setFirstLine(this.currentLineNumber);
                this.attachPreviousAnomalies(result);
            } else {
                this.createUnknownBlockAnomaly();
            }
        } else if (this.blockId == null) {
            this.createPFXAnomaly("PF01", null, new Object[]{this.currentLineNumber, this.blockId}, RuleCriticity.BLOCKING);
        }
        if (result != null) {
            this.fillMessageBlock(line, result);
        }
        return result;
    }

    private void createUnknownBlockAnomaly() {
        Anomaly anomaly = null;
        if (this.blockId != null) {
            anomaly = new Anomaly(this.messageElementFactory.createMessageField(this.blockId, "", new LineAndColumnLocalizer(this.currentLineNumber, 0)), "CV13", this.controlMessages.getMessage("conversion.messages.CV13", new Object[]{this.blockId, this.currentLineNumber}), this.currentLineNumber, RuleCriticity.BLOCKING);
            this.pushAnomaly(anomaly);
        }
    }

    private Object instantiate(String idExtractorQualifiedName, InputStream inputStream) {
        Object result = null;
        Class idExtractorClass = (Class)this.options.getOption(new Key("fr.cnav.saturne.validator.positional.idExtractor"));
        if (idExtractorClass == null) {
            throw new FileReaderException(ID_EXTRACTOR_INITIALIZATION_FAIL_MESSAGE + idExtractorQualifiedName);
        }
        try {
            Constructor c = idExtractorClass.getDeclaredConstructor(FormatSpecification.class, InputStream.class);
            result = c.newInstance(this.formatSpecification, inputStream);
        }
        catch (InstantiationException e) {
            String message = CANNOT_INSTANTIATE + idExtractorClass.getName() + SEPARATOR + e.getMessage();
            throw new FileReaderException(message, e);
        }
        catch (IllegalAccessException e) {
            String message = "Access to " + idExtractorClass.getName() + " forbidden : " + e.getMessage();
            throw new FileReaderException(message, e);
        }
        catch (NoSuchMethodException e) {
            String message = "Access to " + idExtractorClass.getName() + " forbidden : " + e.getMessage();
            throw new FileReaderException(message, e);
        }
        catch (IllegalArgumentException e) {
            String message = CANNOT_INSTANTIATE + idExtractorClass.getName() + SEPARATOR + e.getMessage();
            throw new FileReaderException(message, e);
        }
        catch (InvocationTargetException e) {
            String message = CANNOT_INSTANTIATE + idExtractorClass.getName() + SEPARATOR + e.getMessage();
            throw new FileReaderException(message, e);
        }
        return result;
    }

    private RecordSpecification getRecordSpecification(String line) {
        RecordSpecification result = null;
        if (!this.formatSpecification.getIdSpecifications().isEmpty() && ((RecordIdSpecification)this.formatSpecification.getIdSpecifications().get(0)).getRecordTypeEndPosition() == -1) {
            result = this.getUniqueRecordSpecification();
        } else {
            RecordSpecification recordSpecification;
            this.blockId = this.idExtractor.extractId(this.currentLineNumber, line);
            if (this.blockId != null) {
                this.blockId = this.blockId.trim();
            }
            if ((recordSpecification = this.formatSpecification.getRecordSpecification(this.blockId)) == null) {
                this.createPFXAnomaly("PF03", null, new Object[]{this.currentLineNumber, this.blockId}, RuleCriticity.BLOCKING);
                result = null;
            } else {
                result = recordSpecification;
            }
        }
        return result;
    }

    private void createPFXAnomaly(String anomalyCode, String optionalMessage, Object[] messageParameters, RuleCriticity criticity) {
        String optionalMessageNotNull = "";
        if (optionalMessage != null) {
            optionalMessageNotNull = optionalMessage;
        }
        MessageField<?> emptyMessageField = this.messageElementFactory.createMessageField(this.blockId, "", new LineAndColumnLocalizer(this.currentLineNumber, 0));
        Anomaly anomaly = new Anomaly(emptyMessageField, anomalyCode, String.valueOf(this.controlMessages.getMessage("conversion.messages." + anomalyCode, messageParameters)) + " " + optionalMessageNotNull, this.currentLineNumber, criticity);
        this.pushAnomaly(anomaly);
    }

    private RecordSpecification getUniqueRecordSpecification() {
        EList<RecordSpecification> records = this.formatSpecification.getRecords();
        if (records.size() == 0) {
            throw new IllegalArgumentException("The positional format model must have at least one record specification.");
        }
        RecordSpecification result = (RecordSpecification)records.get(0);
        Block block = result.getBlock();
        if (block != null) {
            this.blockId = block.getId();
        }
        return result;
    }

    private IMessageField<?> getCurrentFieldWithHeaderField() {
        MessageField<?> msgField = null;
        HeaderSpecification headerSpecification = (HeaderSpecification)this.headerSpecificationList.get(this.headerFieldIndex);
        if (HeaderEnum.NORM_VERSION.equals((Object)headerSpecification.getCalculatedFieldType())) {
            msgField = this.messageElementFactory.createMessageField(headerSpecification.getField().getFullQualifiedId(), this.modelAccessor.getStandard().getVersion(), new LineAndColumnLocalizer(this.currentLineNumber, 0));
        } else if (HeaderEnum.NORM_NAME.equals((Object)headerSpecification.getCalculatedFieldType())) {
            msgField = this.messageElementFactory.createMessageField(headerSpecification.getField().getFullQualifiedId(), this.modelAccessor.getStandard().getName(), new LineAndColumnLocalizer(this.currentLineNumber, 0));
        } else if (HeaderEnum.VALIDATION_DATE.equals((Object)headerSpecification.getCalculatedFieldType())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            msgField = this.messageElementFactory.createMessageField(headerSpecification.getField().getFullQualifiedId(), dateFormat.format(cal.getTime()), new LineAndColumnLocalizer(this.currentLineNumber, 0));
        }
        return msgField;
    }

    private void updateCurrentRecordSpecification(String line) {
        this.currentRecordSpecification = this.getRecordSpecification(line);
        if (this.currentRecordSpecification != null) {
            this.indexCurrentFieldInCorrespondingRecord = -1;
            this.currentRecordAllRead = false;
        }
    }

    private void fillMessageBlock(String line, IMessageBlock msgBlock) {
        MessageField<?> resultField = null;
        while (!this.currentRecordAllRead) {
            String fieldValue;
            ++this.indexCurrentFieldInCorrespondingRecord;
            if (this.currentRecordSpecification.getFields().size() - 1 == this.indexCurrentFieldInCorrespondingRecord) {
                this.currentRecordAllRead = true;
            }
            FieldSpecification nextFieldSpecification = (FieldSpecification)this.currentRecordSpecification.getFields().get(this.indexCurrentFieldInCorrespondingRecord);
            int fieldEndPosition = nextFieldSpecification.getEndPosition();
            int fieldStartPosition = nextFieldSpecification.getStartPosition();
            if (fieldStartPosition < 1 || fieldStartPosition > fieldEndPosition) {
                throw new IllegalArgumentException("The positional information of the field specification must have a start and end position superior to zero. It also must have a end position superior to the start position.");
            }
            if (line.length() < fieldStartPosition) continue;
            if (line.length() < fieldEndPosition) {
                fieldEndPosition = line.length();
            }
            if (this.isFieldMustBeConsideredAsAbsent(nextFieldSpecification, fieldValue = line.substring(fieldStartPosition - 1, fieldEndPosition))) continue;
            String trimmingCharacter = this.formatSpecification.getTrimmingCharacter();
            String trimmedValue = fieldValue;
            if (trimmingCharacter != null && !trimmingCharacter.isEmpty()) {
                trimmedValue = this.trim(fieldValue, trimmingCharacter.charAt(0));
            }
            resultField = this.messageElementFactory.createMessageField(nextFieldSpecification.getField().getFullQualifiedId(), trimmedValue, new LineAndColumnLocalizer(this.currentLineNumber, fieldStartPosition));
            msgBlock.addField(resultField);
            ++this.fieldNumber;
        }
    }

    public String trim(String textToTrim, char trimmingCharacter) {
        int len = textToTrim.length();
        int beginIndex = 0;
        int endIndex = len;
        boolean trimFinished = false;
        while (beginIndex < endIndex && !trimFinished) {
            if (trimmingCharacter == textToTrim.charAt(beginIndex)) {
                ++beginIndex;
                continue;
            }
            trimFinished = true;
        }
        trimFinished = false;
        while (beginIndex < endIndex && !trimFinished) {
            if (trimmingCharacter == textToTrim.charAt(endIndex - 1)) {
                --endIndex;
                continue;
            }
            trimFinished = true;
        }
        return beginIndex > 0 || endIndex < len ? textToTrim.substring(beginIndex, endIndex) : textToTrim;
    }

    private boolean isFieldMustBeConsideredAsAbsent(FieldSpecification nextFieldSpecification, String fieldValue) {
        boolean isFieldAbsent = false;
        if (this.formatSpecification.isConvertEmptyField()) {
            return isFieldAbsent;
        }
        if (nextFieldSpecification.getField() != null && nextFieldSpecification.getField().getDataType() != null) {
            NatureType fieldNature = nextFieldSpecification.getField().getDataType().getNature();
            String regexAbsent = nextFieldSpecification.getEmptyRegex();
            if (regexAbsent == null || "".equals(regexAbsent)) {
                regexAbsent = this.formatSpecification.getRegexFromNature(fieldNature);
            }
            if (regexAbsent != null) {
                if (!this.regexpCache.containsKey(regexAbsent)) {
                    RegExp regex = new RegExp(regexAbsent);
                    RunAutomaton automaton = new RunAutomaton(regex.toAutomaton());
                    this.regexpCache.put(regexAbsent, automaton);
                }
                if (this.regexpCache.get(regexAbsent).run(fieldValue)) {
                    isFieldAbsent = true;
                }
            }
        }
        return isFieldAbsent;
    }

    private IMessageField<?> getCurrentFieldWithFooterField() {
        MessageField<?> result = null;
        FooterSpecification footerSpecification = (FooterSpecification)this.footerSpecificationList.get(this.footerFieldIndex);
        if (FooterEnum.FIELDS_NUMBER.equals((Object)footerSpecification.getCalculatedFieldType())) {
            result = this.messageElementFactory.createMessageField(footerSpecification.getField().getFullQualifiedId(), String.valueOf(this.fieldNumber), new LineAndColumnLocalizer(this.currentLineNumber, 0));
        }
        return result;
    }

    private void attachPreviousAnomalies(IMessageBlock msgBlock) {
        List<Anomaly> anomalies = this.popAnomalies();
        if (!anomalies.isEmpty()) {
            this.addAnomalies(msgBlock, anomalies);
        }
    }

    private void addAnomalies(IMessageBlock msgBlock, List<Anomaly> anomalies) {
        ValidationInformation info = ((MessageBlock)msgBlock).getAnnotations().stream().filter(ValidationInformation.class::isInstance).map(ValidationInformation.class::cast).findFirst().orElse(null);
        if (info == null) {
            info = new ValidationInformation();
            ((MessageBlock)msgBlock).addAnnotation(info);
        }
        info.getAnomalies().addAll(anomalies);
    }

    private void pushAnomaly(Anomaly anomaly) {
        this.currentAnomalies.add(anomaly);
    }

    private List<Anomaly> popAnomalies() {
        List<Anomaly> result = this.currentAnomalies.stream().collect(Collectors.toList());
        this.currentAnomalies.clear();
        return result;
    }
}

