/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.message;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.message.MessageProvider;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import java.util.HashSet;
import java.util.Set;

public class MessageWithListProvider
extends MessageProvider {
    private Set<IMessageBlock> messageAncestorsBlockToConsume;
    private Set<IMessageBlock> fullMessageBlockToConsume;
    private boolean isContainedInFullMessageToConsume;

    public MessageWithListProvider(StandardAccessor modelAccessor) {
        this(modelAccessor, new HashSet<IMessageBlock>(), new HashSet<IMessageBlock>());
    }

    public MessageWithListProvider(StandardAccessor modelAccessor, Set<IMessageBlock> theAncestorsMessageBlockToConsume, Set<IMessageBlock> theFullMessageBlockToConsume) {
        super(modelAccessor);
        this.messageAncestorsBlockToConsume = theAncestorsMessageBlockToConsume;
        this.fullMessageBlockToConsume = theFullMessageBlockToConsume;
    }

    @Override
    protected void notifiesExitBlock(IMessageBlock messageBlock) throws TreeProcessingException {
        super.notifiesExitBlock(messageBlock);
        if (this.fullMessageBlockToConsume.contains(messageBlock)) {
            this.isContainedInFullMessageToConsume = false;
        }
    }

    @Override
    protected void notifiesChildBlocks(IMessageBlock messageBlock) throws TreeProcessingException {
        if (this.fullMessageBlockToConsume.contains(messageBlock)) {
            this.isContainedInFullMessageToConsume = true;
            super.notifiesChildBlocks(messageBlock);
        } else if (this.isContainedInFullMessageToConsume || this.messageAncestorsBlockToConsume.contains(messageBlock)) {
            super.notifiesChildBlocks(messageBlock);
        }
    }
}

