/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.parser;

import fr.cnav.saturne.dsl.formules.Add;
import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Date;
import fr.cnav.saturne.dsl.formules.Diff;
import fr.cnav.saturne.dsl.formules.Div;
import fr.cnav.saturne.dsl.formules.Equals;
import fr.cnav.saturne.dsl.formules.Equiv;
import fr.cnav.saturne.dsl.formules.Error;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesPackage;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Greater;
import fr.cnav.saturne.dsl.formules.GreaterEqual;
import fr.cnav.saturne.dsl.formules.Imply;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Lower;
import fr.cnav.saturne.dsl.formules.LowerEqual;
import fr.cnav.saturne.dsl.formules.Mult;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Num;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Quantifier;
import fr.cnav.saturne.dsl.formules.Sub;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.parser.FormuleTraducteurException;
import fr.cnav.saturne.dsl.parser.FormulesListener;
import fr.cnav.saturne.dsl.parser.FormulesParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ASTFormulesListener
implements FormulesListener {
    private Stack<Object> childrenStack = new Stack();
    private FormulesParser parser;

    public ASTFormulesListener(FormulesParser parser) {
        this.parser = parser;
    }

    public Expression getAST() throws FormuleTraducteurException {
        Expression result = (Expression)this.pop();
        if (this.childrenStack.isEmpty()) {
            return result;
        }
        throw new FormuleTraducteurException("Parsing failed;");
    }

    public void enterEveryRule(ParserRuleContext arg0) {
    }

    public void exitEveryRule(ParserRuleContext arg0) {
    }

    public void visitErrorNode(ErrorNode arg0) {
    }

    public void visitTerminal(TerminalNode arg0) {
    }

    @Override
    public void enterEntry(FormulesParser.EntryContext ctx) {
    }

    @Override
    public void exitEntry(FormulesParser.EntryContext ctx) {
    }

    @Override
    public void enterFormule(FormulesParser.FormuleContext ctx) {
    }

    @Override
    public void exitFormule(FormulesParser.FormuleContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on parsing formule expression") : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterLetExpr(FormulesParser.LetExprContext ctx) {
    }

    @Override
    public void exitLetExpr(FormulesParser.LetExprContext ctx) {
        Let result = (Let)EcoreUtil.create((EClass)FormulesPackage.Literals.LET);
        Expression body = (Expression)this.pop();
        result.setIn(body);
        Iterator<FormulesParser.BindingContext> iterator = ctx.binding().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            result.getBindings().add((Object)((Binding)this.pop()));
        }
        ECollections.reverse(result.getBindings());
        this.childrenStack.push(result);
    }

    @Override
    public void enterBinding(FormulesParser.BindingContext ctx) {
    }

    @Override
    public void exitBinding(FormulesParser.BindingContext ctx) {
        Binding result = (Binding)EcoreUtil.create((EClass)FormulesPackage.Literals.BINDING);
        result.setVarName(ctx.FIELD().getText());
        Expression exp = (Expression)this.pop();
        result.setExpr(exp);
        this.childrenStack.push(result);
    }

    @Override
    public void enterQuantifiedExpr(FormulesParser.QuantifiedExprContext ctx) {
    }

    @Override
    public void exitQuantifiedExpr(FormulesParser.QuantifiedExprContext ctx) {
        Quantified result = (Quantified)EcoreUtil.create((EClass)FormulesPackage.Literals.QUANTIFIED);
        Expression body = (Expression)this.pop();
        result.setExpression(body);
        result.setQuantifier(Quantifier.getByName(ctx.QUANTIFIER().getText().toUpperCase()));
        List iteratorVariables = (List)this.pop();
        result.getVariables().addAll((Collection)iteratorVariables);
        this.childrenStack.push(result);
    }

    @Override
    public void enterVariableDeclElt1(FormulesParser.VariableDeclElt1Context ctx) {
    }

    @Override
    public void exitVariableDeclElt1(FormulesParser.VariableDeclElt1Context ctx) {
        ArrayList<IteratorVariable> vars = new ArrayList<IteratorVariable>();
        IteratorVariable itVar = (IteratorVariable)EcoreUtil.create((EClass)FormulesPackage.Literals.ITERATOR_VARIABLE);
        itVar.setVarName("self");
        itVar.setElement((FieldRef)this.pop());
        vars.add(itVar);
        this.childrenStack.push(vars);
    }

    @Override
    public void enterVariableDeclElt1Elt2(FormulesParser.VariableDeclElt1Elt2Context ctx) {
    }

    @Override
    public void exitVariableDeclElt1Elt2(FormulesParser.VariableDeclElt1Elt2Context ctx) {
        ArrayList<IteratorVariable> vars = new ArrayList<IteratorVariable>();
        int i = ctx.element().size() - 1;
        while (i >= 0) {
            IteratorVariable itVar = (IteratorVariable)EcoreUtil.create((EClass)FormulesPackage.Literals.ITERATOR_VARIABLE);
            itVar.setVarName(ctx.FIELD(i).getText());
            itVar.setElement((FieldRef)this.pop());
            vars.add(itVar);
            --i;
        }
        Collections.reverse(vars);
        this.childrenStack.push(vars);
    }

    @Override
    public void enterLogicalExpr(FormulesParser.LogicalExprContext ctx) {
    }

    @Override
    public void exitLogicalExpr(FormulesParser.LogicalExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on parsing logical expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else if (ctx.logicalExpr() != null) {
            result = "=>".equals(ctx.CONNECTOR().getText()) ? (Imply)EcoreUtil.create((EClass)FormulesPackage.Literals.IMPLY) : (Equiv)EcoreUtil.create((EClass)FormulesPackage.Literals.EQUIV);
            ((Binary)result).setRightOp((Expression)this.pop());
            ((Binary)result).setLeftOp((Expression)this.pop());
        } else {
            result = (Expression)this.pop();
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterOrExpr(FormulesParser.OrExprContext ctx) {
    }

    @Override
    public void exitOrExpr(FormulesParser.OrExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on parsing or expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else if (ctx.orExpr() != null) {
            result = (Or)EcoreUtil.create((EClass)FormulesPackage.Literals.OR);
            Expression rightOp = (Expression)this.pop();
            Expression leftOp = (Expression)this.pop();
            result.getOperands().add((Object)leftOp);
            ((Or)result).getOperands().add((Object)rightOp);
        } else {
            result = (Expression)this.pop();
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterAndExpr(FormulesParser.AndExprContext ctx) {
    }

    @Override
    public void exitAndExpr(FormulesParser.AndExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on parsing and expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else if (ctx.andExpr() != null) {
            result = (And)EcoreUtil.create((EClass)FormulesPackage.Literals.AND);
            Expression rightOp = (Expression)this.pop();
            Expression leftOp = (Expression)this.pop();
            result.getOperands().add((Object)leftOp);
            ((And)result).getOperands().add((Object)rightOp);
        } else {
            result = (Expression)this.pop();
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterNotExpr(FormulesParser.NotExprContext ctx) {
    }

    @Override
    public void exitNotExpr(FormulesParser.NotExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on parsing no expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else {
            Expression operand = (Expression)this.pop();
            if (ctx.NOT() != null) {
                result = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
                ((Not)result).setOperand(operand);
            } else {
                result = operand;
            }
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterComparisonExpr(FormulesParser.ComparisonExprContext ctx) {
    }

    @Override
    public void exitComparisonExpr(FormulesParser.ComparisonExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on parsing compare expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else if (ctx.COMPOP() != null) {
            String operator = ctx.COMPOP().getText();
            if ("<".equals(operator)) {
                result = (Lower)EcoreUtil.create((EClass)FormulesPackage.Literals.LOWER);
                ((Binary)result).setRightOp((Expression)this.pop());
                ((Binary)result).setLeftOp((Expression)this.pop());
            } else if (">".equals(operator)) {
                result = (Greater)EcoreUtil.create((EClass)FormulesPackage.Literals.GREATER);
                ((Binary)result).setRightOp((Expression)this.pop());
                ((Binary)result).setLeftOp((Expression)this.pop());
            } else if ("<=".equals(operator)) {
                result = (LowerEqual)EcoreUtil.create((EClass)FormulesPackage.Literals.LOWER_EQUAL);
                ((Binary)result).setRightOp((Expression)this.pop());
                ((Binary)result).setLeftOp((Expression)this.pop());
            } else if (">=".equals(operator)) {
                result = (GreaterEqual)EcoreUtil.create((EClass)FormulesPackage.Literals.GREATER_EQUAL);
                ((Binary)result).setRightOp((Expression)this.pop());
                ((Binary)result).setLeftOp((Expression)this.pop());
            } else if ("=".equals(operator)) {
                result = (Equals)EcoreUtil.create((EClass)FormulesPackage.Literals.EQUALS);
                ((Binary)result).setRightOp((Expression)this.pop());
                ((Binary)result).setLeftOp((Expression)this.pop());
            } else if ("!=".equals(operator)) {
                result = (Diff)EcoreUtil.create((EClass)FormulesPackage.Literals.DIFF);
                ((Binary)result).setRightOp((Expression)this.pop());
                ((Binary)result).setLeftOp((Expression)this.pop());
            } else if ("in".equals(operator)) {
                result = (In)EcoreUtil.create((EClass)FormulesPackage.Literals.IN);
                Object rightOp = this.pop();
                if (rightOp instanceof ValueList) {
                    ((In)result).setRightOp((ValueList)rightOp);
                    ((In)result).setLeftOp((Expression)this.pop());
                } else {
                    result = this.error("[Error] Parser: right operand of 'in' operator must be a value list. " + rightOp.getClass().getName() + " found instead.");
                }
            } else {
                result = this.error("[Error] Parser: unrecognized operator " + operator);
            }
        } else {
            result = (Expression)this.pop();
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterArithmeticExpr(FormulesParser.ArithmeticExprContext ctx) {
    }

    @Override
    public void exitArithmeticExpr(FormulesParser.ArithmeticExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on parsing arithmetic expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else if (ctx.arithmeticExpr() != null) {
            String operator = ctx.ADDOP().getText();
            result = "+".equals(operator) ? (Add)EcoreUtil.create((EClass)FormulesPackage.Literals.ADD) : (Sub)EcoreUtil.create((EClass)FormulesPackage.Literals.SUB);
            Expression rightOp = (Expression)this.pop();
            Expression leftOp = (Expression)this.pop();
            ((Nary)result).getOperands().add((Object)leftOp);
            ((Nary)result).getOperands().add((Object)rightOp);
        } else {
            result = (Expression)this.pop();
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterMultExpr(FormulesParser.MultExprContext ctx) {
    }

    @Override
    public void exitMultExpr(FormulesParser.MultExprContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on mult expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else if (ctx.multExpr() != null) {
            String operator = ctx.MULTOP().getText();
            result = "*".equals(operator) ? (Mult)EcoreUtil.create((EClass)FormulesPackage.Literals.MULT) : (Div)EcoreUtil.create((EClass)FormulesPackage.Literals.DIV);
            Expression rightOp = (Expression)this.pop();
            Expression leftOp = (Expression)this.pop();
            ((Nary)result).getOperands().add((Object)leftOp);
            ((Nary)result).getOperands().add((Object)rightOp);
        } else {
            result = (Expression)this.pop();
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomElement(FormulesParser.AtomElementContext ctx) {
    }

    @Override
    public void exitAtomElement(FormulesParser.AtomElementContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomCall(FormulesParser.AtomCallContext ctx) {
    }

    @Override
    public void exitAtomCall(FormulesParser.AtomCallContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomParenthesis(FormulesParser.AtomParenthesisContext ctx) {
    }

    @Override
    public void exitAtomParenthesis(FormulesParser.AtomParenthesisContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomLiteral(FormulesParser.AtomLiteralContext ctx) {
    }

    @Override
    public void exitAtomLiteral(FormulesParser.AtomLiteralContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomListVal(FormulesParser.AtomListValContext ctx) {
    }

    @Override
    public void exitAtomListVal(FormulesParser.AtomListValContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomVarRef(FormulesParser.AtomVarRefContext ctx) {
    }

    @Override
    public void exitAtomVarRef(FormulesParser.AtomVarRefContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomLetExpr(FormulesParser.AtomLetExprContext ctx) {
    }

    @Override
    public void exitAtomLetExpr(FormulesParser.AtomLetExprContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterAtomQuantifiedExpr(FormulesParser.AtomQuantifiedExprContext ctx) {
    }

    @Override
    public void exitAtomQuantifiedExpr(FormulesParser.AtomQuantifiedExprContext ctx) {
        Expression result = ctx.exception != null ? this.error("Error on atom expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine()) : (Expression)this.pop();
        this.childrenStack.push(result);
    }

    @Override
    public void enterFunctionCall(FormulesParser.FunctionCallContext ctx) {
    }

    @Override
    public void exitFunctionCall(FormulesParser.FunctionCallContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on functionCall expression");
        } else {
            result = (FunctionCall)EcoreUtil.create((EClass)FormulesPackage.Literals.FUNCTION_CALL);
            ((FunctionCall)result).setName(ctx.FIELD().getText());
            Iterator<FormulesParser.FormuleContext> iterator = ctx.formule().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                ((FunctionCall)result).getArguments().add((Object)((Expression)this.pop()));
            }
            ECollections.reverse(((FunctionCall)result).getArguments());
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterVarRef(FormulesParser.VarRefContext ctx) {
    }

    @Override
    public void exitVarRef(FormulesParser.VarRefContext ctx) {
        Expression result;
        try {
            result = (VarRef)EcoreUtil.create((EClass)FormulesPackage.Literals.VAR_REF);
            result.setVarName(ctx.FIELD().getText());
        }
        catch (EmptyStackException emptyStackException) {
            result = this.error("Empty Stack");
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterContextSpec(FormulesParser.ContextSpecContext ctx) {
    }

    @Override
    public void exitContextSpec(FormulesParser.ContextSpecContext ctx) {
        this.childrenStack.push(ctx.FIELD().getText());
    }

    @Override
    public void enterElement(FormulesParser.ElementContext ctx) {
    }

    @Override
    public void exitElement(FormulesParser.ElementContext ctx) {
        Expression result;
        if (ctx.exception != null) {
            result = this.error("Error on element expression on column : ", ctx.exception.getOffendingToken().getCharPositionInLine());
        } else {
            try {
                result = (FieldRef)this.pop();
                String var = "root";
                if (ctx.contextSpec() != null) {
                    var = (String)this.pop();
                }
                result.setContextVariable(var);
            }
            catch (EmptyStackException emptyStackException) {
                result = this.error("Empty Stack");
            }
        }
        this.childrenStack.push(result);
    }

    @Override
    public void enterFieldRef(FormulesParser.FieldRefContext ctx) {
    }

    @Override
    public void exitFieldRef(FormulesParser.FieldRefContext ctx) {
        FieldRef result = (FieldRef)EcoreUtil.create((EClass)FormulesPackage.Literals.FIELD_REF);
        result.setName(ctx.FIELD().getText());
        this.childrenStack.push(result);
    }

    @Override
    public void enterListeValeur(FormulesParser.ListeValeurContext ctx) {
    }

    @Override
    public void exitListeValeur(FormulesParser.ListeValeurContext ctx) {
        ValueList result = (ValueList)EcoreUtil.create((EClass)FormulesPackage.Literals.VALUE_LIST);
        Iterator<FormulesParser.LiteralContext> iterator = ctx.literal().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            result.getValues().add((Object)((Literal)this.pop()));
        }
        ECollections.reverse(result.getValues());
        this.childrenStack.push(result);
    }

    @Override
    public void enterLiteralNum(FormulesParser.LiteralNumContext ctx) {
    }

    @Override
    public void exitLiteralNum(FormulesParser.LiteralNumContext ctx) {
        Num result = (Num)EcoreUtil.create((EClass)FormulesPackage.Literals.NUM);
        result.setValue(ctx.NUM().getText());
        this.childrenStack.push(result);
    }

    @Override
    public void enterLiteralAlphaNum(FormulesParser.LiteralAlphaNumContext ctx) {
    }

    @Override
    public void exitLiteralAlphaNum(FormulesParser.LiteralAlphaNumContext ctx) {
        AlphaNum result = (AlphaNum)EcoreUtil.create((EClass)FormulesPackage.Literals.ALPHA_NUM);
        String text = ctx.ALPHANUM().getText();
        result.setValue(text.substring(1, text.length() - 1));
        this.childrenStack.push(result);
    }

    @Override
    public void enterLiteralDate(FormulesParser.LiteralDateContext ctx) {
    }

    @Override
    public void exitLiteralDate(FormulesParser.LiteralDateContext ctx) {
        String date = ctx.DATE().getText();
        this.checkDate(date, ctx);
        Date result = (Date)EcoreUtil.create((EClass)FormulesPackage.Literals.DATE);
        result.setValue(date);
        this.childrenStack.push(result);
    }

    private Object pop() {
        try {
            return this.childrenStack.pop();
        }
        catch (EmptyStackException emptyStackException) {
            return this.error("Empty Stack");
        }
    }

    private Error error(String msg) {
        Error result = (Error)EcoreUtil.create((EClass)FormulesPackage.Literals.ERROR);
        result.setMsg(msg);
        return result;
    }

    private Error error(String msg, int pos) {
        Error result = (Error)EcoreUtil.create((EClass)FormulesPackage.Literals.ERROR);
        result.setMsg(String.valueOf(msg) + pos);
        return result;
    }

    private void checkDate(String date, ParserRuleContext ctx) throws RecognitionException {
        if (date.length() < 9) {
            throw new RecognitionException((Recognizer)this.parser, (IntStream)this.parser.getInputStream(), ctx);
        }
        boolean correct = true;
        String day = date.substring(0, 1);
        String mont = date.substring(2, 3);
        String year = date.substring(4, 7);
        try {
            int yearI;
            int monthI;
            int dayI = Integer.parseInt(day);
            if (dayI > 31 || dayI < 0) {
                correct = false;
            }
            if ((monthI = Integer.parseInt(mont)) > 12 || monthI < 0) {
                correct = false;
            }
            if ((yearI = Integer.parseInt(year)) < 0) {
                correct = false;
            }
        }
        catch (Exception exception) {
            correct = false;
        }
        if (!correct) {
            throw new RecognitionException((Recognizer)this.parser, (IntStream)this.parser.getInputStream(), ctx);
        }
    }
}

