/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FormulesPackage;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.metacontrol.AbstractTransformation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class Cleanup
extends AbstractTransformation {
    @Override
    public Expression caseAnd(And object) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (Expression operand : object.getOperands()) {
            Expression flattenedOp = (Expression)this.doSwitch(operand);
            if (flattenedOp instanceof And) {
                operands.addAll((Collection<Expression>)((And)flattenedOp).getOperands());
                continue;
            }
            if (flattenedOp instanceof Or) {
                Or or = (Or)flattenedOp;
                if (or.getOperands().size() == 1) {
                    operands.add((Expression)or.getOperands().get(0));
                    continue;
                }
                if (or.getOperands().size() <= 1) continue;
                operands.add(or);
                continue;
            }
            operands.add(flattenedOp);
        }
        object.getOperands().clear();
        object.getOperands().addAll(operands);
        if (object.getOperands().size() == 1) {
            return (Expression)object.getOperands().get(0);
        }
        return object;
    }

    @Override
    public Expression caseOr(Or object) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        for (Expression operand : object.getOperands()) {
            Expression flattenedOp = (Expression)this.doSwitch(operand);
            if (flattenedOp instanceof Or) {
                operands.addAll((Collection<Expression>)((Or)flattenedOp).getOperands());
                continue;
            }
            operands.add(flattenedOp);
        }
        object.getOperands().clear();
        List<Expression> removeTautologicalTerms = this.removeTautologicalTerms(operands);
        object.getOperands().addAll(removeTautologicalTerms);
        return object;
    }

    private List<Expression> removeTautologicalTerms(List<Expression> expressions) {
        ArrayList<Expression> operands = new ArrayList<Expression>();
        int size = expressions.size();
        HashSet<Expression> removed = new HashSet<Expression>();
        int i = 0;
        while (i < size) {
            Expression exp = expressions.get(i);
            boolean doRemove = false;
            if (!removed.contains(exp)) {
                Expression searchedExp = this.searchedExpression(exp);
                int j = i + 1;
                while (j < size) {
                    Expression exp2 = expressions.get(j);
                    if (!removed.contains(exp2) && EcoreUtil.equals((EObject)exp2, (EObject)searchedExp)) {
                        removed.add(exp2);
                        doRemove = true;
                    }
                    ++j;
                }
                if (doRemove) {
                    removed.add(exp);
                }
            }
            ++i;
        }
        for (Expression exp : expressions) {
            if (removed.contains(exp)) continue;
            operands.add(exp);
        }
        return operands;
    }

    private Expression searchedExpression(Expression exp) {
        if (exp instanceof Not) {
            return ((Not)exp).getOperand();
        }
        Not not = (Not)EcoreUtil.create((EClass)FormulesPackage.Literals.NOT);
        not.setOperand((Expression)EcoreUtil.copy((EObject)exp));
        return not;
    }
}

