/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.api.model.access;

import fr.cnav.saturne.AbstractBinding;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.ForeignKeyBinding;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.ForeignKeyBindingDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.MessageElementDescription;
import fr.cnav.saturne.api.model.access.StandardMapUtils;
import java.util.ArrayList;
import java.util.List;

public class BlockDescription
extends MessageElementDescription {
    private Block block;
    private List<FieldDescription> fields;
    private List<BlockDescription> children;
    private List<ForeignKeyBindingDescription> keyBindings;

    public BlockDescription(Block theBlock, IdQualifiedElementDescription theParent, StandardMapUtils standardMapUtils) {
        super(theBlock, theParent, standardMapUtils);
        this.block = theBlock;
        standardMapUtils.updateMaps(this.getFullQualifiedId(), this);
        this.fields = new ArrayList<FieldDescription>();
        for (Field field : this.block.getChildrenFields()) {
            this.fields.add(new FieldDescription(field, this, standardMapUtils));
        }
        this.children = new ArrayList<BlockDescription>();
        for (Block blockChild : this.block.getChildren()) {
            this.children.add(new BlockDescription(blockChild, (IdQualifiedElementDescription)this, standardMapUtils));
        }
        this.keyBindings = new ArrayList<ForeignKeyBindingDescription>();
        if (theBlock.getBindings() != null) {
            for (AbstractBinding binding : theBlock.getBindings().getBindings()) {
                if (!(binding instanceof ForeignKeyBinding)) continue;
                this.keyBindings.add(new ForeignKeyBindingDescription((ForeignKeyBinding)binding));
            }
        }
    }

    public List<FieldDescription> getFields() {
        return this.fields;
    }

    public List<BlockDescription> getChildren() {
        return this.children;
    }

    public int getLowerBound() {
        return this.block.getLowerBound();
    }

    public int getUpperBound() {
        return this.block.getUpperBound();
    }

    public List<BlockDescription> getChildrenBlocks() {
        return this.getChildren();
    }

    public List<ForeignKeyBindingDescription> getForeignKeyBindings() {
        return this.keyBindings;
    }
}

