/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrol.export.Activator;
import fr.cnav.autocontrole.exception.ExceptionKind;
import fr.cnav.autocontrole.helpers.AnomalyHelper;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.models.MessageFile;
import fr.cnav.autocontrole.models.ReportProvider;
import fr.cnav.autocontrole.providers.detail.AnomalieDetailProvider;
import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.providers.AnomalieColumnLabelProvider;
import fr.cnav.autocontrole.ui.providers.AnomalieFilter;
import fr.cnav.autocontrole.ui.providers.AnomalieViewerComparator;
import fr.cnav.autocontrole.ui.providers.PrincipaleToolTipSupport;
import fr.cnav.autocontrole.ui.views.HelperScroll;
import fr.cnav.autocontrole.ui.views.IndividualView;
import fr.cnav.autocontrole.ui.views.NormeView;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.report.model.Anomaly;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.part.ViewPart;

public class PrincipaleView
extends ViewPart {
    private static final String DEFAULT_FILTER_COMPONENT_TEXT = "type filter text";
    private static final String INDIVIDUALS_NUMBER_LABEL = "Individuals : ";
    public static final String ID = "fr.cnav.autocontrole.ui.views.PrincipaleView";
    private Text textFichier;
    private Text textTaille;
    private Text textNbLignes;
    private Text textDeclarations;
    private Text textDeclarationsKO;
    private Text textDclarationsOk;
    private Table tableAnomalies;
    private Text textDetailAnomalie;
    private Group grpResume;
    private Text textNbErreurs;
    private Text textBloquantes;
    private Text textAvertissementsAttentions;
    private Text textIndividual;
    private Label clearButton;
    private TableViewer tableViewer;
    private List<TableViewerColumn> columns;
    protected static final String[] columnNames = new String[]{Messages.PrincipaleView_18, Messages.PrincipaleView_8, Messages.PrincipaleView_9, Messages.PrincipaleView_10, Messages.PrincipaleView_11, Messages.PrincipaleView_12, Messages.PrincipaleView_13, Messages.PrincipaleView_14, Messages.PrincipaleView_15};
    protected static final String[] columnTooltipNames = new String[]{Messages.PrincipaleView_12};
    private static int[] columnSizes = new int[]{20, 65, 65, 65, 60, 90, 200, 300, 300};
    private static int[] columnStyle = new int[]{0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 16384, 16384, 16384};
    private AnomalieViewerComparator comparator;
    private List<ColumnLabelProvider> labelProviderColumns;
    private Text textSearch;
    private AnomalieFilter filter;
    private Composite container;
    private AnomalieDetailProvider anomalieDetailProvider;
    private Composite parent;

    public PrincipaleView() {
        try {
            this.anomalieDetailProvider = new AnomalieDetailProvider();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_PRINCIPALVIEW_INITIALIZATION.getMessage(), t));
        }
    }

    public void createPartControl(Composite parent) {
        try {
            this.parent = parent;
            if (StandardHelper.getInstance() != null) {
                URL imageURL;
                String applicationLabel = StandardHelper.getInstance().getApplicationLabel();
                if (applicationLabel != null) {
                    this.setPartName(applicationLabel);
                }
                if ((imageURL = StandardHelper.getInstance().getApplicationIcon16URL()) != null) {
                    ImageDescriptor imageDcr = ImageDescriptor.createFromURL((URL)imageURL);
                    Image iconApplication = imageDcr.createImage();
                    this.setTitleImage(iconApplication);
                }
            }
            this.container = new Composite(parent, 0);
            this.container.setLayout((Layout)new GridLayout(1, false));
            this.initGroupResume(this.container);
            SashForm sashForm = new SashForm(this.container, 2560);
            sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            this.initGroupAnomalie((Composite)sashForm);
            this.initGroupDetail((Composite)sashForm);
            sashForm.setWeights(new int[]{219, 96});
            this.createActions();
            this.initializeToolBar();
            this.initializeMenu();
            this.initializeData();
        }
        catch (Throwable t) {
            t.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_PRINCIPALVIEW_INITIALIZATION.getMessage(), t));
        }
    }

    private void initGroupDetail(Composite sashForm) {
        Group grpDetailAnomalie = new Group(sashForm, 0);
        grpDetailAnomalie.setLayout((Layout)new GridLayout(1, false));
        grpDetailAnomalie.setText(Messages.PrincipaleView_16);
        this.textDetailAnomalie = new Text((Composite)grpDetailAnomalie, 2824);
        GridData gd_textDetailAnomalie = new GridData(4, 4, true, true, 1, 1);
        gd_textDetailAnomalie.heightHint = 80;
        gd_textDetailAnomalie.minimumHeight = 80;
        this.textDetailAnomalie.setLayoutData((Object)gd_textDetailAnomalie);
        Font font = new Font((Device)sashForm.getDisplay(), "Courier New", 10, 0);
        this.textDetailAnomalie.setFont(font);
    }

    private void initGroupAnomalie(Composite sashForm) {
        this.columns = new ArrayList<TableViewerColumn>();
        this.labelProviderColumns = new ArrayList<ColumnLabelProvider>();
        Group grpAnomalies = new Group(sashForm, 0);
        grpAnomalies.setLayout((Layout)new GridLayout(1, false));
        grpAnomalies.setText(Messages.PrincipaleView_7);
        Composite border = new Composite((Composite)grpAnomalies, 2052);
        border.setLayoutData((Object)new GridData(768));
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginHeight = 0;
        filterLayout.marginWidth = 0;
        border.setLayout((Layout)filterLayout);
        border.setBackground(border.getDisplay().getSystemColor(1));
        this.textSearch = new Text(border, 4);
        this.textSearch.setLayoutData((Object)new GridData(768));
        this.textSearch.setText(DEFAULT_FILTER_COMPONENT_TEXT);
        this.textSearch.setForeground(this.parent.getDisplay().getSystemColor(16));
        final Image clearEnabledImage = AutocontrolUiPlugin.getImage("icons/clear_enabled.gif");
        final Image clearDisabledImage = AutocontrolUiPlugin.getImage("icons/clear_disable.gif");
        this.clearButton = new Label(border, 0);
        this.clearButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.clearButton.setImage(clearDisabledImage);
        this.clearButton.setBackground(this.parent.getDisplay().getSystemColor(25));
        this.clearButton.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
        this.clearButton.setVisible(false);
        FocusListener focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                if ("".equals(PrincipaleView.this.textSearch.getText()) || PrincipaleView.DEFAULT_FILTER_COMPONENT_TEXT.equals(PrincipaleView.this.textSearch.getText())) {
                    PrincipaleView.this.clearFilterComponent();
                }
            }

            public void focusGained(FocusEvent e) {
                if (PrincipaleView.DEFAULT_FILTER_COMPONENT_TEXT.equals(PrincipaleView.this.textSearch.getText())) {
                    PrincipaleView.this.textSearch.setText("");
                    PrincipaleView.this.textSearch.setForeground(PrincipaleView.this.parent.getDisplay().getSystemColor(2));
                    PrincipaleView.this.clearButton.setVisible(false);
                }
            }
        };
        this.textSearch.addFocusListener(focusListener);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PrincipaleView.this.textSearch.getText().length() > 0) {
                    PrincipaleView.this.clearButton.setVisible(true);
                } else {
                    PrincipaleView.this.clearButton.setVisible(false);
                }
            }
        };
        this.textSearch.addModifyListener(listener);
        this.clearButton.addMouseListener((MouseListener)new MouseAdapter(){
            private MouseMoveListener fMoveListener;

            public void mouseDown(MouseEvent e) {
                PrincipaleView.this.clearButton.setImage(clearEnabledImage);
                this.fMoveListener = new MouseMoveListener(){
                    private boolean fMouseInButton = true;

                    public void mouseMove(MouseEvent e) {
                        boolean mouseInButton = this.isMouseInButton(e);
                        if (mouseInButton != this.fMouseInButton) {
                            this.fMouseInButton = mouseInButton;
                            PrincipaleView.this.clearButton.setImage(mouseInButton ? clearEnabledImage : clearDisabledImage);
                        }
                    }
                };
                PrincipaleView.this.clearButton.addMouseMoveListener(this.fMoveListener);
            }

            public void mouseUp(MouseEvent e) {
                if (this.fMoveListener != null) {
                    PrincipaleView.this.clearButton.removeMouseMoveListener(this.fMoveListener);
                    this.fMoveListener = null;
                    boolean mouseInButton = this.isMouseInButton(e);
                    PrincipaleView.this.clearButton.setImage(mouseInButton ? clearEnabledImage : clearDisabledImage);
                    if (mouseInButton) {
                        PrincipaleView.this.textSearch.setText("");
                        PrincipaleView.this.filter.setSearchText(PrincipaleView.this.textSearch.getText());
                        PrincipaleView.this.tableViewer.refresh();
                        PrincipaleView.this.textSearch.setFocus();
                        PrincipaleView.this.clearButton.setVisible(false);
                    }
                }
            }

            private boolean isMouseInButton(MouseEvent e) {
                Point buttonSize = PrincipaleView.this.clearButton.getSize();
                return e.x >= 0 && e.x < buttonSize.x && e.y >= 0 && e.y < buttonSize.y;
            }
        });
        this.clearButton.addMouseTrackListener(new MouseTrackListener(){

            public void mouseEnter(MouseEvent e) {
                PrincipaleView.this.clearButton.setImage(clearEnabledImage);
            }

            public void mouseExit(MouseEvent e) {
                PrincipaleView.this.clearButton.setImage(clearDisabledImage);
            }

            public void mouseHover(MouseEvent e) {
            }
        });
        this.clearButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                clearDisabledImage.dispose();
                clearEnabledImage.dispose();
            }
        });
        Composite compositeAnomalies = new Composite((Composite)grpAnomalies, 0);
        compositeAnomalies.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        TableColumnLayout tcl_compositeAnomalies = new TableColumnLayout();
        compositeAnomalies.setLayout((Layout)tcl_compositeAnomalies);
        this.tableViewer = new TableViewer(compositeAnomalies, 67584);
        this.tableAnomalies = this.tableViewer.getTable();
        this.tableAnomalies.setHeaderVisible(true);
        this.tableAnomalies.setLinesVisible(true);
        this.tableAnomalies.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < columnNames.length) {
            this.createTableViewerColumn(tcl_compositeAnomalies, columnNames[i], columnSizes[i], i, columnStyle[i]);
            ++i;
        }
        this.comparator = new AnomalieViewerComparator(this.labelProviderColumns);
        this.tableViewer.setComparator((ViewerComparator)this.comparator);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.filter = new AnomalieFilter(this.labelProviderColumns);
        this.textSearch.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                PrincipaleView.this.filter.setSearchText(PrincipaleView.this.textSearch.getText());
                PrincipaleView.this.tableViewer.refresh();
            }
        });
        this.tableViewer.addFilter((ViewerFilter)this.filter);
        MenuManager menuManager = new MenuManager();
        Menu menu = menuManager.createContextMenu((Control)this.tableViewer.getTable());
        this.tableViewer.getTable().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tableViewer);
    }

    private void createTableViewerColumn(TableColumnLayout tcl_compositeAnomalies, String text, int width, int index, int style) {
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tableColumn = column.getColumn();
        tcl_compositeAnomalies.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnPixelData(width, true, true));
        tableColumn.setAlignment(style);
        tableColumn.setText(text);
        tableColumn.addSelectionListener((SelectionListener)this.getSelectionAdapter(tableColumn, index));
        this.columns.add(column);
    }

    private void initGroupResume(Composite container) {
        this.grpResume = new Group(container, 0);
        this.grpResume.setLayout((Layout)new GridLayout(1, false));
        this.grpResume.setLayoutData((Object)new GridData(768));
        this.grpResume.setText(Messages.PrincipaleView_0);
        this.initCompositeAnomalie(this.grpResume);
        this.initCompositeFichier(this.grpResume);
        this.initCompositeDetail(this.grpResume);
        this.initCompositeDeclaration(this.grpResume);
    }

    private void initCompositeDeclaration(Group grpResume) {
        Composite compositeDeclaration = new Composite((Composite)grpResume, 0);
        compositeDeclaration.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout gl_compositeDeclaration = new GridLayout(6, false);
        gl_compositeDeclaration.marginHeight = 0;
        compositeDeclaration.setLayout((Layout)gl_compositeDeclaration);
        Label lblDeclarations = new Label(compositeDeclaration, 0);
        lblDeclarations.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        lblDeclarations.setText(Messages.PrincipaleView_4);
        this.textDeclarations = new Text(compositeDeclaration, 2056);
        this.textDeclarations.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDeclarationsOk = new Label(compositeDeclaration, 0);
        lblDeclarationsOk.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDeclarationsOk.setText(Messages.PrincipaleView_5);
        this.textDclarationsOk = new Text(compositeDeclaration, 2056);
        this.textDclarationsOk.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblDeclarationsKo = new Label(compositeDeclaration, 0);
        lblDeclarationsKo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDeclarationsKo.setText(Messages.PrincipaleView_6);
        this.textDeclarationsKO = new Text(compositeDeclaration, 2056);
        this.textDeclarationsKO.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
    }

    private void initCompositeDetail(Group grpResume) {
        Composite compositeTaille = new Composite((Composite)grpResume, 0);
        compositeTaille.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        GridLayout gl_compositeTaille = new GridLayout(6, false);
        gl_compositeTaille.marginHeight = 0;
        compositeTaille.setLayout((Layout)gl_compositeTaille);
        Label lblTaille = new Label(compositeTaille, 0);
        lblTaille.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lblTaille.setText(Messages.PrincipaleView_2);
        this.textTaille = new Text(compositeTaille, 2056);
        this.textTaille.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblLignes = new Label(compositeTaille, 0);
        lblLignes.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lblLignes.setText(Messages.PrincipaleView_3);
        this.textNbLignes = new Text(compositeTaille, 2056);
        this.textNbLignes.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        if (StandardHelper.getInstance() != null && StandardHelper.getInstance().getMessageDescriptor() != null) {
            Label lblIndividual = new Label(compositeTaille, 0);
            lblIndividual.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
            if (StandardHelper.getInstance() != null && StandardHelper.getInstance().getMessageDescriptor() != null) {
                lblIndividual.setText("Nb " + StandardHelper.getInstance().getMessageDescriptor().getIndividualLabel() + " : ");
            } else {
                lblIndividual.setText(INDIVIDUALS_NUMBER_LABEL);
            }
            this.textIndividual = new Text(compositeTaille, 2048);
            this.textIndividual.setEditable(false);
            this.textIndividual.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        }
    }

    private void initCompositeFichier(Group grpResume) {
        Composite compositeFichier = new Composite((Composite)grpResume, 0);
        compositeFichier.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gl_compositeFichier = new GridLayout(2, false);
        gl_compositeFichier.marginHeight = 0;
        compositeFichier.setLayout((Layout)gl_compositeFichier);
        Label lblFichier = new Label(compositeFichier, 0);
        lblFichier.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        lblFichier.setText(Messages.PrincipaleView_1);
        this.textFichier = new Text(compositeFichier, 2056);
        this.textFichier.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    private void initCompositeAnomalie(Group grpResume) {
        Composite compositeAnomalie = new Composite((Composite)grpResume, 0);
        GridLayout gl_compositeAnomalie = new GridLayout(6, false);
        gl_compositeAnomalie.marginHeight = 0;
        gl_compositeAnomalie.verticalSpacing = 0;
        compositeAnomalie.setLayout((Layout)gl_compositeAnomalie);
        compositeAnomalie.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblNbErreurs = new Label(compositeAnomalie, 0);
        lblNbErreurs.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblNbErreurs.setText(Messages.PrincipaleView_lblNombreTotalDerreurs_text);
        this.textNbErreurs = new Text(compositeAnomalie, 2048);
        this.textNbErreurs.setEditable(false);
        this.textNbErreurs.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label lblBloquantes = new Label(compositeAnomalie, 0);
        lblBloquantes.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblBloquantes.setText(Messages.PrincipaleView_lblAnomaliesBloquantes_text);
        this.textBloquantes = new Text(compositeAnomalie, 2048);
        this.textBloquantes.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textBloquantes.setEditable(false);
        Label lblAvertissementsAttentions = new Label(compositeAnomalie, 0);
        lblAvertissementsAttentions.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAvertissementsAttentions.setText(Messages.PrincipaleView_lblAvertissementsAttentions_text);
        this.textAvertissementsAttentions = new Text(compositeAnomalie, 2048);
        this.textAvertissementsAttentions.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.textAvertissementsAttentions.setEditable(false);
    }

    public void initializeData() {
        try {
            if (MessageFile.getInstance() != null) {
                this.clearFilterComponent();
                ReportProvider reportProvider = MessageFile.getInstance().getReportProvider();
                if (reportProvider != null) {
                    this.textNbErreurs.setText(reportProvider.getAnolamieNbrAsString());
                    this.textBloquantes.setText(reportProvider.getAnolamieBloquanteNbrAsString());
                    this.textAvertissementsAttentions.setText(reportProvider.getAvertissementNbrAsString());
                    this.textFichier.setText(MessageFile.getInstance().getInputFile().getAbsolutePath());
                    this.textTaille.setText(MessageFile.getInstance().printSize());
                    this.textNbLignes.setText(MessageFile.getInstance().getLineNbrAsString());
                    if (this.textIndividual != null) {
                        this.textIndividual.setText(reportProvider.getSalarieNbrAsString());
                    }
                    this.textDeclarations.setText(reportProvider.getDeclarationNbrAsString());
                    this.textDclarationsOk.setText(reportProvider.getDeclarationOKNbrAsString());
                    this.textDeclarationsKO.setText(reportProvider.getDeclarationKONbrAsString());
                    PrincipaleToolTipSupport.enableFor((ColumnViewer)this.tableViewer);
                    int i = 0;
                    while (i < this.columns.size()) {
                        AnomalieColumnLabelProvider labelProvider = null;
                        labelProvider = this.isToolipColumn(i) ? new AnomalieColumnLabelProvider(i, true) : new AnomalieColumnLabelProvider(i, false);
                        this.labelProviderColumns.add(labelProvider);
                        this.columns.get(i).setLabelProvider((CellLabelProvider)labelProvider);
                        ++i;
                    }
                    this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
                    this.tableViewer.setInput((Object)MessageFile.getInstance().getAnomalies());
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_PRINCIPAL_VIEW_REFRESH.getMessage(), t));
            MessageDialog.openError((Shell)this.parent.getShell(), (String)Messages.OpenViewPrincipal_0, (String)String.format(ExceptionKind.ERROR_PRINCIPAL_VIEW_REFRESH.getMessage(), new Object[0]));
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (PartInitException e) {
                e.printStackTrace();
                Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
            }
        }
    }

    private void clearFilterComponent() {
        this.textSearch.setText(DEFAULT_FILTER_COMPONENT_TEXT);
        this.textSearch.setForeground(this.parent.getDisplay().getSystemColor(16));
        this.filter.setSearchText("");
        this.clearButton.setVisible(false);
    }

    public void selectFistAnomalie() {
        if (MessageFile.getInstance() != null && MessageFile.getInstance().getAnomalies().size() > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(MessageFile.getInstance().getAnomalies().get(0)));
        }
    }

    public void selectFistAnomalieWithLine(BigInteger targetLine) {
        Object firstAnomalieInLine = AnomalyHelper.getFirstAnomalieWithLine((BigInteger)targetLine);
        if (firstAnomalieInLine != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(firstAnomalieInLine));
        } else {
            this.tableViewer.setSelection((ISelection)new StructuredSelection());
            this.textDetailAnomalie.setText("");
        }
    }

    private boolean isToolipColumn(int i) {
        int j = 0;
        while (j < columnTooltipNames.length) {
            if (columnTooltipNames[j].equals(columnNames[i])) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public void resetData() {
        if (MessageFile.getInstance() != null) {
            this.textNbErreurs.setText("");
            this.textBloquantes.setText("");
            this.textAvertissementsAttentions.setText("");
            this.textFichier.setText("");
            this.textTaille.setText("");
            this.textNbLignes.setText("");
            if (this.textIndividual != null) {
                this.textIndividual.setText("");
            }
            this.textDeclarations.setText("");
            this.textDclarationsOk.setText("");
            this.textDeclarationsKO.setText("");
            if (this.tableViewer.getContentProvider() != null) {
                ArrayList emptyInput = new ArrayList(0);
                this.filter.setSearchText("");
                this.tableViewer.setInput(emptyInput);
            }
            this.textDetailAnomalie.setText("");
        }
    }

    private void createActions() {
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    if (event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).getFirstElement() != null) {
                        StructuredSelection structuredSelection;
                        final Object selectedObject = ((StructuredSelection)event.getSelection()).getFirstElement();
                        PrincipaleView.this.updateDetailView(selectedObject);
                        if (selectedObject instanceof Anomaly) {
                            Object normeEltDescription = MessageFile.getInstance().getNormeElt(selectedObject);
                            Block normeElt = null;
                            StandardAccessor modelAccessor = StandardHelper.getInstance().getStandardAccessor();
                            if (normeEltDescription != null) {
                                if (normeEltDescription instanceof BlockDescription) {
                                    normeElt = modelAccessor.getBlock(((BlockDescription)normeEltDescription).getFullQualifiedId());
                                } else if (normeEltDescription instanceof FieldDescription) {
                                    normeElt = modelAccessor.getField(((FieldDescription)normeEltDescription).getFullQualifiedId());
                                }
                            }
                            DeclarationDescription declDescription = AnomalyHelper.getDeclaration((Anomaly)((Anomaly)selectedObject));
                            Declaration decl = null;
                            if (declDescription != null) {
                                for (Declaration declaration : modelAccessor.getStandard().getDeclarations()) {
                                    if (declaration.getName() == null || !declaration.getName().equals(declDescription.getName())) continue;
                                    decl = declaration;
                                }
                            }
                            structuredSelection = normeElt != null ? new StructuredSelection((Object)new MessageTreeObject((Object)normeElt, decl)) : new StructuredSelection();
                        } else {
                            structuredSelection = new StructuredSelection();
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IViewPart viewNorme = PrincipaleView.this.getSite().getPage().findView("fr.cnav.autocontrole.ui.views.NormeView");
                                if (viewNorme != null && selectedObject instanceof Anomaly) {
                                    ((NormeView)viewNorme).getTreeViewer().setSelection((ISelection)structuredSelection, true);
                                }
                            }
                        });
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IViewPart viewSalarie = PrincipaleView.this.getSite().getPage().findView("fr.cnav.autocontrole.ui.views.IndividualView");
                                boolean isVisible = PrincipaleView.this.getSite().getPage().isPartVisible((IWorkbenchPart)viewSalarie);
                                IndividualView view = (IndividualView)viewSalarie;
                                if (viewSalarie != null && isVisible && !view.isObjectAlreadySelected(selectedObject)) {
                                    view.initializeData(selectedObject);
                                }
                            }
                        });
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_PRINCIPAL_VIEW_REFRESH.getMessage(), t));
                    MessageDialog.openError((Shell)PrincipaleView.this.parent.getShell(), (String)Messages.OpenViewPrincipal_0, (String)String.format(ExceptionKind.ERROR_PRINCIPAL_VIEW_REFRESH.getMessage(), new Object[0]));
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                        Activator.log((IStatus)new Status(4, "fr.cnav.autocontrole.export", ExceptionKind.ERROR_OPENING_ERROR_LOG.getMessage(), (Throwable)e));
                    }
                }
            }
        });
        this.textDetailAnomalie.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                PrincipaleView.this.updateScroll();
            }
        });
    }

    private void updateDetailView(Object selectedObject) {
        this.textDetailAnomalie.setText(this.anomalieDetailProvider.getText(selectedObject));
        this.updateScroll();
    }

    private void updateScroll() {
        if (this.textDetailAnomalie != null) {
            HelperScroll.updateScolls(this.textDetailAnomalie);
        }
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
        if (this.parent != null && this.tableViewer != null) {
            this.parent.setFocus();
            this.tableViewer.getControl().setFocus();
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrincipaleView.this.comparator.setColumn(index);
                int dir = PrincipaleView.this.comparator.getDirection();
                PrincipaleView.this.tableViewer.getTable().setSortDirection(dir);
                PrincipaleView.this.tableViewer.getTable().setSortColumn(column);
                PrincipaleView.this.tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public int getSelectedTableIndex() {
        return this.tableAnomalies.getSelectionIndex();
    }

    public Object getSelectedObject() {
        if (this.tableAnomalies.getSelection().length > 0) {
            return this.tableAnomalies.getSelection()[0].getData();
        }
        return null;
    }
}

