/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.proxy;

import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.proxy.AbstractSetupDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractPreferenceDialog
extends AbstractSetupDialog
implements IPreferencePageContainer {
    private PreferencePage preferencePage;
    private boolean showingError;

    public AbstractPreferenceDialog(Shell parentShell, String title) {
        super(parentShell, title, 600, 600, AutocontrolUiPlugin.getPlugin(), null);
    }

    public IPreferenceStore getPreferenceStore() {
        return AutocontrolUiPlugin.getPlugin().getPreferenceStore();
    }

    public void updateTitle() {
    }

    public void updateMessage() {
        String message = null;
        String errorMessage = null;
        if (this.preferencePage != null) {
            message = this.preferencePage.getMessage();
            errorMessage = this.preferencePage.getErrorMessage();
        }
        int messageType = 0;
        if (message != null) {
            messageType = this.preferencePage.getMessageType();
        }
        if (errorMessage == null) {
            if (this.showingError) {
                this.showingError = false;
            }
        } else {
            message = errorMessage;
            messageType = 3;
            if (!this.showingError) {
                this.showingError = true;
            }
        }
        if (message == null) {
            message = this.getDefaultMessage();
        }
        this.setMessage(message, messageType);
    }

    public void updateButtons() {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(this.preferencePage.isValid());
        }
    }

    @Override
    protected void createUI(Composite parent) {
        this.preferencePage = this.createPreferencePage();
        this.preferencePage.setContainer((IPreferencePageContainer)this);
        this.preferencePage.createControl(parent);
        this.preferencePage.getControl().setLayoutData((Object)new GridData(1808));
    }

    protected abstract PreferencePage createPreferencePage();

    protected void okPressed() {
        this.preferencePage.performOk();
        super.okPressed();
    }
}

