/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.ExternalDataType;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.content.AbstractContentHelper;
import fr.cnav.saturne.editor.ogn.content.ContentHelperDataType;
import fr.cnav.saturne.editor.ogn.content.ContentHelperEObject;
import fr.cnav.saturne.editor.ogn.content.IContentHelper;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ContentHelperExternalDataTable
extends AbstractContentHelper<ExternalDataTable> {
    private IContentHelper<EObject> contentHelperEObject;
    private Map<ExternalDataType, List<Field>> mapExtDataTypeToFieldList;
    private ContentHelperDataType contentHelperDataType;

    public ContentHelperExternalDataTable(Map<EObject, Adapter> adapteursMap, SaturneItemProviderAdapterFactory saturneFactory, ContentHelperDataType contentHelperDataType) {
        super(adapteursMap, saturneFactory);
        this.contentHelperDataType = contentHelperDataType;
        this.contentHelperEObject = new ContentHelperEObject(adapteursMap, saturneFactory);
    }

    @Override
    public List<Object> getChildrenElt(ExternalDataTable inputElt, MessageTreeObject currentMessageTreeObject, boolean registerAdapter) {
        return this.contentHelperEObject.getChildrenElt((EObject)inputElt, currentMessageTreeObject, registerAdapter);
    }

    @Override
    public MessageTreeObject getParent(ExternalDataTable extDataTable, MessageTreeObject currentMessageTreeObject) {
        MessageTreeObject returnMsg = null;
        EObject parent = extDataTable.eContainer();
        Declaration declaration = currentMessageTreeObject.getDeclaration();
        if (parent != null) {
            Object grandParent = null;
            if (parent instanceof DataType) {
                this.contentHelperDataType.getFirstFieldWithDT((DataType)parent);
            }
            returnMsg = new MessageTreeObject(parent, declaration, grandParent);
        }
        return returnMsg;
    }

    @Override
    public List<MessageTreeObject> getObjectsToRefresh(ExternalDataTable extDataTable, Notification notification) {
        ExternalDataType extDataType;
        ArrayList<MessageTreeObject> resultList = new ArrayList<MessageTreeObject>();
        Standard standard = this.getStandard((EObject)extDataTable);
        if (this.mapExtDataTypeToFieldList == null) {
            this.mapExtDataTypeToFieldList = this.initMap(standard);
        }
        if (this.mapExtDataTypeToFieldList.get(extDataType = (ExternalDataType)extDataTable.eContainer()) != null) {
            for (Field field : this.mapExtDataTypeToFieldList.get(extDataType)) {
                if (this.getParentDeclarationBlock((EObject)field) == null) {
                    MessageTreeObject messageTreeObjectValue = new MessageTreeObject(extDataTable, null, extDataType);
                    messageTreeObjectValue.setParentMessageTreeObject(new MessageTreeObject(field, null, field.eContainer()));
                    resultList.add(messageTreeObjectValue);
                    continue;
                }
                for (Declaration declaration : standard.getDeclarations()) {
                    if (!this.isDisplayed((EObject)extDataTable, declaration)) continue;
                    MessageTreeObject messageTreeObjectValue = new MessageTreeObject(extDataTable, declaration, extDataType);
                    messageTreeObjectValue.setParentMessageTreeObject(new MessageTreeObject(field, declaration, field.eContainer()));
                    resultList.add(messageTreeObjectValue);
                }
            }
        }
        return resultList;
    }

    @Override
    public MessageTreeObject getObjectToSelect(ExternalDataTable extDataTable) {
        MessageTreeObject result = null;
        Standard standard = this.getStandard((EObject)extDataTable);
        if (this.mapExtDataTypeToFieldList == null) {
            this.mapExtDataTypeToFieldList = this.initMap(standard);
        }
        ExternalDataType extDataType = (ExternalDataType)extDataTable.eContainer();
        for (Field field : this.mapExtDataTypeToFieldList.get(extDataType)) {
            if (this.getParentDeclarationBlock((EObject)field) == null) {
                return new MessageTreeObject(extDataTable, null, extDataType);
            }
            for (Declaration declaration : standard.getDeclarations()) {
                if (!this.isDisplayed((EObject)extDataTable, declaration)) continue;
                return new MessageTreeObject(extDataTable, declaration, extDataType);
            }
        }
        return result;
    }

    private Map<ExternalDataType, List<Field>> initMap(Standard standard) {
        HashMap<ExternalDataType, List<Field>> result = new HashMap<ExternalDataType, List<Field>>();
        TreeIterator iter = standard.getMessage().eAllContents();
        while (iter.hasNext()) {
            Field field;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof Field) || (field = (Field)eObject).getDataType() == null || field.getDataType().getNature() != NatureType.EXTERNAL_REFERENTIAL) continue;
            ExternalDataType extDataType = (ExternalDataType)field.getDataType();
            if (result.get(extDataType) == null) {
                result.put(extDataType, new ArrayList());
            }
            List fields = (List)result.get(extDataType);
            fields.add(field);
        }
        return result;
    }
}

