/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.metacontrol;

import fr.cnav.saturne.dsl.formules.Add;
import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Binary;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Diff;
import fr.cnav.saturne.dsl.formules.Div;
import fr.cnav.saturne.dsl.formules.Equals;
import fr.cnav.saturne.dsl.formules.Equiv;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Greater;
import fr.cnav.saturne.dsl.formules.GreaterEqual;
import fr.cnav.saturne.dsl.formules.Imply;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Lower;
import fr.cnav.saturne.dsl.formules.LowerEqual;
import fr.cnav.saturne.dsl.formules.Mult;
import fr.cnav.saturne.dsl.formules.Nary;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Sub;
import fr.cnav.saturne.dsl.formules.VarRef;
import org.eclipse.emf.common.util.EList;

public class DSLStringTransformation {
    private static final String C_PARENTHESIS = ")";
    private static final String O_PARENTHESIS = "(";
    private static final String COMMA = ",";

    public String expressionAsString(Expression exp) {
        String exprAsString = null;
        if (exp != null) {
            exprAsString = "";
            if (exp instanceof Not) {
                exprAsString = this.caseNot((Not)exp);
            } else if (exp instanceof FunctionCall) {
                exprAsString = this.caseFunctionCall((FunctionCall)exp);
            } else if (exp instanceof Nary) {
                exprAsString = this.caseNary((Nary)exp);
            } else if (exp instanceof In) {
                exprAsString = this.caseIn((In)exp);
            } else if (exp instanceof FieldRef) {
                exprAsString = this.caseFieldRef((FieldRef)exp);
            } else if (exp instanceof VarRef) {
                exprAsString = this.caseVarRef((VarRef)exp);
            } else if (exp instanceof Literal) {
                exprAsString = this.caseLiteral((Literal)exp);
            } else if (exp instanceof Binary) {
                exprAsString = this.caseBinary((Binary)exp);
            } else if (exp instanceof Let) {
                exprAsString = this.caseLet((Let)exp);
            } else if (exp instanceof Quantified) {
                exprAsString = this.caseQuantified((Quantified)exp);
            }
        }
        return exprAsString;
    }

    private String caseNot(Not not) {
        StringBuilder sb = new StringBuilder();
        String operandAsString = this.expressionAsString(not.getOperand());
        sb.append("not").append(O_PARENTHESIS).append(operandAsString).append(C_PARENTHESIS);
        return sb.toString();
    }

    private String caseFunctionCall(FunctionCall functionCall) {
        StringBuilder sb = new StringBuilder();
        sb.append(functionCall.getName()).append(O_PARENTHESIS);
        EList<Expression> arguments = functionCall.getArguments();
        int size = arguments.size();
        if (size > 0) {
            sb.append(this.expressionAsString((Expression)arguments.get(0)));
            int i = 1;
            while (i < size) {
                Expression operand = (Expression)arguments.get(i);
                sb.append(COMMA).append(this.expressionAsString(operand));
                ++i;
            }
        }
        sb.append(C_PARENTHESIS);
        return sb.toString();
    }

    private String caseIn(In in) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.expressionAsString(in.getLeftOp())).append(" in {");
        EList<Literal> values = in.getRightOp().getValues();
        int size = values.size();
        int i = 0;
        while (i < size) {
            sb.append(this.expressionAsString((Expression)values.get(i)));
            if (i < size - 1) {
                sb.append(COMMA);
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    private String caseNary(Nary nary) {
        String naryOperator = null;
        if (nary instanceof Or) {
            naryOperator = " or ";
        } else if (nary instanceof And) {
            naryOperator = " and ";
        } else if (nary instanceof Add) {
            naryOperator = " + ";
        } else if (nary instanceof Sub) {
            naryOperator = " - ";
        } else if (nary instanceof Mult) {
            naryOperator = " * ";
        } else if (nary instanceof Div) {
            naryOperator = " / ";
        }
        StringBuilder sb = new StringBuilder();
        EList<Expression> operands = nary.getOperands();
        int size = operands.size();
        int i = 0;
        while (i < size) {
            String operand = this.expressionAsString((Expression)operands.get(i));
            if (nary instanceof And) {
                sb.append(O_PARENTHESIS).append(operand).append(C_PARENTHESIS);
            } else {
                sb.append(operand);
            }
            if (i < size - 1) {
                sb.append(naryOperator);
            }
            ++i;
        }
        return sb.toString();
    }

    private String caseFieldRef(FieldRef fieldRef) {
        StringBuilder sb = new StringBuilder();
        String contextVariable = fieldRef.getContextVariable();
        if ("root".equals(contextVariable)) {
            sb.append(fieldRef.getName());
        } else {
            sb.append("$").append(contextVariable).append(":").append(fieldRef.getName());
        }
        return sb.toString();
    }

    private String caseVarRef(VarRef varRef) {
        StringBuilder sb = new StringBuilder();
        sb.append("$").append(varRef.getVarName());
        return sb.toString();
    }

    private String caseLiteral(Literal literal) {
        StringBuilder sb = new StringBuilder();
        if (literal instanceof AlphaNum) {
            sb.append("'").append(literal.getValue()).append("'");
        } else {
            sb.append(literal.getValue());
        }
        return sb.toString();
    }

    private String caseBinary(Binary binary) {
        StringBuilder sb = new StringBuilder();
        String expressionLeftAsString = this.expressionAsString(binary.getLeftOp());
        String expressionRightAsString = this.expressionAsString(binary.getRightOp());
        String binaryOperator = null;
        if (binary instanceof Imply) {
            binaryOperator = "=>";
        } else if (binary instanceof Equiv) {
            binaryOperator = "<=>";
        } else if (binary instanceof Lower) {
            binaryOperator = "<";
        } else if (binary instanceof LowerEqual) {
            binaryOperator = "<=";
        } else if (binary instanceof Greater) {
            binaryOperator = ">";
        } else if (binary instanceof GreaterEqual) {
            binaryOperator = ">=";
        } else if (binary instanceof Diff) {
            binaryOperator = "!=";
        } else if (binary instanceof Equals) {
            binaryOperator = "=";
        }
        if (binary instanceof Imply || binary instanceof Equiv) {
            sb.append(O_PARENTHESIS).append(expressionLeftAsString).append(C_PARENTHESIS);
            sb.append(binaryOperator);
            sb.append(O_PARENTHESIS).append(expressionRightAsString).append(C_PARENTHESIS);
        } else {
            sb.append(expressionLeftAsString).append(binaryOperator).append(expressionRightAsString);
        }
        return sb.toString();
    }

    private String caseQuantified(Quantified quantified) {
        StringBuilder sb = new StringBuilder();
        sb.append(quantified.getQuantifier().toString().toLowerCase()).append(" ");
        EList<IteratorVariable> variables = quantified.getVariables();
        int size = variables.size();
        int i = 0;
        while (i < size) {
            IteratorVariable iteratorVariable = (IteratorVariable)variables.get(i);
            String varName = iteratorVariable.getVarName();
            if ("self".equals(varName)) {
                sb.append(iteratorVariable.getElement().getName());
            } else {
                sb.append(varName).append(":").append(iteratorVariable.getElement().getName());
            }
            if (i < size - 1) {
                sb.append(COMMA);
            }
            ++i;
        }
        String expressionAsString = this.expressionAsString(quantified.getExpression());
        sb.append(" satisfies ").append(O_PARENTHESIS).append(expressionAsString).append(C_PARENTHESIS);
        return sb.toString();
    }

    private String caseLet(Let let) {
        StringBuilder sb = new StringBuilder("let ");
        EList<Binding> bindings = let.getBindings();
        int size = bindings.size();
        int i = 0;
        while (i < size) {
            Binding binding = (Binding)bindings.get(i);
            String expBindingAsString = this.expressionAsString(binding.getExpr());
            sb.append(binding.getVarName()).append(":=").append(expBindingAsString);
            if (i < size - 1) {
                sb.append(COMMA);
            }
            ++i;
        }
        String expressionAsString = this.expressionAsString(let.getIn());
        sb.append(" inexpr ").append(O_PARENTHESIS).append(expressionAsString);
        return sb.append(C_PARENTHESIS).toString();
    }
}

