/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.gen;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.dsl.gen.common.navigation.IMessage;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.parser.ParserConfigurationException;
import fr.cnav.saturne.dsl.parser.configuration.StandardParserConfiguration;
import java.util.List;
import java.util.Map;

public final class DSLGeneratorContext {
    private static DSLGeneratorContext instance;
    private Standard standard;
    private IMessage message;
    private IParserConfiguration configuration;

    private DSLGeneratorContext(Standard aStandard, Map<String, String> options) throws ParserConfigurationException {
        this.standard = aStandard;
        this.configuration = new StandardParserConfiguration(aStandard, options);
        this.message = this.configuration.getMessage();
    }

    private DSLGeneratorContext(Standard aStandard, IParserConfiguration theConfiguration, Map<String, String> options) throws ParserConfigurationException {
        this.standard = aStandard;
        this.configuration = theConfiguration;
        this.message = this.configuration.getMessage();
    }

    public static DSLGeneratorContext getInstance() {
        return instance;
    }

    public static DSLGeneratorContext initDSLGeneratorContext(Standard aStandard, IParserConfiguration theConfiguration, Map<String, String> options) throws ParserConfigurationException {
        if (aStandard == null) {
            throw new IllegalArgumentException("DSLGeneratorContext : bundle can't be null");
        }
        instance = theConfiguration == null ? new DSLGeneratorContext(aStandard, options) : new DSLGeneratorContext(aStandard, theConfiguration, options);
        return instance;
    }

    public static DSLGeneratorContext initDSLGeneratorContext(Standard aStandard, Map<String, String> options) throws ParserConfigurationException {
        if (aStandard == null) {
            throw new IllegalArgumentException("DSLGeneratorContext : bundle can't be null");
        }
        instance = new DSLGeneratorContext(aStandard, options);
        return instance;
    }

    public Standard getStrandard() {
        return this.standard;
    }

    public List<GenericRule> getActiveRuleList() {
        return this.standard.getRules().getRules();
    }

    public Block getContext(GenericRule rule) {
        Block context = null;
        if (rule.getComputedContext() != null) {
            context = rule.getComputedContext();
        }
        return context;
    }

    public List<DataType> getDataTypeList() {
        return this.standard.getDataTypes().getDatatypes();
    }

    public IParserConfiguration getConfiguration() {
        return this.configuration;
    }

    public IMessage getMessage() {
        return this.message;
    }
}

