/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.formules;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Quantifier implements Enumerator
{
    EVERY(0, "EVERY", "EVERY"),
    SOME(0, "SOME", "SOME"),
    NONE(0, "NONE", "NONE"),
    NONE_OR_EVERY(0, "NONE_OR_EVERY", "NONE_OR_EVERY");

    public static final int EVERY_VALUE = 0;
    public static final int SOME_VALUE = 0;
    public static final int NONE_VALUE = 0;
    public static final int NONE_OR_EVERY_VALUE = 0;
    private static final Quantifier[] VALUES_ARRAY;
    public static final List<Quantifier> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Quantifier[]{EVERY, SOME, NONE, NONE_OR_EVERY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Quantifier get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Quantifier result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Quantifier getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Quantifier result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Quantifier get(int value) {
        switch (value) {
            case 0: {
                return EVERY;
            }
        }
        return null;
    }

    private Quantifier(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

