/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UsageType implements Enumerator
{
    OPTIONAL(1, "Optional", "Optional"),
    CONDITIONAL(2, "Conditional", "Conditional"),
    MANDATORY(3, "Mandatory", "Mandatory"),
    FORBIDDEN(4, "Forbidden", "Forbidden"),
    UNSET(5, "Unset", "Unset");

    public static final int OPTIONAL_VALUE = 1;
    public static final int CONDITIONAL_VALUE = 2;
    public static final int MANDATORY_VALUE = 3;
    public static final int FORBIDDEN_VALUE = 4;
    public static final int UNSET_VALUE = 5;
    private static final UsageType[] VALUES_ARRAY;
    public static final List<UsageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UsageType[]{OPTIONAL, CONDITIONAL, MANDATORY, FORBIDDEN, UNSET};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UsageType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UsageType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UsageType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UsageType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UsageType get(int value) {
        switch (value) {
            case 1: {
                return OPTIONAL;
            }
            case 2: {
                return CONDITIONAL;
            }
            case 3: {
                return MANDATORY;
            }
            case 4: {
                return FORBIDDEN;
            }
            case 5: {
                return UNSET;
            }
        }
        return null;
    }

    private UsageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

