/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.xml;

import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.RuleCriticity;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.DataTypeDescription;
import fr.cnav.saturne.api.model.access.DeclarationBlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.IdQualifiedElementDescription;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.IFieldLocalizer;
import fr.cnav.saturne.validator.ITreeAndDeclarationConsumer;
import fr.cnav.saturne.validator.ITreeConsumer;
import fr.cnav.saturne.validator.SequentialLocalizer;
import fr.cnav.saturne.validator.TreeProcessingException;
import fr.cnav.saturne.validator.conversion.xml.BlockDeclarationAnnotation;
import fr.cnav.saturne.validator.declaration.DeclarationListener;
import fr.cnav.saturne.validator.declaration.IDeclarationIdentificationListener;
import fr.cnav.saturne.validator.impl.LineAndColumnLocalizer;
import fr.cnav.saturne.validator.message.LastReadFieldAnnotation;
import fr.cnav.saturne.validator.message.MessageBlock;
import fr.cnav.saturne.validator.message.MessageElementFactory;
import fr.cnav.saturne.validator.message.MessageField;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.message.api.IMessageFieldAlphanum;
import fr.cnav.saturne.validator.message.api.IMessageFieldDate;
import fr.cnav.saturne.validator.message.api.IMessageFieldNum;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.TooManyAnomaliesException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLHandler
extends DefaultHandler
implements IDeclarationIdentificationListener {
    private static final String DECLARATION_TYPE_ATTRIBUTE = "xsi:type";
    private static final String NS_SEPARATOR_REGEX = ":";
    private List<ITreeConsumer> consumers;
    private Stack<IMessageBlock> stack;
    private MessageElementFactory factory;
    private StandardAccessor modelAccessor;
    private String nsPrefix;
    private Map<String, String> qualifiedIdMap;
    private IReportLogger logger;
    private ControlMessages controlMessages;
    private final Locator locator;
    private String lastXSIType;
    private String lastReadFieldName;
    private IMessageField<?> lastReadField;
    private StringBuilder lastReadFieldContent;
    private String lastOriginLineNumberStr;
    private String lastOriginalValue;
    private int fieldRank;
    private boolean originalLineNumberExpected;
    private boolean originalLineNumberModeSet;
    private String erroneousTagName;
    private final boolean saveBlock;
    private DeclarationListener declarationListener;
    private HashMap<String, DeclarationDescription> declarationTypeToDeclarationMap;

    public XMLHandler(StandardAccessor modelAccessor, Map<String, String> xmlTag2FullQualifiedIdMap, IReportLogger theLogger, ControlMessages messages, Boolean saveBlock, Boolean xmlNoPrefix) {
        this.modelAccessor = modelAccessor;
        this.initDeclarationMap(modelAccessor.getStandardDescription());
        this.factory = new MessageElementFactory(modelAccessor);
        this.nsPrefix = xmlNoPrefix != false ? "" : modelAccessor.getStandard().getNamespacePrefix();
        this.stack = new Stack();
        this.qualifiedIdMap = xmlTag2FullQualifiedIdMap;
        this.logger = theLogger;
        this.controlMessages = messages;
        this.locator = new LocatorImpl();
        this.setDocumentLocator(this.locator);
        this.consumers = new ArrayList<ITreeConsumer>();
        this.saveBlock = saveBlock;
        this.declarationListener = new DeclarationListener(modelAccessor);
        this.consumers.add(this.declarationListener);
        this.declarationListener.addListener(this);
    }

    public void addConsumer(List<ITreeConsumer> theconsumers) {
        this.consumers.addAll(theconsumers);
    }

    @Override
    public void startDocument() throws SAXException {
        for (ITreeConsumer consumer : this.consumers) {
            try {
                consumer.startTree();
            }
            catch (TreeProcessingException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void endDocument() throws SAXException {
        for (ITreeConsumer consumer : this.consumers) {
            try {
                consumer.endTree();
            }
            catch (TreeProcessingException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.erroneousTagName == null) {
            String xmlName = localName.isEmpty() ? qName.substring(this.nsPrefix.length() + 1) : localName;
            String elementName = this.qualifiedIdMap.get(xmlName);
            if (elementName == null) {
                this.erroneousTagName = xmlName;
                try {
                    this.logger.logAnomaly(this.factory.createMessageField(xmlName, "", new LineAndColumnLocalizer(this.locator.getLineNumber(), this.locator.getColumnNumber())), "CST07", this.controlMessages.getMessage("syntactic.messages.CST07", new Object[]{xmlName}), RuleCriticity.BLOCKING);
                }
                catch (TooManyAnomaliesException e) {
                    this.processRemainingStack();
                    throw new SAXException(e);
                }
            } else if (elementName.equals(this.modelAccessor.getMessage().getFullQualifiedId())) {
                this.processBlockEnter(this.factory.getRootContextBlock(), attributes);
            } else if (this.modelAccessor.getBlock(elementName) != null) {
                IMessageBlock block = this.createBlock(attributes, elementName);
                this.processBlockEnter(block, attributes);
            } else {
                this.processField(elementName, attributes);
            }
        }
    }

    private IMessageBlock createBlock(Attributes attributes, String elementName) {
        String declarationType = attributes.getValue(DECLARATION_TYPE_ATTRIBUTE);
        DeclarationDescription declarationBlockDescription = this.getDeclaration(declarationType);
        MessageBlock block = null;
        if (declarationBlockDescription != null) {
            block = this.factory.createDeclarationBlock(elementName, declarationType);
            this.addDeclarationAnnotation(declarationBlockDescription, block);
        } else {
            block = this.factory.createMessageBlock(elementName);
        }
        return block;
    }

    private void addDeclarationAnnotation(DeclarationDescription declarationDescription, IMessageBlock block) {
        if (declarationDescription != null) {
            ((MessageBlock)block).addAnnotation(new BlockDeclarationAnnotation(declarationDescription));
        }
    }

    private DeclarationDescription getDeclaration(String declarationType) {
        if (declarationType == null) {
            return null;
        }
        String typeValue = null;
        typeValue = declarationType.contains(NS_SEPARATOR_REGEX) ? declarationType.split(NS_SEPARATOR_REGEX)[1] : declarationType;
        return this.declarationTypeToDeclarationMap.get(typeValue);
    }

    private void processField(String elementName, Attributes attributes) {
        this.lastReadFieldName = elementName;
        this.lastReadFieldContent = new StringBuilder();
        this.lastOriginLineNumberStr = attributes.getValue("", "originLineNumber");
        this.lastOriginalValue = attributes.getValue("", "originalValue");
    }

    private void processBlockEnter(IMessageBlock messageBlock, Attributes attributes) throws SAXException {
        if (this.saveBlock) {
            this.stack.push(messageBlock);
        }
        ((MessageBlock)messageBlock).addAnnotation(new LastReadFieldAnnotation(this.lastReadField));
        if (messageBlock.getStandardBlockDescription() instanceof DeclarationBlockDescription) {
            int index;
            this.lastXSIType = attributes.getValue(DECLARATION_TYPE_ATTRIBUTE);
            if (this.lastXSIType != null && (index = this.lastXSIType.indexOf(58)) >= 0) {
                this.lastXSIType = this.lastXSIType.substring(index + 1);
            }
        }
        for (ITreeConsumer consumer : this.consumers) {
            try {
                consumer.enterBlock(messageBlock);
            }
            catch (TreeProcessingException e) {
                throw new SAXException(e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.erroneousTagName == null && this.lastReadFieldContent != null) {
            int i = start;
            while (i < start + length) {
                this.lastReadFieldContent.append(ch[i]);
                ++i;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String xmlName = localName.isEmpty() ? qName.substring(this.nsPrefix.length() + 1) : localName;
        if (this.erroneousTagName == null) {
            String elementName = this.qualifiedIdMap.get(xmlName);
            Field field = this.modelAccessor.getField(elementName);
            if (field != null) {
                try {
                    this.finalizeField();
                }
                catch (TreeProcessingException e) {
                    throw new SAXException(e);
                }
                catch (TooManyAnomaliesException e) {
                    this.processRemainingStack();
                    throw new SAXException(e);
                }
            } else {
                try {
                    this.processBlockExit();
                }
                catch (TooManyAnomaliesException e) {
                    this.processRemainingStack();
                    throw new SAXException(e);
                }
            }
        } else if (this.erroneousTagName.equals(xmlName)) {
            this.erroneousTagName = null;
        }
    }

    private void processBlockExit() throws SAXException, TooManyAnomaliesException {
        block13: {
            IMessageBlock parent;
            if (!this.saveBlock) break block13;
            IMessageBlock block = this.stack.pop();
            IMessageBlock iMessageBlock = parent = this.stack.isEmpty() ? null : this.stack.peek();
            if (parent != null) {
                IdQualifiedElementDescription parentBlockDescription;
                if (block.getFields().size() == 0) {
                    this.logger.logAnomaly(this.lastReadField, "XML-04", this.controlMessages.getMessage("syntactic.messages.XML04", new Object[]{block.getStandardBlockDescription().getFullQualifiedId()}), RuleCriticity.NOT_BLOCKING);
                }
                if ((parentBlockDescription = block.getStandardBlockDescription().getParent()).equals(parent.getStandardBlockDescription())) {
                    this.stack.peek().addBlock(block);
                    for (ITreeConsumer consumer : this.consumers) {
                        try {
                            consumer.exitBlock(block);
                        }
                        catch (TreeProcessingException e) {
                            if (e.getCause() instanceof TooManyAnomaliesException) {
                                throw (TooManyAnomaliesException)e.getCause();
                            }
                            throw new SAXException(e);
                        }
                    }
                } else {
                    IMessageField<?> firstField = block.getFields().size() == 0 ? null : block.getFields().get(0);
                    this.logger.logAnomaly(firstField, "CV11", this.controlMessages.getMessage("conversion.messages.CV11", new Object[]{block.getStandardBlockDescription().getFullQualifiedId(), parent.getStandardBlockDescription().getFullQualifiedId()}), RuleCriticity.BLOCKING);
                }
            } else {
                for (ITreeConsumer consumer : this.consumers) {
                    try {
                        consumer.exitBlock(block);
                    }
                    catch (TreeProcessingException e) {
                        if (e.getCause() instanceof TooManyAnomaliesException) {
                            throw (TooManyAnomaliesException)e.getCause();
                        }
                        throw new SAXException(e);
                    }
                }
            }
        }
    }

    protected void processRemainingStack() {
        while (!this.stack.isEmpty()) {
            IdQualifiedElementDescription parentBlock;
            IMessageBlock parent;
            IMessageBlock block = this.stack.pop();
            IMessageBlock iMessageBlock = parent = this.stack.isEmpty() ? null : this.stack.peek();
            if (parent == null || !(parentBlock = block.getStandardBlockDescription().getParent()).equals(parent.getStandardBlockDescription())) continue;
            this.stack.peek().addBlock(block);
        }
    }

    private NatureType getFieldNature(IMessageField<?> field) throws TreeProcessingException {
        FieldDescription stdField = field.getStandardFieldDescription();
        if (stdField == null) {
            throw new TreeProcessingException("Field of name " + field.getStandardFieldDescription().getFullQualifiedId() + "couldn't be found");
        }
        DataTypeDescription type = stdField.getDataType();
        if (type == null) {
            throw new TreeProcessingException("Field of name " + field.getStandardFieldDescription().getFullQualifiedId() + " has no data type associated.");
        }
        return type.getNature();
    }

    private void finalizeField() throws TreeProcessingException, TooManyAnomaliesException {
        IFieldLocalizer localizer;
        if (!this.originalLineNumberModeSet) {
            this.originalLineNumberExpected = this.lastOriginLineNumberStr != null;
            this.originalLineNumberModeSet = true;
        }
        ++this.fieldRank;
        String fieldName = this.lastReadFieldName;
        String originalValue = this.lastOriginalValue == null ? this.lastReadFieldContent.toString().trim() : this.lastOriginalValue;
        this.lastReadFieldContent = null;
        this.lastOriginalValue = null;
        if (this.lastOriginLineNumberStr != null && !"0".equals(this.lastOriginLineNumberStr.trim())) {
            try {
                int line = Integer.parseInt(this.lastOriginLineNumberStr);
                localizer = new SequentialLocalizer(line);
            }
            catch (NumberFormatException numberFormatException) {
                localizer = new LineAndColumnLocalizer(this.locator.getLineNumber(), this.locator.getColumnNumber());
            }
        } else {
            localizer = new SequentialLocalizer(this.fieldRank);
        }
        MessageField<?> field = this.factory.createMessageField(fieldName, originalValue, localizer);
        if (this.saveBlock) {
            IMessageBlock parent = this.stack.peek();
            if (parent.getStandardBlockDescription() != field.getStandardFieldDescription().getParent()) {
                this.logger.logAnomaly(field, "CST-10", this.controlMessages.getMessage("syntactic.messages.CST10", new Object[]{field.getStandardFieldDescription().getFullQualifiedId()}), RuleCriticity.BLOCKING);
            } else if (parent.getField(field.getIndex()) != null) {
                this.logger.logAnomaly(field, "CST-09", this.controlMessages.getMessage("syntactic.messages.CST09", new Object[]{field.getStandardFieldDescription().getFullQualifiedId()}), RuleCriticity.BLOCKING);
            } else {
                parent.addField(field);
                this.lastReadField = field;
                NatureType nature = this.getFieldNature(field);
                this.signalFields(field, nature);
                if (this.originalLineNumberExpected && this.lastOriginLineNumberStr == null || !this.originalLineNumberExpected && this.lastOriginLineNumberStr != null) {
                    this.logger.logAnomaly(field, "XML-01", this.controlMessages.getMessage("syntactic.messages.XML01", new Object[]{fieldName}), RuleCriticity.NOT_BLOCKING);
                }
            }
        } else {
            this.lastReadField = field;
            NatureType nature = this.getFieldNature(field);
            this.signalFields(field, nature);
        }
    }

    private void signalFields(IMessageField<?> field, NatureType nature) throws TreeProcessingException {
        switch (nature) {
            case ALPHANUMERIC: 
            case ENUMERATION: 
            case EXTERNAL_REFERENTIAL: {
                for (ITreeConsumer consumer : this.consumers) {
                    consumer.signalAlphanumField((IMessageFieldAlphanum)field);
                }
                break;
            }
            case DATE: {
                for (ITreeConsumer consumer : this.consumers) {
                    consumer.signalDateField((IMessageFieldDate)field);
                }
                break;
            }
            case NUMERIC: {
                for (ITreeConsumer consumer : this.consumers) {
                    consumer.signalNumericField((IMessageFieldNum)field);
                }
                break;
            }
            default: {
                throw new TreeProcessingException(String.valueOf(nature.getName()) + " - " + nature.getLiteral() + " : unknown type nature : shouldn't happen.");
            }
        }
    }

    private boolean validXSIDeclarationType(String name) {
        if (name != null) {
            Standard standard = this.modelAccessor.getStandard();
            for (Declaration declaration : standard.getDeclarations()) {
                if (!name.equals(declaration.getName().replaceAll(" ", "_"))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void signalDeclaration(IMessageBlock block, DeclarationDescription declaration) throws TreeProcessingException {
        String msg = null;
        String code = null;
        if (this.lastXSIType != null && !this.validXSIDeclarationType(this.lastXSIType.replaceAll(" ", "_"))) {
            msg = this.controlMessages.getMessage("syntactic.messages.XML03");
            code = "XML-03";
        } else if (!(this.lastXSIType == null || declaration != null && this.lastXSIType.replaceAll(" ", "_").equals(declaration.getName().replaceAll(" ", "_")))) {
            String actualDecl = declaration == null ? "" : declaration.getName();
            msg = this.controlMessages.getMessage("syntactic.messages.XML02", new Object[]{actualDecl, this.lastXSIType});
            code = "XML-02";
        } else if (declaration == null) {
            msg = this.controlMessages.getMessage("syntactic.messages.XML03");
            code = "XML-03";
        }
        try {
            if (msg != null) {
                IMessageField<?> triggeringField = block.getFields().size() > 0 ? block.getFields().get(0) : this.lastReadField;
                this.logger.logAnomaly(triggeringField, code, msg, RuleCriticity.BLOCKING);
            } else {
                ((MessageBlock)block).addAnnotation(new BlockDeclarationAnnotation(declaration));
                for (ITreeConsumer consumer : this.consumers) {
                    if (!(consumer instanceof ITreeAndDeclarationConsumer)) continue;
                    ((ITreeAndDeclarationConsumer)consumer).signalDeclaration(block, declaration);
                }
            }
        }
        catch (TooManyAnomaliesException e) {
            this.processRemainingStack();
            throw new TreeProcessingException(e);
        }
    }

    private void initDeclarationMap(StandardDescription theStandard) {
        this.declarationTypeToDeclarationMap = new HashMap();
        List declarations = theStandard.getDeclarations();
        for (DeclarationDescription declaration : declarations) {
            this.declarationTypeToDeclarationMap.put(declaration.getName().replaceAll(" ", "_"), declaration);
        }
    }
}

