/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.positional.util;

import fr.cnav.saturne.validator.positional.EmptyDefinition;
import fr.cnav.saturne.validator.positional.FieldSpecification;
import fr.cnav.saturne.validator.positional.FooterEnum;
import fr.cnav.saturne.validator.positional.FooterSpecification;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.HeaderEnum;
import fr.cnav.saturne.validator.positional.HeaderSpecification;
import fr.cnav.saturne.validator.positional.PositionalPackage;
import fr.cnav.saturne.validator.positional.RecordIdSpecification;
import fr.cnav.saturne.validator.positional.RecordSpecification;
import fr.cnav.saturne.validator.positional.custom.PositionalValidatorCustom;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class PositionalValidator
extends EObjectValidator {
    public static final PositionalValidator INSTANCE = new PositionalValidatorCustom();
    public static final String DIAGNOSTIC_SOURCE = "fr.cnav.saturne.validator.positional";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return PositionalPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateFormatSpecification((FormatSpecification)value, diagnostics, context);
            }
            case 1: {
                return this.validateRecordIdSpecification((RecordIdSpecification)value, diagnostics, context);
            }
            case 2: {
                return this.validateFieldSpecification((FieldSpecification)value, diagnostics, context);
            }
            case 3: {
                return this.validateRecordSpecification((RecordSpecification)value, diagnostics, context);
            }
            case 4: {
                return this.validateEmptyDefinition((EmptyDefinition)value, diagnostics, context);
            }
            case 5: {
                return this.validateHeaderSpecification((HeaderSpecification)value, diagnostics, context);
            }
            case 6: {
                return this.validateFooterSpecification((FooterSpecification)value, diagnostics, context);
            }
            case 7: {
                return this.validateHeaderEnum((HeaderEnum)((Object)value), diagnostics, context);
            }
            case 8: {
                return this.validateFooterEnum((FooterEnum)((Object)value), diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateFormatSpecification(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(formatSpecification, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(formatSpecification, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noAbsentDefinitionsWithSameNature(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noHeaderSpecificationsWithSameValue(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noFooterSpecificationsWithSameValue(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noRecordSpecificaionWithSameRecordType(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_validRecordIdSpecification(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noDuplicatedBlock(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_validateAttributeCardinality(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noStringAtTrimmingCharacter(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noMultipleRecordWithOneRecordIdNotDefined(formatSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFormatSpecification_noRecordIdSpecNotDefinedAfterFirstOneGood(formatSpecification, diagnostics, context);
        }
        return result;
    }

    public boolean validateFormatSpecification_noAbsentDefinitionsWithSameNature(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noHeaderSpecificationsWithSameValue(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noFooterSpecificationsWithSameValue(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noRecordSpecificaionWithSameRecordType(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_validRecordIdSpecification(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noDuplicatedBlock(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_validateAttributeCardinality(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noStringAtTrimmingCharacter(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noMultipleRecordWithOneRecordIdNotDefined(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFormatSpecification_noRecordIdSpecNotDefinedAfterFirstOneGood(FormatSpecification formatSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRecordIdSpecification(RecordIdSpecification recordIdSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(recordIdSpecification, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(recordIdSpecification, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(recordIdSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRecordIdSpecification_validRecordTypePosition(recordIdSpecification, diagnostics, context);
        }
        return result;
    }

    public boolean validateRecordIdSpecification_validRecordTypePosition(RecordIdSpecification recordIdSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFieldSpecification(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(fieldSpecification, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(fieldSpecification, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldSpecification_validPosition(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldSpecification_validField(fieldSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateFieldSpecification_validFormat(fieldSpecification, diagnostics, context);
        }
        return result;
    }

    public boolean validateFieldSpecification_validPosition(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFieldSpecification_validField(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFieldSpecification_validFormat(FieldSpecification fieldSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRecordSpecification(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(recordSpecification, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(recordSpecification, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRecordSpecification_recordLengthIncludesRecordTypePosition(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRecordSpecification_noOverlappingOfFieldPositionForRecord(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRecordSpecification_isRegexRecordTypeValid(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRecordSpecification_noDuplicatedField(recordSpecification, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateRecordSpecification_validateAttributeCardinality(recordSpecification, diagnostics, context);
        }
        return result;
    }

    public boolean validateRecordSpecification_recordLengthIncludesRecordTypePosition(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRecordSpecification_noOverlappingOfFieldPositionForRecord(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRecordSpecification_isRegexRecordTypeValid(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRecordSpecification_noDuplicatedField(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateRecordSpecification_validateAttributeCardinality(RecordSpecification recordSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateEmptyDefinition(EmptyDefinition emptyDefinition, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(emptyDefinition, diagnostics, context);
    }

    public boolean validateHeaderSpecification(HeaderSpecification headerSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(headerSpecification, diagnostics, context);
    }

    public boolean validateFooterSpecification(FooterSpecification footerSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(footerSpecification, diagnostics, context);
    }

    public boolean validateHeaderEnum(HeaderEnum headerEnum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateFooterEnum(FooterEnum footerEnum, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

