/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.report.model;

import fr.cnav.saturne.report.model.Anomaly;
import fr.cnav.saturne.report.model.Context;
import java.util.ArrayList;
import java.util.List;

public class Report {
    private final String normUri;
    private final String normVersion;
    private String validationId;
    private String validationTimeStamp;
    private Context rootContext;
    private List<Anomaly> allAnomalies;

    public Report(String normUri, String normVersion) {
        this.normUri = normUri;
        this.normVersion = normVersion;
    }

    public String getNormVersion() {
        return this.normVersion;
    }

    public String getValidationId() {
        return this.validationId;
    }

    public void setValidationId(String validationId) {
        this.validationId = validationId;
    }

    public void setValidationTimeStamp(String validationTimeStamp) {
        this.validationTimeStamp = validationTimeStamp;
    }

    public String getValidationTimeStamp() {
        return this.validationTimeStamp;
    }

    public String getNormUri() {
        return this.normUri;
    }

    public Context getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(Context rootContext) {
        this.rootContext = rootContext;
    }

    public List<Anomaly> getAllAnomalies() {
        if (this.allAnomalies == null) {
            this.allAnomalies = this.getAllAnomalies(this.rootContext);
        }
        return this.allAnomalies;
    }

    private List<Anomaly> getAllAnomalies(Context context) {
        ArrayList<Anomaly> results = new ArrayList<Anomaly>();
        results.addAll(context.getAnomalies());
        List<Context> contextChildren = context.getContextChildren();
        for (Context contextTemp : contextChildren) {
            results.addAll(this.getAllAnomalies(contextTemp));
        }
        return results;
    }
}

