/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.providers.detail;

import fr.cnav.autocontrole.Messages;
import fr.cnav.autocontrole.helpers.StandardHelper;
import fr.cnav.autocontrole.providers.detail.CommonDetailProvider;
import fr.cnav.autocontrole.providers.detail.DetailTableFormatter;
import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.api.model.access.FieldRefinementDescription;
import fr.cnav.saturne.api.model.access.GenericRuleDescription;
import fr.cnav.saturne.api.model.access.RuleSetDescription;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import java.util.Collection;
import java.util.List;

public class NormeDetailProvider
extends CommonDetailProvider {
    private DetailTableFormatter sousGroupFormatter;
    private DetailTableFormatter groupFormatter;
    private DetailTableFormatter categorieFormatter;
    private DetailTableFormatter natureContentFormatter;
    private DetailTableFormatter rulesFormatter;

    public NormeDetailProvider() {
        this.initSousGroupFormatter();
        this.initGroupFormatter();
        this.initCategorieFormatter();
        this.initNatureContentFormatter();
        this.initRulesFormatter();
    }

    private void initNatureContentFormatter() {
        this.natureContentFormatter = new DetailTableFormatter();
        this.natureContentFormatter.prepareValueLineSeparator();
    }

    private void initRulesFormatter() {
        this.rulesFormatter = new DetailTableFormatter();
        this.rulesFormatter.prepareValueLineSeparator();
    }

    private void initSousGroupFormatter() {
        this.sousGroupFormatter = new DetailTableFormatter();
        this.sousGroupFormatter.addTitle(Messages.NormeDetailProvider_0).addTitle(Messages.NormeDetailProvider_1).addTitle(Messages.NormeDetailProvider_2).prepareValueLineSeparator();
    }

    private void initGroupFormatter() {
        this.groupFormatter = new DetailTableFormatter();
        this.groupFormatter.addTitle(Messages.NormeDetailProvider_3).addTitle(Messages.NormeDetailProvider_4).addTitle(Messages.NormeDetailProvider_5).prepareValueLineSeparator();
    }

    private void initCategorieFormatter() {
        this.categorieFormatter = new DetailTableFormatter();
        this.categorieFormatter.addTitle(Messages.NormeDetailProvider_6).addTitle(Messages.NormeDetailProvider_7).addTitle(Messages.NormeDetailProvider_8).prepareValueLineSeparator();
    }

    public String getText(Object element, DeclarationDescription decl) {
        String details = "";
        if (element instanceof BlockDescription) {
            details = this.getText((BlockDescription)element);
        } else if (element instanceof FieldDescription) {
            details = this.getText((FieldDescription)element, decl);
        } else if (element instanceof IMessageBlock) {
            details = this.getText((BlockDescription)((IMessageBlock)element).getStandardBlockDescription());
        } else if (element instanceof IMessageField) {
            details = this.getText(((IMessageField)element).getStandardFieldDescription(), decl);
        } else if (element instanceof FieldRefinementDescription) {
            details = this.getText(((FieldRefinementDescription)element).getField(), decl);
        }
        return details;
    }

    private String getText(BlockDescription selectedObject) {
        return this.sousGroupFormatter.razValue().addValue(selectedObject.getFullQualifiedId()).addValue(selectedObject.getName()).addValue(selectedObject.getDescription()).printTable();
    }

    private String getText(FieldDescription selectedObject, DeclarationDescription decl) {
        Object inhibitedRules;
        FieldRefinementDescription value;
        String categoryDetail = "";
        this.categorieFormatter.razValue().addValue(String.valueOf(selectedObject.getFullQualifiedId()) + " / " + selectedObject.getName()).addValue(this.getUsageTranslation(selectedObject)).addValue(this.getNatureTranslation(selectedObject));
        categoryDetail = String.valueOf(categoryDetail) + this.categorieFormatter.printTable();
        StandardDescription standard = StandardHelper.getInstance().getStandard();
        RuleSetDescription rules = standard.getRules();
        List fieldRules = rules.getRulesForField(selectedObject);
        if (decl != null && (value = (FieldRefinementDescription)decl.getFieldRefinements().get(selectedObject)) != null && (inhibitedRules = value.getInhibitedRules()).size() != 0) {
            fieldRules.removeAll((Collection<?>)inhibitedRules);
        }
        if (fieldRules.size() > 0) {
            categoryDetail = String.valueOf(categoryDetail) + "---------------------------------------------------\n";
        }
        this.rulesFormatter.razValue();
        for (GenericRuleDescription rule : fieldRules) {
            String description = rule.getDescription();
            if (description == null) {
                description = "";
            }
            StringBuilder sb = new StringBuilder();
            String derivedId = sb.append(rule.getType() != null ? rule.getType().getName() : "TYPE?").append("-").append(rule.getId()).toString();
            this.rulesFormatter.addValueNoBordered(String.valueOf(derivedId) + " : " + description);
        }
        categoryDetail = String.valueOf(categoryDetail) + this.rulesFormatter.printTable();
        categoryDetail = String.valueOf(categoryDetail) + "---------------------------------------------------\n";
        String enumValues = this.getEnumValues(this.natureContentFormatter, selectedObject);
        String externalDescription = this.getExternalDescription(this.natureContentFormatter, selectedObject);
        categoryDetail = String.valueOf(categoryDetail) + enumValues;
        categoryDetail = String.valueOf(categoryDetail) + externalDescription;
        if (!"".equals(enumValues) || !"".equals(externalDescription)) {
            categoryDetail = String.valueOf(categoryDetail) + "---------------------------------------------------\n";
        }
        return categoryDetail;
    }

    private String getUsageTranslation(FieldDescription selectedObject) {
        String oldValue;
        String usageTranslation = oldValue = selectedObject.getUsage().getName();
        if (Messages.NormeDetailTranslateUsageKey_0.equals(oldValue)) {
            usageTranslation = Messages.NormeDetailTranslateUsageValue_0;
        } else if (Messages.NormeDetailTranslateUsageKey_1.equals(oldValue)) {
            usageTranslation = Messages.NormeDetailTranslateUsageValue_1;
        } else if (Messages.NormeDetailTranslateUsageKey_2.equals(oldValue)) {
            usageTranslation = Messages.NormeDetailTranslateUsageValue_2;
        }
        return usageTranslation;
    }

    private String getNatureTranslation(FieldDescription selectedObject) {
        String oldValue;
        String natureTranslation = oldValue = selectedObject.getDataType().getNature().getName();
        if (Messages.NormeDetailTranslateNatureKey_0.equals(oldValue)) {
            natureTranslation = Messages.NormeDetailTranslateNatureValue_0;
        } else if (Messages.NormeDetailTranslateNatureKey_1.equals(oldValue)) {
            natureTranslation = Messages.NormeDetailTranslateNatureValue_1;
        } else if (Messages.NormeDetailTranslateNatureKey_2.equals(oldValue)) {
            natureTranslation = Messages.NormeDetailTranslateNatureValue_2;
        } else if (Messages.NormeDetailTranslateNatureKey_3.equals(oldValue)) {
            natureTranslation = Messages.NormeDetailTranslateNatureValue_3;
        }
        return natureTranslation;
    }

    public DetailTableFormatter getSousGroupFormatter() {
        return this.sousGroupFormatter;
    }

    public DetailTableFormatter getGroupFormatter() {
        return this.groupFormatter;
    }

    public DetailTableFormatter getCategorieFormatter() {
        return this.categorieFormatter;
    }

    public DetailTableFormatter getNatureContentFormatter() {
        return this.natureContentFormatter;
    }
}

