/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.providers.detail;

import fr.cnav.autocontrole.Messages;
import fr.cnav.autocontrole.providers.NormeLabelProvider;
import fr.cnav.autocontrole.providers.detail.DetailTableFormatter;
import fr.cnav.autocontrole.providers.detail.NormeDetailProvider;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;

public class IndividualDetailProvider {
    private DetailTableFormatter rubriqueFormatter;
    private NormeDetailProvider normeDetailProvider;

    public IndividualDetailProvider() {
        this.initRubriqueFormatter();
        this.normeDetailProvider = new NormeDetailProvider();
    }

    private void initRubriqueFormatter() {
        this.rubriqueFormatter = new DetailTableFormatter();
        this.rubriqueFormatter.addTitle(Messages.SalarieDetailProvider_1).addTitle(Messages.SalarieDetailProvider_2).addTitle(Messages.SalarieDetailProvider_3).prepareValueLineSeparator();
    }

    public String getText(Object selectedObject, String anomalie) {
        String text = "";
        if (selectedObject instanceof IMessageField) {
            IMessageField selectedRubrique = (IMessageField)selectedObject;
            text = this.getTextRubrique(selectedRubrique, anomalie);
        } else if (selectedObject instanceof IMessageBlock) {
            NormeLabelProvider normeLabelProvider = new NormeLabelProvider();
            normeLabelProvider.getText(selectedObject, 0);
            text = this.normeDetailProvider.getSousGroupFormatter().razValue().addValue(normeLabelProvider.getText(selectedObject, 2)).addValue(normeLabelProvider.getText(selectedObject, 3)).addValue(normeLabelProvider.getText(selectedObject, 4)).printTable();
        }
        return text;
    }

    private String getTextRubrique(IMessageField<?> selectedObject, String anomalie) {
        NormeLabelProvider salarieLabelProvider = new NormeLabelProvider();
        this.rubriqueFormatter.razValue().addValue(String.valueOf(selectedObject.getFieldLocalizer().getLineNumber())).addValue(salarieLabelProvider.getText(selectedObject, 0)).addValue(selectedObject.getValueAsString());
        if (anomalie != null && !"".equals(anomalie)) {
            this.rubriqueFormatter.addValueBordered(anomalie);
        }
        return this.rubriqueFormatter.printTable();
    }
}

