/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.providers.detail;

import fr.cnav.autocontrole.exception.AutoCtrlException;
import fr.cnav.autocontrole.exception.ExceptionKind;
import java.util.ArrayList;
import java.util.List;

public class DetailTableFormatter {
    public static final String SEPARATOR = " : ";
    public static final String LINE_SEPARATOR = "---------------------------------------------------";
    public static final String NEWLINE = "\n";
    public static final String NEWLINE_REGEXP = "\\n";
    private List<String> titleList = new ArrayList<String>();
    private List<String> valueList = new ArrayList<String>();
    private List<String> valueSeparatorList;
    private List<String> valueBorderedList = new ArrayList<String>();
    private List<List<String>> listOfvalueList;
    private int maxTitleSize = 0;
    private String strReplaceNewLine;
    private List<String> valueNoBorderedList = new ArrayList<String>();

    public DetailTableFormatter() {
        this.listOfvalueList = new ArrayList<List<String>>();
    }

    public DetailTableFormatter addTitle(String title) {
        this.titleList.add(title);
        this.maxTitleSize = Math.max(this.maxTitleSize, title.length());
        return this;
    }

    public DetailTableFormatter addValueBordered(String value) {
        this.valueBorderedList.add(value);
        return this;
    }

    public DetailTableFormatter addListOfValue(String name, String value) {
        ArrayList<String> couple = new ArrayList<String>();
        couple.add(name);
        couple.add(value);
        this.listOfvalueList.add(couple);
        return this;
    }

    public DetailTableFormatter prepareValueLineSeparator() {
        this.computeStrReplaceNewLine();
        this.valueSeparatorList = new ArrayList<String>();
        for (String title : this.titleList) {
            this.valueSeparatorList.add(this.strReplaceNewLine.substring(NEWLINE.length(), this.maxTitleSize - title.length() + NEWLINE.length()));
        }
        return this;
    }

    public DetailTableFormatter razValue() {
        this.valueList = new ArrayList<String>();
        this.valueBorderedList = new ArrayList<String>();
        this.listOfvalueList = new ArrayList<List<String>>();
        this.valueNoBorderedList = new ArrayList<String>();
        return this;
    }

    public DetailTableFormatter addValue(String value) {
        if (value == null) {
            this.valueList.add("");
        } else {
            if (this.valueList.size() == this.titleList.size()) {
                throw new AutoCtrlException(ExceptionKind.ERROR_FORMATER_INI_CANNOT_ADD_VALUE, value, this.titleList.size());
            }
            this.valueList.add(value);
        }
        return this;
    }

    private void computeStrReplaceNewLine() {
        StringBuilder strReplacement = new StringBuilder();
        int i = 0;
        while (i < this.maxTitleSize) {
            strReplacement.append(" ");
            ++i;
        }
        i = 0;
        while (i < SEPARATOR.length()) {
            strReplacement.append(" ");
            ++i;
        }
        this.strReplaceNewLine = NEWLINE + strReplacement.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String printTable() {
        void var2_3;
        if (this.valueSeparatorList == null) {
            throw new AutoCtrlException(ExceptionKind.ERROR_FORMATER_INI_NOT_PREPARE_METHOD_EXECUTED, "titre", this.titleList.size(), "value", this.valueList.size());
        }
        if (this.titleList.size() != this.valueList.size()) {
            throw new AutoCtrlException(ExceptionKind.ERROR_FORMATER_INI_NOT_EQUAL_LIST_SIZE, "titre", this.titleList.size(), "value", this.valueList.size());
        }
        StringBuffer result = new StringBuffer();
        boolean bl = false;
        while (var2_3 < this.titleList.size()) {
            result.append(this.titleList.get((int)var2_3));
            result.append(this.valueSeparatorList.get((int)var2_3));
            result.append(SEPARATOR);
            result.append(this.formatNewLineInValue(this.valueList.get((int)var2_3)));
            result.append(NEWLINE);
            ++var2_3;
        }
        if (this.valueBorderedList.size() > 0) {
            result.append(LINE_SEPARATOR);
            result.append(NEWLINE);
        }
        for (String string : this.valueBorderedList) {
            result.append(string);
            result.append(NEWLINE);
        }
        if (this.valueBorderedList.size() > 0) {
            result.append(LINE_SEPARATOR);
            result.append(NEWLINE);
        }
        for (String string : this.valueNoBorderedList) {
            result.append(string);
            result.append(NEWLINE);
        }
        for (List list : this.listOfvalueList) {
            result.append((String)list.get(0));
            result.append(SEPARATOR);
            result.append((String)list.get(1));
            result.append(NEWLINE);
        }
        return result.toString();
    }

    private String formatNewLineInValue(String value) {
        if (value == null) {
            return "";
        }
        return value.replaceAll(NEWLINE_REGEXP, this.strReplaceNewLine);
    }

    public void addValueNoBordered(String value) {
        this.valueNoBorderedList.add(value);
    }
}

