/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.app.service.helpers;

import fr.cnav.saturne.app.service.helpers.LoggerHelper;
import fr.cnav.saturne.app.service.helpers.Messages;
import java.io.File;

public class FilesManager {
    protected static final LoggerHelper LOGGER = new LoggerHelper(FilesManager.class);
    private String inputPath;
    private String outputFolderPath;

    public FilesManager(String inputPath, String outputFolderPath) {
        this.inputPath = inputPath;
        this.outputFolderPath = outputFolderPath;
    }

    public void moveFiles() {
        boolean isMkdir;
        File inputFile = new File(this.inputPath);
        File outuputFolder = new File(this.outputFolderPath);
        if (!outuputFolder.exists() && !(isMkdir = outuputFolder.mkdir())) {
            LOGGER.logError(Messages.LOG_RUNNING_61, outuputFolder.getAbsolutePath());
        }
        if (!inputFile.isDirectory() && inputFile.exists()) {
            File movedDSNFile = new File(outuputFolder, inputFile.getName());
            this.manageDestinationFolder(outuputFolder, movedDSNFile);
            boolean success = inputFile.renameTo(movedDSNFile);
            if (!success) {
                LOGGER.logError(Messages.LOG_RUNNING_30, movedDSNFile.getAbsolutePath());
            }
        }
    }

    public void moveFolderContent() {
        boolean done = false;
        File inputFile = new File(this.inputPath);
        File outuputFolder = new File(this.outputFolderPath);
        if (inputFile.isDirectory()) {
            File[] listFiles;
            File[] filesList = inputFile.listFiles();
            if (filesList != null) {
                File[] fileArray = filesList;
                int n = filesList.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    this.inputPath = file.getAbsolutePath();
                    this.moveFiles();
                    ++n2;
                }
            }
            if ((listFiles = inputFile.listFiles()) != null && listFiles.length == 0) {
                boolean isDelete = inputFile.delete();
                if (!isDelete) {
                    LOGGER.logError(Messages.LOG_RUNNING_62, inputFile.getAbsolutePath());
                }
                done = isDelete;
            } else {
                LOGGER.logError(Messages.LOG_RUNNING_32, inputFile.getAbsolutePath());
            }
            if (done) {
                LOGGER.logInfo(Messages.LOG_RUNNING_33, inputFile.getName(), outuputFolder.getName());
            }
        }
    }

    private void manageDestinationFolder(File outputFolder, File movedDSNFile) {
        File[] filesList = outputFolder.listFiles();
        if (filesList != null) {
            File[] fileArray = filesList;
            int n = filesList.length;
            int n2 = 0;
            while (n2 < n) {
                boolean deleted;
                File file = fileArray[n2];
                if (file.getName().equals(movedDSNFile.getName()) && !(deleted = file.delete())) {
                    LOGGER.logError(Messages.LOG_RUNNING_34, file.getAbsolutePath());
                }
                ++n2;
            }
        }
    }

    public static void deleteFolder(File folder) {
        if (folder == null) {
            LOGGER.logError(Messages.LOG_RUNNING_35);
            return;
        }
        if (!folder.exists()) {
            LOGGER.logError(Messages.LOG_RUNNING_36, folder.getAbsolutePath());
            return;
        }
        if (!folder.isDirectory()) {
            LOGGER.logError(Messages.LOG_RUNNING_37, folder.getAbsolutePath());
            return;
        }
        File[] fileList = folder.listFiles();
        if (fileList != null && fileList.length == 0) {
            boolean isDelete = folder.delete();
            if (!isDelete) {
                LOGGER.logError(Messages.LOG_RUNNING_62, folder.getAbsolutePath());
            }
        } else {
            boolean isDelete;
            if (fileList != null) {
                File[] fileArray = fileList;
                int n = fileList.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isFile()) {
                        LOGGER.logInfo(Messages.LOG_RUNNING_39, folder.getAbsolutePath(), file.getAbsolutePath());
                        boolean isDelete2 = file.delete();
                        if (!isDelete2) {
                            LOGGER.logError(Messages.LOG_RUNNING_63, file.getAbsolutePath());
                        }
                    } else {
                        LOGGER.logError(Messages.LOG_RUNNING_38, folder.getAbsolutePath(), file.getAbsolutePath());
                        return;
                    }
                    ++n2;
                }
            }
            if (!(isDelete = folder.delete())) {
                LOGGER.logError(Messages.LOG_RUNNING_62, folder.getAbsolutePath());
            }
        }
    }
}

