/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.syntax;

import fr.cnav.saturne.api.model.access.BlockDescription;
import fr.cnav.saturne.api.model.access.DeclarationDescription;
import fr.cnav.saturne.api.model.access.FieldDescription;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.engine.IRule;
import fr.cnav.saturne.validator.engine.IRuleResult;
import fr.cnav.saturne.validator.engine.RuleFailure;
import fr.cnav.saturne.validator.message.api.IMessageBlock;
import fr.cnav.saturne.validator.message.api.IMessageField;
import fr.cnav.saturne.validator.syntax.AbstractBlockSyntaxControl;
import fr.cnav.saturne.validator.syntax.MessageExtractor;
import java.util.ArrayList;
import java.util.List;

public class XML04Rule
extends AbstractBlockSyntaxControl {
    private final String fullQualifiedId;
    private List<FieldDescription> usedData;

    public XML04Rule(int id, BlockDescription curContext, ControlMessages controlMessage, DeclarationDescription declaration) {
        super(id, "XML-04", curContext, controlMessage, declaration);
        this.initUsedData();
        this.fullQualifiedId = curContext.getFullQualifiedId();
    }

    @Override
    public IRuleResult run(IMessageBlock context) {
        IRuleResult resultat = IRule.SUCCESS;
        if (context.getStandardBlockDescription() instanceof BlockDescription) {
            int numberOfFiel = ((BlockDescription)context.getStandardBlockDescription()).getFields().size();
            boolean containsField = false;
            int i = 0;
            while (i < numberOfFiel) {
                if (context.getField(i) != null) {
                    containsField = true;
                }
                ++i;
            }
            if (!containsField) {
                IMessageField<?> firstField = MessageExtractor.getFirstField(context);
                String message = this.controlMessage.getMessage("syntactic.messages.XML04", new Object[]{this.fullQualifiedId});
                resultat = new RuleFailure(this, firstField, firstField.getParent(), message);
            } else {
                resultat = IRule.SUCCESS;
            }
        } else {
            resultat = IRule.SUCCESS;
        }
        return resultat;
    }

    private void initUsedData() {
        if (this.getTarget() instanceof BlockDescription) {
            BlockDescription block = (BlockDescription)this.getTarget();
            this.usedData = block.getFields();
        }
        this.usedData = new ArrayList<FieldDescription>();
    }

    @Override
    public List<FieldDescription> getUsedData() {
        return this.usedData;
    }

    @Override
    public String getCode() {
        return "XML-04";
    }
}

