/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.validator.functions;

import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.api.model.access.StandardDescription;
import fr.cnav.saturne.options.Key;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.ControlMessages;
import fr.cnav.saturne.validator.ISequenceProvider;
import fr.cnav.saturne.validator.SaturneValidatorException;
import fr.cnav.saturne.validator.api.AbstractKBDescriptor;
import fr.cnav.saturne.validator.conversion.csv.CSVSequenceReader;
import fr.cnav.saturne.validator.conversion.json.JsonSequenceReader;
import fr.cnav.saturne.validator.conversion.keyvalue.SequentialReader;
import fr.cnav.saturne.validator.impl.FormatType;
import fr.cnav.saturne.validator.positional.FormatSpecification;
import fr.cnav.saturne.validator.positional.PositionalPackage;
import fr.cnav.saturne.validator.positional.conversion.ModelPositionalLoader;
import fr.cnav.saturne.validator.positional.conversion.PositionalFixSequenceReader;
import fr.cnav.saturne.validator.positional.util.PositionalResourceFactoryImpl;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class ValidationFunctionsHelper {
    public static final String THIS_METHOD_SHOULD_NOT_BE_USED_IN_THIS_CLASS = "This method should not be used in this class.";
    public static final String ERROR_MESSAGE_UNLOADABLE_RULE_PROPERTIES = "The properties file for rules usages override could not be load correctly.";
    public static final String SERIALIZER_ILLEGAL_ARGUMENT = "The parameter xmlSerializer of the serializeXML method can't be null";
    public static final String ENCODING_ILLEGAL_ARGUMENT = "The parameter encoding of the serializeXML method can't be null";
    public static final String MESSAGE_REPORT_OUTPUT_STREAM_CANNOT_BE_NULL = "The parameter reportOutput cannot be null";
    public static final String MESSAGE_PFX_FORMAT_ILLEGAL_ARGUMENT = "The parameter positionalFix format cannot be null";
    public static final String MESSAGE_OUTPUT_STREAM_CANNOT_BE_NULL = "The parameter outputStream cannot be null";
    public static final String MESSAGE_REPORT_LOGGER_CANNOT_BE_NULL = "The parameter reportLogger cannot be null";
    public static final String MESSAGE_REPORT_SERIALIZER_ILLEGAL_ARGUMENT = "The parameter serializer of the conversion method can't be null";
    public static final String MESSAGE_INPUT_STREAM_ILLEGAL_ARGUMENT = "The parameter inputStream of the conversion method can't be null";
    public static final String MESSAGE_ILLEGAL_ARGUMENT = "The parameter message of the conversion method can't be null";
    public static final String MESSAGE_BLOCK_ILLEGAL_ARGUMENT = "The parameter messageBlock of the conversion method can't be null";
    public static final String MESSAGE_ENDING_CONVERSION = "End of the conversion and validation in one pass";
    public static final String MESSAGE_ENDING_CONV_SYN_SEM_IN_ONE_PASS = "End of the conversion";
    public static final String MESSAGE_STARTING_CONVERSION = "Start of the conversion";
    public static final String MESSAGE_STARTING_CONV_SYN_SEM_IN_ONE_PASS = "Start of the conversion and validation in one pass";
    public static final String MESSAGE_REPORT_LOGGER_ILLEGAL_ARGUMENT = "The parameter reportLogger of the conversion method can't be null";
    public static final String MESSAGE_OUTPUT_FILE_ILLEGAL_ARGUMENT = "The parameter outputFile of the conversion method is null, does not exist or is not a file";
    public static final String MESSAGE_INPUT_FILE_ILLEGAL_ARGUMENT = "The parameter inputFile of the conversion method is null, does not exist or is not a file";
    public static final String MESSAGE_SYNTACTIC_OR_SEMANTIC_EXCEPTION = "The validation has failed.";
    public static final String MESSAGE_SYNTACTIC_EXCEPTION = "The syntactic validation has failed.";
    public static final String MESSAGE_SEMANTIC_EXCEPTION = "The semantic has failed.";
    public static final String MESSAGE_CONVERSION_SERIALIZATION_EXCEPTION = "The serialization of the converted message has failed";
    public static final String MESSAGE_CONVERSION_READING_EXCEPTION = "The conversion of a message into a MessageBlock has failed";
    public static final String MESSAGE_INPUT_FILE_EXCEPTION = "The input file can't be read";
    public static final String MESSAGE_INPUT_OUTPUT_FILE_EXCEPTION = "The input or output file can't be read";
    public static final String MESSAGE_XML_CONVERSION_READING_EXCEPTION = "The conversion of an XML message into a MessageBlock has failed";
    public static final String MESSAGE_REPORT_WRITING_EXCEPTION = "The XML report serialization has failed";
    public static final String MESSAGE_STARTING_WRITING_REPORT = "Start of the report writing";
    public static final String MESSAGE_ENDING_WRITING_REPORT = "End of the report writing";
    public static final String MESSAGE_STARTING_SYNTACTIC_AND_SEMANTIC_VALIDATION = "Start of the syntactic and semantic validation";
    public static final String MESSAGE_STARTING_SYNTACTIC_VALIDATION = "Start of the syntactic validation";
    public static final String MESSAGE_ENDING_SYNTACTIC_VALIDATION = "End of the syntactic validation";
    public static final String MESSAGE_ENDING_SYNTACTIC_AND_SEMANTIC_VALIDATION = "End of the syntactic and semantic validation";
    public static final String MESSAGE_ENDING_SEMANTIC_VALIDATION = "End of the semantic validation";
    public static final String MESSAGE_STARTING_SEMANTIC_VALIDATION = "Start of the semantic validation";
    public static final String MESSAGE_WORKSPACE_STANDARD_SHOULD_NOT_BE_USED_FOR_VALIDATION = "It is forbidden to validate a Standard loaded from the workspace";
    public static final String MESSAGE_STARTING_CONVERSION_SERIALIZATION = "Start of the serialization of the converted message";
    public static final String MESSAGE_ENDING_CONVERSION_SERIALIZATION = "End of the serialization of the converted message";
    public static final String MESSAGE_STARTING_READING_XML = "Start of the reading of an XML message";
    public static final String MESSAGE_ENDING_READING_XML = "End of the reading of an XML message";
    public static final String CONTROL_MESSAGE_NULL = "The given controls message component is null";
    public static final String ERROR_MESSAGE_FILE_NOT_FOUND = "The properties files containing the messages for conversion and syntactic validation cannot be found in the knowledge base.";
    public static final String ERROR_MESSAGE_FILE_NO_RESOURCE_BUNDLE = "The parameter VALIDATION_MESSAGE_FILE_PREFIX in the INormDescriptor provided an instance of a type different of ResourceBundle.";
    public static final String MESSAGE_STARTING_ANOMALY_INHIBITING_VALIDATION = "Start of anomalies inhibiting.";
    public static final String ERROR_MESSAGE_XML_FORMAT_UNSUPPORTED = "This method does not handle XML format.";
    public static final String MESSAGE_FORMAT_TYPE_CANNOT_BE_NULL = "The parameter formatType cannot be null";
    public static final String PREFIX_LOGGER = "[Saturne] ";
    public static final Integer CONVERTER_FIELD_MIN_LENGTH = 1;
    public static final Integer CONVERTER_FIELD_MAX_LENGTH = 256;
    private AbstractKBDescriptor kbDescriptor;
    private ControlMessages controlMessages;
    private OptionMap options;

    public ValidationFunctionsHelper(AbstractKBDescriptor kbDescriptor, ControlMessages controlMessages, OptionMap options) {
        this.kbDescriptor = kbDescriptor;
        this.controlMessages = controlMessages;
        this.options = options;
    }

    public ISequenceProvider getReader(InputStream inputStream, FormatType messageFormat) throws SaturneValidatorException {
        ISequenceProvider reader = null;
        StandardAccessor standardAccessor = this.kbDescriptor.getStandardAccessor();
        StandardDescription standardDescription = standardAccessor.getStandardDescription();
        if (FormatType.CSV.equals((Object)messageFormat) || FormatType.CSVNP.equals((Object)messageFormat)) {
            reader = new CSVSequenceReader(standardDescription, this.options, this.controlMessages, standardAccessor, inputStream);
        } else if (FormatType.PFX.equals((Object)messageFormat)) {
            FormatSpecification positionalModel = this.getPositionalModelFromOption();
            reader = new PositionalFixSequenceReader(positionalModel, this.options, this.controlMessages, standardAccessor, inputStream, Charset.forName(standardDescription.getMessagesEncoding()));
        } else if (FormatType.JSON.equals((Object)messageFormat)) {
            reader = new JsonSequenceReader(this.options, this.controlMessages, standardAccessor, inputStream, Charset.forName(standardDescription.getMessagesEncoding()));
        } else {
            if (FormatType.XML.equals((Object)messageFormat) || FormatType.XMLNP.equals((Object)messageFormat)) {
                throw new UnsupportedOperationException(ERROR_MESSAGE_XML_FORMAT_UNSUPPORTED);
            }
            reader = new SequentialReader(standardDescription, this.options, this.controlMessages, standardAccessor, inputStream, Charset.forName(standardDescription.getMessagesEncoding()));
        }
        return reader;
    }

    public FormatSpecification getPositionalModelFromOption() throws SaturneValidatorException {
        StandardAccessor standardAccessor = this.kbDescriptor.getStandardAccessor();
        String modelConfPfxPath = (String)this.options.getOption(new Key("fr.cnav.saturne.validator.positional.modelConfPfx"));
        ResourceSet resourceSet = standardAccessor.getStandard().eResource().getResourceSet();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("positional", new PositionalResourceFactoryImpl());
        resourceSet.getPackageRegistry().put((Object)"http://www.cnav.fr/saturne/positional/1.0", (Object)PositionalPackage.eINSTANCE);
        return new ModelPositionalLoader(resourceSet, this.kbDescriptor.getResourceURL(modelConfPfxPath)).getPositional();
    }
}

