/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.runtime;

import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.gen.DSLGeneratorContext;
import fr.cnav.saturne.dsl.parser.IParserConfiguration;
import fr.cnav.saturne.dsl.types.Type;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapter;
import fr.cnav.saturne.dsl.types.adapter.DSLTypeAdapterFactory;
import fr.cnav.saturne.dsl.types.adapter.ITypingEnvironment;
import org.eclipse.emf.ecore.EObject;

public class TypeHelper {
    private IParserConfiguration configuration;

    public TypeHelper() {
        this.configuration = DSLGeneratorContext.getInstance().getConfiguration();
    }

    public TypeHelper(IParserConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean isNodeType(Expression expr) {
        if (Type.NODE.equals((Object)this.getType(expr)) || Type.NODE_LIST.equals((Object)this.getType(expr))) {
            return true;
        }
        return false;
    }

    public String getStringType(Expression expr) {
        return this.getType(expr).name();
    }

    public Type getType(Expression expr) {
        ITypingEnvironment env = new ITypingEnvironment(){

            public String getSignature(String functionName, int argCount) {
                String key = String.valueOf(functionName) + "/" + argCount + ".prototype";
                return TypeHelper.this.configuration.getDefinition(key);
            }

            public Type getNodeType(String nodeName) {
                return TypeHelper.this.configuration.getType(nodeName);
            }
        };
        DSLTypeAdapter adapter = DSLTypeAdapterFactory.adapt((EObject)expr);
        adapter.setTypingEnvironment(env);
        return adapter.getType();
    }
}

