/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.autocontrole.ui.views;

import fr.cnav.autocontrole.ui.AutocontrolUiPlugin;
import fr.cnav.autocontrole.ui.Messages;
import fr.cnav.autocontrole.ui.helpers.UIConstant;
import fr.cnav.autocontrole.ui.proxy.ProxyPreferenceDialog;
import fr.cnav.saturne.validator.report.IReportConstants;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;

public class ParameterWizardPage
extends WizardPage {
    private Spinner spinnerMaxAnomalies;
    private Spinner factorizationThreshold;
    Button activateUpdateOnStartUp;

    public ParameterWizardPage() {
        super(Messages.ParametreWizardPage_0);
        this.setTitle(Messages.ParametreWizardPage_1);
        this.setDescription(Messages.ParametreWizardPage_2);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblMaxAnomalies = new Label(composite, 0);
        lblMaxAnomalies.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblMaxAnomalies.setText(Messages.ParametreWizardPage_3);
        this.spinnerMaxAnomalies = new Spinner(composite, 2048);
        this.spinnerMaxAnomalies.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.spinnerMaxAnomalies.setMaximum(4000);
        this.spinnerMaxAnomalies.setMinimum(IReportConstants.UNLIMITED_ERRORS.intValue());
        int nbrMaxAnomalie = 200;
        if (AutocontrolUiPlugin.getDefault().getPreferenceStore().contains("PREF_MAX_ANOMALIE")) {
            nbrMaxAnomalie = AutocontrolUiPlugin.getDefault().getPreferenceStore().getInt("PREF_MAX_ANOMALIE");
        }
        this.spinnerMaxAnomalies.setSelection(nbrMaxAnomalie);
        this.spinnerMaxAnomalies.setSize(50, 20);
        Label lblGrouping = new Label(composite, 0);
        lblGrouping.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblGrouping.setText(Messages.ParametreWizardPage_4);
        this.factorizationThreshold = new Spinner(composite, 2048);
        this.factorizationThreshold.setMaximum(200);
        this.factorizationThreshold.setMinimum(-1);
        Integer factorizationThresholdValue = UIConstant.DEFAULT_ANOMALIE_FACTORIZATION_THRESHOLD;
        if (AutocontrolUiPlugin.getDefault().getPreferenceStore().contains("ANOMALIE_GROUPING_IS_ACTIVATED")) {
            factorizationThresholdValue = AutocontrolUiPlugin.getDefault().getPreferenceStore().getInt("ANOMALIE_GROUPING_IS_ACTIVATED");
        }
        this.factorizationThreshold.setSelection(factorizationThresholdValue.intValue());
        this.factorizationThreshold.setSize(80, 20);
        Label lblActivateUpdateOnStartUp = new Label(composite, 0);
        lblActivateUpdateOnStartUp.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblActivateUpdateOnStartUp.setText("Activation de la mise \u00e0 jour au d\u00e9marrage : ");
        Boolean activateUpdateOnStartUpValue = UIConstant.DEFAULT_ACTIVE_UPDATE_ON_STARTUP;
        if (AutocontrolUiPlugin.getDefault().getPreferenceStore().contains("ACTIVE_UPDATE_ON_STARTUP")) {
            activateUpdateOnStartUpValue = AutocontrolUiPlugin.getDefault().getPreferenceStore().getBoolean("ACTIVE_UPDATE_ON_STARTUP");
        }
        this.activateUpdateOnStartUp = new Button(composite, 32);
        this.activateUpdateOnStartUp.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.activateUpdateOnStartUp.setSelection(activateUpdateOnStartUpValue.booleanValue());
        Label lblAccessToProxysetting = new Label(composite, 0);
        lblAccessToProxysetting.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblAccessToProxysetting.setText("Configuration du proxy : ");
        Button buttonProxySetting = new Button(composite, 0);
        buttonProxySetting.setText("...");
        buttonProxySetting.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        buttonProxySetting.setSize(50, 20);
        final Shell shell = composite.getShell();
        buttonProxySetting.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        ProxyPreferenceDialog p = new ProxyPreferenceDialog(shell);
                        p.open();
                        break;
                    }
                }
            }
        });
    }

    public int getMaxAnomalies() {
        if (this.spinnerMaxAnomalies != null) {
            return this.spinnerMaxAnomalies.getSelection();
        }
        return 200;
    }

    public int getAnomalyFactorizationThreshold() {
        if (this.factorizationThreshold != null) {
            return this.factorizationThreshold.getSelection();
        }
        return UIConstant.DEFAULT_ANOMALIE_FACTORIZATION_THRESHOLD;
    }

    public Boolean getActivatorUpdateOnStartupStatus() {
        if (this.activateUpdateOnStartUp != null) {
            return this.activateUpdateOnStartUp.getSelection();
        }
        return UIConstant.DEFAULT_ACTIVE_UPDATE_ON_STARTUP;
    }
}

