/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;

public final class SaturneResourceUtil {
    public String createAuxiliaryResourceFile(String fullModelPath, String suffix) {
        int lastIndexOfDot = fullModelPath.lastIndexOf(46);
        boolean dot = true;
        if (lastIndexOfDot < 0) {
            dot = false;
            lastIndexOfDot = fullModelPath.length();
        }
        StringBuilder result = new StringBuilder();
        result.append(fullModelPath.substring(0, lastIndexOfDot));
        result.append(suffix);
        if (dot) {
            result.append('.').append(fullModelPath.substring(lastIndexOfDot + 1));
        }
        return result.toString();
    }

    public static void serializeSaturneFiles(URI resourceURI, boolean isSerializedToBinary, boolean saveReferencedResources) {
        ResourceSetImpl rs = new ResourceSetImpl();
        XMLResource rootResource = (XMLResource)rs.getResource(resourceURI, true);
        if (saveReferencedResources) {
            EcoreUtil.resolveAll((Resource)rootResource);
            for (Resource resource : rootResource.getResourceSet().getResources()) {
                SaturneResourceUtil.save(resource, isSerializedToBinary);
            }
        } else {
            SaturneResourceUtil.save((Resource)rootResource, isSerializedToBinary);
        }
    }

    protected static void save(Resource resource, boolean isSerializedToBinary) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("BINARY", isSerializedToBinary);
        options.put("ENCODING", "UTF-8");
        try {
            resource.save(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

