/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.utils;

import fr.cnav.saturne.MessageElement;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class BlockDeepestAncetorExtractor {
    private MessageElement deepestAncestorBlock;
    private List<MessageElement> blocksListSrcAncestors;
    private List<MessageElement> blocksListTgtAncestors;
    private List<MessageElement> blocksListFromSrcToDeepestAncestor = new ArrayList<MessageElement>();
    private List<MessageElement> blocksListFromTgtToDeepestAncestor = new ArrayList<MessageElement>();
    private int srcSize;
    private int tgtSize;

    public BlockDeepestAncetorExtractor(MessageElement sourceBlock, MessageElement targetBlock) {
        if (sourceBlock != null) {
            this.blocksListSrcAncestors = this.getAncestors(sourceBlock);
            this.srcSize = this.blocksListSrcAncestors.size();
        }
        if (targetBlock != null) {
            this.blocksListTgtAncestors = this.getAncestors(targetBlock);
            this.tgtSize = this.blocksListTgtAncestors.size();
        }
        if (sourceBlock == null && targetBlock == null) {
            return;
        }
        if (sourceBlock != null && targetBlock != null) {
            this.computeDeepestAncestors(this.srcSize, this.tgtSize);
        } else if (sourceBlock != null) {
            this.blocksListFromSrcToDeepestAncestor.addAll(this.blocksListSrcAncestors);
        } else if (targetBlock != null) {
            this.blocksListFromTgtToDeepestAncestor.addAll(this.blocksListTgtAncestors);
        }
    }

    public MessageElement getDeepestAncestorBlock() {
        return this.deepestAncestorBlock;
    }

    public List<MessageElement> getBlocksListFromSrcToDeepestAncestor() {
        return this.blocksListFromSrcToDeepestAncestor;
    }

    public List<MessageElement> getBlocksListFromDeepestAncestorToSrc() {
        return this.reverseList(this.blocksListFromSrcToDeepestAncestor);
    }

    public List<MessageElement> getBlocksListFromTgtToDeepestAncestor() {
        return this.blocksListFromTgtToDeepestAncestor;
    }

    public List<MessageElement> getBlocksListFromDeepestAncestorToTgt() {
        return this.reverseList(this.blocksListFromTgtToDeepestAncestor);
    }

    private void computeDeepestAncestors(int srcDeep, int tgtDeep) {
        MessageElement currentSrcBlock = this.blocksListSrcAncestors.get(this.srcSize - srcDeep);
        MessageElement currentTgtBlock = this.blocksListTgtAncestors.get(this.tgtSize - tgtDeep);
        if (srcDeep == tgtDeep) {
            this.blocksListFromSrcToDeepestAncestor.add(currentSrcBlock);
            this.blocksListFromTgtToDeepestAncestor.add(currentTgtBlock);
            if (currentSrcBlock == currentTgtBlock) {
                this.deepestAncestorBlock = currentSrcBlock;
                return;
            }
            if (srcDeep > 1) {
                this.computeDeepestAncestors(srcDeep - 1, tgtDeep - 1);
            }
        } else if (srcDeep > tgtDeep) {
            this.blocksListFromSrcToDeepestAncestor.add(currentSrcBlock);
            this.computeDeepestAncestors(srcDeep - 1, tgtDeep);
        } else {
            this.blocksListFromTgtToDeepestAncestor.add(currentTgtBlock);
            this.computeDeepestAncestors(srcDeep, tgtDeep - 1);
        }
    }

    private List<MessageElement> getAncestors(MessageElement blockOrMessage) {
        ArrayList<MessageElement> result = new ArrayList<MessageElement>();
        result.add(blockOrMessage);
        if (blockOrMessage != null && blockOrMessage.eContainer() instanceof MessageElement) {
            result.addAll(this.getAncestors((MessageElement)blockOrMessage.eContainer()));
        }
        return result;
    }

    private List<MessageElement> reverseList(List<MessageElement> list) {
        return IntStream.rangeClosed(1, list.size()).mapToObj(i -> (MessageElement)list.get(list.size() - i)).collect(Collectors.toList());
    }
}

