/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.vn;

import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.optimization.Transformation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class VariableUnifier
extends FormulesSwitch<EObject>
implements Transformation {
    private Map<String, Integer> variableOccurences = new HashMap<String, Integer>();

    private void addOccurence(String variable) {
        if (this.variableOccurences.containsKey(variable)) {
            int occurence = this.variableOccurences.get(variable);
            this.variableOccurences.put(variable, occurence + 1);
        } else {
            this.variableOccurences.put(variable, 0);
        }
    }

    private String newVarName(String varName) {
        if (this.variableOccurences.containsKey(varName)) {
            return String.valueOf(varName) + "_" + this.variableOccurences.get(varName);
        }
        return varName;
    }

    @Override
    public Expression transform(Expression input) {
        this.doSwitch(input);
        return input;
    }

    @Override
    public EObject caseLet(Let object) {
        for (Binding binding : object.getBindings()) {
            String varName = binding.getVarName();
            this.addOccurence(varName);
            binding.setVarName(this.newVarName(varName));
            this.doSwitch(binding.getExpr());
        }
        this.doSwitch(object.getIn());
        return object;
    }

    @Override
    public EObject caseQuantified(Quantified object) {
        for (IteratorVariable var : object.getVariables()) {
            String varName = var.getVarName();
            this.addOccurence(varName);
            var.setVarName(this.newVarName(varName));
            this.doSwitch(var.getElement());
        }
        this.doSwitch(object.getExpression());
        return object;
    }

    @Override
    public EObject caseVarRef(VarRef object) {
        String variable = object.getVarName();
        object.setVarName(this.newVarName(variable));
        return object;
    }

    @Override
    public EObject caseFieldRef(FieldRef object) {
        String varName = object.getContextVariable();
        object.setContextVariable(this.newVarName(varName));
        return object;
    }

    @Override
    public EObject defaultCase(EObject object) {
        for (EObject eObject : object.eContents()) {
            this.doSwitch(eObject);
        }
        return object;
    }
}

