/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn.content;

import fr.cnav.saturne.BindingSet;
import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.BoundRefinement;
import fr.cnav.saturne.DataType;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.EnumDataType;
import fr.cnav.saturne.ExternalDataTable;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.GenericRule;
import fr.cnav.saturne.HeaderBlock;
import fr.cnav.saturne.Message;
import fr.cnav.saturne.NatureType;
import fr.cnav.saturne.Refinement;
import fr.cnav.saturne.ReusedBlock;
import fr.cnav.saturne.ReusedBlockSet;
import fr.cnav.saturne.RuleSet;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.Value;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.ogn.ModelChangeListener;
import fr.cnav.saturne.editor.ogn.content.ContentTypeFactory;
import fr.cnav.saturne.editor.ogn.content.MessageTreeEditorException;
import fr.cnav.saturne.impl.FieldToValueMapImpl;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.jface.viewers.Viewer;

public class MessageTreeEditorContentProvider
extends AdapterFactoryContentProvider
implements ModelChangeListener {
    private SaturneItemProviderAdapterFactory saturneFactory;
    private Map<EObject, Adapter> adapteursMap;
    private ContentTypeFactory contentTypeFactory;

    public MessageTreeEditorContentProvider(AdapterFactory adapterFactory, SaturneItemProviderAdapterFactory theSaturneFactory) throws MessageTreeEditorException {
        super(adapterFactory);
        this.saturneFactory = theSaturneFactory;
        this.adapteursMap = new HashMap<EObject, Adapter>();
        this.contentTypeFactory = new ContentTypeFactory(this.adapteursMap, theSaturneFactory);
    }

    public void dispose() {
        super.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        List<Object> result = null;
        if (parentElement instanceof Resource) {
            result = new ArrayList();
            Resource res = (Resource)parentElement;
            if (!res.getContents().isEmpty() && res.getContents().get(0) instanceof Standard) {
                MessageTreeObject root = new MessageTreeObject(res.getContents().get(0), null, null);
                result.add(root);
            }
        } else if (parentElement instanceof MessageTreeObject) {
            MessageTreeObject messageTreeObject = (MessageTreeObject)parentElement;
            Object msgElement = messageTreeObject.getElement();
            if (msgElement instanceof Standard) {
                Standard standard = (Standard)msgElement;
                result = this.contentTypeFactory.getStandardHelper().getChildrenElt(standard, messageTreeObject, true);
            } else if (msgElement instanceof HeaderBlock) {
                HeaderBlock headerBlock = (HeaderBlock)msgElement;
                result = this.contentTypeFactory.getHeaderBlockHelper().getChildrenElt(headerBlock, messageTreeObject, true);
            } else if (msgElement instanceof DeclarationBlock) {
                DeclarationBlock declarationBlock = (DeclarationBlock)msgElement;
                result = this.contentTypeFactory.getDeclarationBlockHelper().getChildrenElt(declarationBlock, messageTreeObject, true);
            } else if (msgElement instanceof Block) {
                Block block = (Block)msgElement;
                result = this.contentTypeFactory.getBlockHelper().getChildrenElt(block, messageTreeObject, true);
            } else if (msgElement instanceof Field) {
                Field field = (Field)msgElement;
                result = this.contentTypeFactory.getFieldHelper().getChildrenElt(field, messageTreeObject, true);
            } else if (msgElement instanceof DataType) {
                DataType dataType = (DataType)msgElement;
                result = this.contentTypeFactory.getDataTypeHelper().getChildrenElt(dataType, messageTreeObject, true);
            } else if (msgElement instanceof Value) {
                Value value = (Value)msgElement;
                result = this.contentTypeFactory.getValueHelper().getChildrenElt(value, messageTreeObject, true);
            } else if (msgElement instanceof ReusedBlockSet) {
                ReusedBlockSet reusedBlockSet = (ReusedBlockSet)msgElement;
                result = this.contentTypeFactory.getReusedBlockSetHelper().getChildrenElt(reusedBlockSet, messageTreeObject, true);
            } else if (msgElement instanceof ReusedBlock) {
                ReusedBlock reusedBlock = (ReusedBlock)msgElement;
                result = this.contentTypeFactory.getReusedBlockHelper().getChildrenElt(reusedBlock, messageTreeObject, true);
            } else if (msgElement instanceof BindingSet) {
                BindingSet value = (BindingSet)msgElement;
                result = this.contentTypeFactory.getBindingSetHelper().getChildrenElt(value, messageTreeObject, true);
            } else {
                result = new ArrayList(0);
            }
        } else {
            result = new ArrayList(0);
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        MessageTreeObject returnValue = null;
        if (element instanceof MessageTreeObject) {
            MessageTreeObject messageTreeObject = (MessageTreeObject)element;
            Object msgElement = messageTreeObject.getElement();
            if (msgElement instanceof HeaderBlock) {
                HeaderBlock headerBlock = (HeaderBlock)msgElement;
                returnValue = this.contentTypeFactory.getHeaderBlockHelper().getParent(headerBlock, messageTreeObject);
            } else if (msgElement instanceof Field) {
                Field field = (Field)msgElement;
                returnValue = this.contentTypeFactory.getFieldHelper().getParent(field, messageTreeObject);
            } else if (msgElement instanceof DeclarationBlock) {
                DeclarationBlock declarationBlock = (DeclarationBlock)msgElement;
                returnValue = this.contentTypeFactory.getDeclarationBlockHelper().getParent(declarationBlock, messageTreeObject);
            } else if (msgElement instanceof Declaration) {
                returnValue = this.contentTypeFactory.getDeclarationHelper().getParent((Declaration)msgElement, messageTreeObject);
            } else if (msgElement instanceof Block) {
                Block block = (Block)msgElement;
                returnValue = this.contentTypeFactory.getBlockHelper().getParent(block, messageTreeObject);
            } else if (msgElement instanceof FieldRefinement) {
                FieldRefinement fieldRefinement = (FieldRefinement)msgElement;
                returnValue = this.contentTypeFactory.getFieldRefinementHelper().getParent(fieldRefinement, messageTreeObject);
            } else if (msgElement instanceof BlockRefinement) {
                BlockRefinement blockRefinement = (BlockRefinement)msgElement;
                returnValue = this.contentTypeFactory.getBlockRefinementHelper().getParent(blockRefinement, messageTreeObject);
            } else if (msgElement instanceof GenericRule) {
                GenericRule rule = (GenericRule)msgElement;
                returnValue = rule.getSubject();
                GenericRule genericRule = (GenericRule)msgElement;
                returnValue = this.contentTypeFactory.getGenericRuleHelper().getParent(genericRule, messageTreeObject);
            } else if (msgElement instanceof DataType) {
                DataType dataType = (DataType)msgElement;
                returnValue = this.contentTypeFactory.getDataTypeHelper().getParent(dataType, messageTreeObject);
            } else if (msgElement instanceof Value) {
                Value value = (Value)msgElement;
                returnValue = this.contentTypeFactory.getValueHelper().getParent(value, messageTreeObject);
            } else if (msgElement instanceof ExternalDataTable) {
                ExternalDataTable extDataTable = (ExternalDataTable)msgElement;
                returnValue = this.contentTypeFactory.getExternalDataTableHelper().getParent(extDataTable, messageTreeObject);
            } else if (msgElement instanceof ReusedBlockSet) {
                ReusedBlockSet reusedBlockSet = (ReusedBlockSet)msgElement;
                returnValue = this.contentTypeFactory.getReusedBlockSetHelper().getParent(reusedBlockSet, messageTreeObject);
            } else if (msgElement instanceof ReusedBlock) {
                ReusedBlock reusedBlock = (ReusedBlock)msgElement;
                returnValue = this.contentTypeFactory.getReusedBlockHelper().getParent(reusedBlock, messageTreeObject);
            } else if (msgElement instanceof BindingSet) {
                BindingSet bindings = (BindingSet)msgElement;
                returnValue = this.contentTypeFactory.getBindingSetHelper().getParent(bindings, messageTreeObject);
            } else if (msgElement instanceof EObject) {
                EObject eObject = (EObject)msgElement;
                returnValue = this.contentTypeFactory.getEObjectHelper().getParent(eObject, messageTreeObject);
            }
        }
        return returnValue;
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        if (element instanceof MessageTreeObject) {
            MessageTreeObject messageTreeObject = (MessageTreeObject)element;
            Object msgElement = messageTreeObject.getElement();
            if (msgElement instanceof Standard) {
                result = this.contentTypeFactory.getStandardHelper().hasChildren((Standard)msgElement, messageTreeObject);
            } else if (msgElement instanceof HeaderBlock) {
                result = this.contentTypeFactory.getHeaderBlockHelper().hasChildren((HeaderBlock)msgElement, messageTreeObject);
            } else if (msgElement instanceof DeclarationBlock) {
                result = this.contentTypeFactory.getDeclarationBlockHelper().hasChildren((DeclarationBlock)msgElement, messageTreeObject);
            } else if (msgElement instanceof Block) {
                result = this.contentTypeFactory.getBlockHelper().hasChildren((Block)msgElement, messageTreeObject);
            } else if (msgElement instanceof Field) {
                result = this.contentTypeFactory.getFieldHelper().hasChildren((Field)msgElement, messageTreeObject);
            } else if (msgElement instanceof DataType) {
                result = this.contentTypeFactory.getDataTypeHelper().hasChildren((DataType)msgElement, messageTreeObject);
            } else if (msgElement instanceof ReusedBlockSet) {
                result = this.contentTypeFactory.getReusedBlockSetHelper().hasChildren((ReusedBlockSet)msgElement, messageTreeObject);
            } else if (msgElement instanceof ReusedBlock) {
                result = this.contentTypeFactory.getReusedBlockHelper().hasChildren((ReusedBlock)msgElement, messageTreeObject);
            } else if (msgElement instanceof BindingSet) {
                result = this.contentTypeFactory.getBindingSetHelper().hasChildren((BindingSet)msgElement, messageTreeObject);
            }
        }
        return result;
    }

    private void registerAdapter(EObject obj, boolean registerAdapter) {
        if (obj == null || !registerAdapter) {
            return;
        }
        if (this.adapteursMap == null) {
            this.adapteursMap = new HashMap<EObject, Adapter>();
        }
        if (!this.adapteursMap.containsKey(obj)) {
            Adapter newAdapter = this.saturneFactory.createAdapter((Notifier)obj);
            obj.eAdapters().add((Object)newAdapter);
            this.adapteursMap.put(obj, newAdapter);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getEventType() == 9) {
            return;
        }
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            EObject notifier = (EObject)notification.getNotifier();
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            if (notifier instanceof RuleSet) {
                this.notifyChangedRuleSet(notification, feature);
            } else if (notifier instanceof Declaration) {
                this.notifyChangDeclaration(notification, feature);
            } else if (notifier instanceof Field) {
                this.notifyChangedField(notification, notifier, feature);
            }
            this.updateViewer(notification);
        }
    }

    private void notifyChangedField(Notification notification, EObject notifier, EStructuralFeature feature) {
        Field field;
        if (7 == feature.getFeatureID() && 1 == notification.getEventType() && (field = (Field)notifier).isDeclarationKey() && field.getDataType().getNature() == NatureType.ENUMERATION) {
            EnumDataType enumDataType = (EnumDataType)field.getDataType();
            for (Value value : enumDataType.getValues()) {
                this.registerAdapter((EObject)value, true);
            }
        }
    }

    private void notifyChangDeclaration(Notification notification, EStructuralFeature feature) {
        if (4 == feature.getFeatureID() && (3 == notification.getEventType() || 5 == notification.getEventType())) {
            Refinement refinement = (Refinement)notification.getNewValue();
            this.registerAdapter((EObject)refinement, true);
        }
    }

    private void notifyChangedRuleSet(Notification notification, EStructuralFeature feature) {
        if (feature.getFeatureID() == 0 && (3 == notification.getEventType() || 5 == notification.getEventType())) {
            GenericRule rule = (GenericRule)notification.getNewValue();
            this.registerAdapter((EObject)rule, true);
        }
    }

    private void updateViewer(Notification notification) {
        List<MessageTreeObject> objectsToRefresh = this.getObjectsToRefresh(notification);
        if (notification.getEventType() == 5 || notification.getEventType() == 6) {
            NotifyChangedToViewerRefresh.handleNotifyChanged((Viewer)this.viewer, objectsToRefresh, (int)notification.getEventType(), (Object)notification.getFeature(), (Object)notification.getOldValue(), objectsToRefresh, (int)notification.getPosition());
        } else {
            for (MessageTreeObject messageTreeObjectToRefresh : objectsToRefresh) {
                Object newValue = notification.getNewValue();
                if (notification.getOldValue() == null && !(notification.getNewValue() instanceof MessageTreeObject)) {
                    MessageTreeObject messageTreeObject = new MessageTreeObject(notification.getNewValue(), messageTreeObjectToRefresh.getDeclaration(), messageTreeObjectToRefresh.getElement());
                    newValue = messageTreeObject;
                    messageTreeObject.setParentMessageTreeObject(messageTreeObjectToRefresh);
                }
                NotifyChangedToViewerRefresh.handleNotifyChanged((Viewer)this.viewer, (Object)messageTreeObjectToRefresh, (int)notification.getEventType(), (Object)notification.getFeature(), (Object)notification.getOldValue(), (Object)newValue, (int)notification.getPosition());
            }
        }
        if (notification instanceof IViewerNotification) {
            IViewerNotification viewerNotif = (IViewerNotification)notification;
            if (this.viewerRefresh == null) {
                this.viewerRefresh = new AdapterFactoryContentProvider.ViewerRefresh(this.viewer);
            }
            boolean doAsyncRefresh = false;
            for (MessageTreeObject messageTreeObjectToRefresh : objectsToRefresh) {
                viewerNotif = new ViewerNotification(viewerNotif, (Object)messageTreeObjectToRefresh);
                if (!doAsyncRefresh) {
                    doAsyncRefresh = this.viewerRefresh.addNotification(viewerNotif);
                    continue;
                }
                this.viewerRefresh.addNotification(viewerNotif);
            }
            if (doAsyncRefresh) {
                this.viewer.getControl().getDisplay().asyncExec((Runnable)this.viewerRefresh);
            }
        }
    }

    private List<MessageTreeObject> getObjectsToRefresh(Notification notification) {
        EObject notifier = (EObject)notification.getNotifier();
        List<Object> resultList = new ArrayList();
        if (notifier instanceof Standard) {
            resultList = this.contentTypeFactory.getStandardHelper().getObjectsToRefresh((Standard)notifier, notification);
        } else if (notifier instanceof Message) {
            resultList = this.contentTypeFactory.getMessageHelper().getObjectsToRefresh((Message)notifier, notification);
        } else if (notifier instanceof DeclarationBlock) {
            resultList = this.contentTypeFactory.getDeclarationBlockHelper().getObjectsToRefresh((DeclarationBlock)notifier, notification);
        } else if (notifier instanceof Block) {
            resultList = this.contentTypeFactory.getBlockHelper().getObjectsToRefresh((Block)notifier, notification);
        } else if (notifier instanceof Declaration) {
            resultList = this.contentTypeFactory.getDeclarationHelper().getObjectsToRefresh((Declaration)notifier, notification);
        } else if (notifier instanceof Field) {
            resultList = this.contentTypeFactory.getFieldHelper().getObjectsToRefresh((Field)notifier, notification);
        } else if (notifier instanceof BoundRefinement) {
            resultList = this.contentTypeFactory.getBoundRefinementHelper().getObjectsToRefresh((BoundRefinement)notifier, notification);
        } else if (notifier instanceof FieldRefinement) {
            resultList = this.contentTypeFactory.getFieldRefinementHelper().getObjectsToRefresh((FieldRefinement)notifier, notification);
        } else if (notifier instanceof BlockRefinement) {
            resultList = this.contentTypeFactory.getBlockRefinementHelper().getObjectsToRefresh((BlockRefinement)notifier, notification);
        } else if (notifier instanceof GenericRule) {
            resultList = this.contentTypeFactory.getGenericRuleHelper().getObjectsToRefresh((GenericRule)notifier, notification);
        } else if (notifier instanceof RuleSet) {
            resultList = this.contentTypeFactory.getRuleSetHelper().getObjectsToRefresh((RuleSet)notifier, notification);
        } else if (notifier instanceof DataType) {
            resultList = this.contentTypeFactory.getDataTypeHelper().getObjectsToRefresh((DataType)notifier, notification);
        } else if (notifier instanceof Value) {
            resultList = this.contentTypeFactory.getValueHelper().getObjectsToRefresh((Value)notifier, notification);
        } else if (notifier instanceof ExternalDataTable) {
            resultList = this.contentTypeFactory.getExternalDataTableHelper().getObjectsToRefresh((ExternalDataTable)notifier, notification);
        } else if (notifier instanceof FieldToValueMapImpl) {
            resultList = this.contentTypeFactory.getFieldToValueMapHelper().getObjectsToRefresh((FieldToValueMapImpl)notifier, notification);
        } else if (notifier instanceof ReusedBlockSet) {
            resultList = this.contentTypeFactory.getReusedBlockSetHelper().getObjectsToRefresh((ReusedBlockSet)notifier, notification);
        } else if (notifier instanceof ReusedBlock) {
            resultList = this.contentTypeFactory.getReusedBlockHelper().getObjectsToRefresh((ReusedBlock)notifier, notification);
        } else if (notifier instanceof BindingSet) {
            resultList = this.contentTypeFactory.getBindingSetHelper().getObjectsToRefresh((BindingSet)notifier, notification);
        }
        return resultList;
    }

    @Override
    public void hasChanged() {
    }

    public MessageTreeObject getObjectToSelect(Object object) {
        MessageTreeObject result = null;
        if (object instanceof Standard) {
            result = this.contentTypeFactory.getStandardHelper().getObjectToSelect((Standard)object);
        } else if (object instanceof HeaderBlock) {
            result = this.contentTypeFactory.getHeaderBlockHelper().getObjectToSelect((HeaderBlock)object);
        } else if (object instanceof DeclarationBlock) {
            result = this.contentTypeFactory.getDeclarationBlockHelper().getObjectToSelect((DeclarationBlock)object);
        } else if (object instanceof Declaration) {
            result = this.contentTypeFactory.getDeclarationHelper().getObjectToSelect((Declaration)object);
        } else if (object instanceof Block) {
            result = this.contentTypeFactory.getBlockHelper().getObjectToSelect((Block)object);
        } else if (object instanceof Field) {
            result = this.contentTypeFactory.getFieldHelper().getObjectToSelect((Field)object);
        } else if (object instanceof BlockRefinement) {
            result = this.contentTypeFactory.getBlockRefinementHelper().getObjectToSelect((BlockRefinement)object);
        } else if (object instanceof FieldRefinement) {
            result = this.contentTypeFactory.getFieldRefinementHelper().getObjectToSelect((FieldRefinement)object);
        } else if (object instanceof GenericRule) {
            result = this.contentTypeFactory.getGenericRuleHelper().getObjectToSelect((GenericRule)object);
        } else if (object instanceof DataType) {
            result = this.contentTypeFactory.getDataTypeHelper().getObjectToSelect((DataType)object);
        } else if (object instanceof Value) {
            result = this.contentTypeFactory.getValueHelper().getObjectToSelect((Value)object);
        } else if (object instanceof ExternalDataTable) {
            result = this.contentTypeFactory.getExternalDataTableHelper().getObjectToSelect((ExternalDataTable)object);
        } else if (object instanceof ReusedBlockSet) {
            result = this.contentTypeFactory.getReusedBlockSetHelper().getObjectToSelect((ReusedBlockSet)object);
        } else if (object instanceof ReusedBlock) {
            result = this.contentTypeFactory.getReusedBlockHelper().getObjectToSelect((ReusedBlock)object);
        } else if (object instanceof BindingSet) {
            result = this.contentTypeFactory.getBindingSetHelper().getObjectToSelect((BindingSet)object);
        }
        return result;
    }
}

