/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor.ogn;

import fr.cnav.saturne.Standard;
import fr.cnav.saturne.editor.MessageTreeKeyDecorator;
import fr.cnav.saturne.editor.MessageTreeLabelProvider;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.editor.MessageTreeRefinementDecorator;
import fr.cnav.saturne.editor.ogn.MessageTreeDiagnosticDecorator;
import fr.cnav.saturne.editor.ogn.OGNMessageTreeObjectComparer;
import fr.cnav.saturne.editor.ogn.SaturneEditingDomainActionBarContributor;
import fr.cnav.saturne.editor.ogn.content.MessageTreeEditorContentProvider;
import fr.cnav.saturne.editor.ogn.content.MessageTreeEditorException;
import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import fr.cnav.saturne.provider.SaturneItemProviderAdapterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class MessageTreeEditor
extends EditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    public static final String ID = "fr.cnav.saturne.presentation.SaturneEditorIDLegit";
    private Composite parent;
    protected TransactionalEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected TreeViewer treeViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p == MessageTreeEditor.this) {
                MessageTreeEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    private boolean dirty = false;
    private EContentAdapter standardDirtyAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (!MessageTreeEditor.this.dirty) {
                if (notification.getEventType() == 1) {
                    if (notification.getOldValue() == null && notification.getNewValue() != null || !notification.getOldValue().equals(notification.getNewValue())) {
                        MessageTreeEditor.this.dirty = true;
                    }
                } else if (notification.getEventType() == 3 || notification.getEventType() == 4 || notification.getEventType() == 7) {
                    MessageTreeEditor.this.dirty = true;
                }
            }
            super.notifyChanged(notification);
        }
    };
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){
        protected boolean dispatching;

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = MessageTreeEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            MessageTreeEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            MessageTreeEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        this.dispatchUpdateProblemIndication();
                        break;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void dispatchUpdateProblemIndication() {
            if (MessageTreeEditor.this.updateProblemIndication && !this.dispatching) {
                this.dispatching = true;
                MessageTreeEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dispatching = false;
                        MessageTreeEditor.this.updateProblemIndication();
                    }
                });
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            MessageTreeEditor.this.resourceToDiagnosticMap.remove(target);
            this.dispatchUpdateProblemIndication();
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).MessageTreeEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else {
                                    if ((delta.getFlags() & 0x20000) != 0) {
                                        DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resource, (Diagnostic)(this).MessageTreeEditor.this.markerHelper.getMarkerDiagnostics((Object)resource, (IFile)delta.getResource(), false));
                                    }
                                    if ((delta.getFlags() & 0x100) != 0 && !(this).MessageTreeEditor.this.savedResources.remove(resource)) {
                                        this.changedResources.add(resource);
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    MessageTreeEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).MessageTreeEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!MessageTreeEditor.this.isDirty()) {
                                MessageTreeEditor.this.getSite().getPage().closeEditor((IEditorPart)MessageTreeEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    MessageTreeEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).MessageTreeEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (MessageTreeEditor.this.getSite().getPage().getActiveEditor() == MessageTreeEditor.this) {
                                MessageTreeEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                SaturneEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    private SaturneItemProviderAdapterFactory saturneFactory;
    private MessageTreeEditorContentProvider provider;

    protected void handleActivate() {
        if (((TransactionalEditingDomainImpl)this.editingDomain).getResourceToReadOnlyMap() != null) {
            ((TransactionalEditingDomainImpl)this.editingDomain).getResourceToReadOnlyMap().clear();
            this.setSelection(this.editorSelection);
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)this.editingDomain.getResourceSet().getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                    this.treeViewer.setInput((Object)this.getStandard().eResource());
                    this.treeViewer.refresh();
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "test.eef.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                try {
                    this.markerHelper.updateMarkers((Diagnostic)diagnostic);
                }
                catch (CoreException exception) {
                    SaturneEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MessageTreeEditor.getString("_UI_FileConflict_label"), (String)MessageTreeEditor.getString("_WARN_FileConflict"));
    }

    public MessageTreeEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.saturneFactory = new SaturneItemProviderAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)this.saturneFactory);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        this.editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        CommandStack commandStack = this.editingDomain.getCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                MessageTreeEditor.this.getParent().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageTreeEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            MessageTreeEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }
                });
            }
        });
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(List<EObject> listEObject) {
        ArrayList<MessageTreeObject> listMsgObj = new ArrayList<MessageTreeObject>();
        for (EObject object : listEObject) {
            listMsgObj.add(this.provider.getObjectToSelect(object));
        }
        this.setSelectionToViewer((Collection<?>)listMsgObj);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MessageTreeEditor.this.treeViewer != null) {
                        MessageTreeEditor.this.treeViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public TreeViewer getTreeView() {
        return this.treeViewer;
    }

    public Viewer getViewer() {
        return this.treeViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    public void createModel() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput(), (URIConverter)this.editingDomain.getResourceSet().getURIConverter());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        this.getStandard().eAdapters().add((Object)this.standardDirtyAdapter);
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "test.eef.editor", 0, MessageTreeEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "test.eef.editor", 0, MessageTreeEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IGotoMarker.class)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                for (Resource resource : MessageTreeEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!first && resource.getContents().isEmpty() && !MessageTreeEditor.this.isPersisted(resource) || MessageTreeEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        long timeStamp = resource.getTimeStamp();
                        resource.save(saveOptions);
                        if (resource.getTimeStamp() != timeStamp) {
                            MessageTreeEditor.this.savedResources.add(resource);
                        }
                    }
                    catch (Exception exception) {
                        MessageTreeEditor.this.resourceToDiagnosticMap.put(resource, MessageTreeEditor.this.analyzeResourceProblems(resource, exception));
                        SaturneEditorPlugin.INSTANCE.log(exception);
                    }
                    first = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.dirty = false;
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            SaturneEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            ArrayList<MessageTreeObject> elementToSelect = new ArrayList<MessageTreeObject>();
            for (Object object : targetObjects) {
                MessageTreeObject messageTreeObject = this.provider.getObjectToSelect(object);
                if (messageTreeObject == null) continue;
                elementToSelect.add(messageTreeObject);
            }
            this.setSelectionToViewer((Collection<?>)elementToSelect);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getParent().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(MessageTreeEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(MessageTreeEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(MessageTreeEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return SaturneEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return SaturneEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public SaturneEditingDomainActionBarContributor getActionBarContributor() {
        return (SaturneEditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void dispose() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        super.dispose();
    }

    public Standard getStandard() {
        return (Standard)((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().get(0);
    }

    public void createPartControl(Composite parent) {
        this.setParent(parent);
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            this.treeViewer = new TreeViewer(this.getParent());
            try {
                this.provider = new MessageTreeEditorContentProvider((AdapterFactory)this.adapterFactory, this.saturneFactory){

                    @Override
                    public void hasChanged() {
                        MessageTreeEditor.this.firePropertyChange(257);
                    }
                };
            }
            catch (MessageTreeEditorException e) {
                e.printStackTrace();
            }
            this.treeViewer.setContentProvider((IContentProvider)this.provider);
            DecoratingColumLabelProvider decoratingColumLabelProvider1 = new DecoratingColumLabelProvider((ILabelProvider)new MessageTreeLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)new MessageTreeKeyDecorator());
            DecoratingColumLabelProvider decoratingColumLabelProvider2 = new DecoratingColumLabelProvider((ILabelProvider)decoratingColumLabelProvider1, (ILabelDecorator)new MessageTreeRefinementDecorator());
            DecoratingColumLabelProvider decoratingColumLabelProvider3 = new DecoratingColumLabelProvider((ILabelProvider)decoratingColumLabelProvider2, (ILabelDecorator)new MessageTreeDiagnosticDecorator(this.editingDomain.getResourceSet(), (StructuredViewer)this.treeViewer));
            this.treeViewer.setLabelProvider((IBaseLabelProvider)decoratingColumLabelProvider3);
            this.treeViewer.setComparer((IElementComparer)new OGNMessageTreeObjectComparer());
            this.treeViewer.setInput((Object)this.getStandard().eResource());
            new AdapterFactoryTreeEditor(this.treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.treeViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.treeViewer));
            this.createContextMenuFor((StructuredViewer)this.treeViewer);
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    MessageTreeEditor.this.setSelection(selectionChangedEvent.getSelection());
                }
            };
            this.setSelection(this.treeViewer.getSelection());
            IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
            contextService.activateContext(ID);
        }
        this.treeViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageTreeEditor.this.updateProblemIndication();
            }
        });
    }

    public Composite getParent() {
        return this.parent;
    }

    public void setParent(Composite parent) {
        this.parent = parent;
    }

    public void setFocusOnAndExpand(Object obj) {
        this.expandTo(obj);
        StructuredSelection selection = new StructuredSelection(obj);
        this.treeViewer.setSelection((ISelection)selection);
    }

    public void expandTo(Object obj) {
        this.treeViewer.expandToLevel(obj, -1);
    }
}

