/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.editor;

import fr.cnav.saturne.Block;
import fr.cnav.saturne.BlockRefinement;
import fr.cnav.saturne.Declaration;
import fr.cnav.saturne.DeclarationBlock;
import fr.cnav.saturne.Field;
import fr.cnav.saturne.FieldRefinement;
import fr.cnav.saturne.editor.MessageTreeObject;
import fr.cnav.saturne.presentation.SaturneEditorPlugin;
import fr.cnav.saturne.utils.RefinementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.swt.graphics.Image;

public class MessageTreeRefinementDecorator
extends BaseLabelProvider
implements ILabelDecorator {
    public Image decorateImage(Image image, Object element) {
        Image result = image;
        if (element instanceof MessageTreeObject) {
            MessageTreeObject messageTreeObject = (MessageTreeObject)element;
            Declaration declaration = messageTreeObject.getDeclaration();
            if (messageTreeObject.getDeclaration() != null && this.isMsgTreeObjectShouldBeDecorated(messageTreeObject, declaration)) {
                result = this.getDecorateImage(image);
            }
        }
        return result;
    }

    private Image getDecorateImage(Image image) {
        if (image == null) {
            return ExtendedImageRegistry.INSTANCE.getImage(SaturneEditorPlugin.INSTANCE.getImage("full/ovr16/rafinementOverLay.gif"));
        }
        ArrayList<Object> images = new ArrayList<Object>(2);
        images.add(image);
        images.add(SaturneEditorPlugin.INSTANCE.getImage("full/ovr16/rafinementOverLay.gif"));
        DecoratedComposedImage composedImage = new DecoratedComposedImage(images);
        return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
    }

    private boolean isMsgTreeObjectShouldBeDecorated(MessageTreeObject messageTreeObject, Declaration declaration) {
        BlockRefinement blockRefinement;
        Block block;
        boolean result = false;
        RefinementUtil refinementUtil = new RefinementUtil();
        if (messageTreeObject.getAdapter(Field.class) != null) {
            FieldRefinement fieldRefinement;
            Field field = (Field)messageTreeObject.getAdapter(Field.class);
            if (refinementUtil.isRaffined(field, fieldRefinement = (FieldRefinement)declaration.getFieldRefinements().get(field))) {
                result = true;
            }
        } else if (messageTreeObject.getAdapter(Block.class) != null && messageTreeObject.getAdapter(DeclarationBlock.class) == null && refinementUtil.isRaffined(block = (Block)messageTreeObject.getAdapter(Block.class), blockRefinement = (BlockRefinement)declaration.getBlockRefinements().get(block))) {
            result = true;
        }
        return result;
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    private static final class DecoratedComposedImage
    extends ComposedImage {
        private static final int OVERLAY_X = 0;
        private static final int OVERLAY_Y = 7;

        private DecoratedComposedImage(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            ArrayList<ComposedImage.Point> result = new ArrayList<ComposedImage.Point>();
            result.add(new ComposedImage.Point());
            ComposedImage.Point overlay = new ComposedImage.Point();
            overlay.y = 7;
            overlay.x = 0;
            result.add(overlay);
            return result;
        }
    }
}

