/*
 * Decompiled with CFR 0.152.
 */
package n4ds.dsn.serializer;

import fr.cnav.saturne.ModelAccessor;
import fr.cnav.saturne.Standard;
import fr.cnav.saturne.api.model.access.StandardAccessor;
import fr.cnav.saturne.options.OptionMap;
import fr.cnav.saturne.validator.report.IReportLogger;
import fr.cnav.saturne.validator.report.IReportSerializer;
import fr.cnav.saturne.validator.report.SerializationException;
import fr.cnav.saturne.validator.report.impl.DsnReportLogger;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import n4ds.dsn.serializer.DsnXmlSerializer;

public class DSNReportSerializer
implements IReportSerializer {
    public void serialize(OutputStream outputStream, IReportLogger reportLogger, String namespacePrefix, String namespace, StandardAccessor modelAccessor) throws SerializationException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        if (outputStream != null && factory != null) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                XMLStreamWriter writer = factory.createXMLStreamWriter(bufferedWriter);
                DsnXmlSerializer xmlSerializer = new DsnXmlSerializer(writer, reportLogger, (ModelAccessor)modelAccessor);
                xmlSerializer.serialize();
                writer.close();
            }
            catch (XMLStreamException e) {
                throw new SerializationException((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                throw new SerializationException((Throwable)e);
            }
        } else {
            if (outputStream == null) {
                throw new IllegalArgumentException("Couldn't create stream writer.");
            }
            if (factory == null) {
                throw new IllegalStateException("Couldn't get XML factory.");
            }
        }
    }

    public IReportLogger getReportLogger(Standard theStandard, boolean calculateContextsDuringParsing, OptionMap optionsMap) {
        return new DsnReportLogger(theStandard, calculateContextsDuringParsing, optionsMap);
    }
}

