/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.optimization.externalize;

import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.VarRef;
import fr.cnav.saturne.dsl.formules.util.FormulesSwitch;
import fr.cnav.saturne.dsl.optimization.Transformation;
import fr.cnav.saturne.dsl.optimization.TransformationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class VariableExternalizer
implements Transformation {
    @Override
    public Expression transform(Expression input) {
        throw new UnsupportedOperationException("Cette classe ne devrait plus \u00eatre utilis\u00e9e.");
    }

    static class NodeExpressionRemover
    extends FormulesSwitch<String> {
        List<Memo> worklist = new ArrayList<Memo>();
        List<Binding> killList = new ArrayList<Binding>();
        Map<String, Expression> bindings = new HashMap<String, Expression>();

        NodeExpressionRemover() {
        }

        public void processExpression(Expression expr) {
            Expression transformee;
            if (expr instanceof Let) {
                assert (expr.eContainer() == null);
                transformee = ((Let)expr).getIn();
            } else {
                transformee = expr;
            }
            this.doSwitch(transformee);
            for (Memo memo : this.worklist) {
                TransformationUtils.substitute(memo.varref, memo.value);
            }
            for (Binding binding : this.killList) {
                Let let = (Let)binding.eContainer();
                let.getBindings().remove((Object)binding);
                if (let.getBindings().size() != 0) continue;
                TransformationUtils.substitute(let, let.getIn());
            }
        }

        @Override
        public String caseLet(Let object) {
            for (Binding binding : object.getBindings()) {
                Expression expr = binding.getExpr();
                this.doSwitch(expr);
                if (!(expr instanceof FieldRef)) continue;
                this.bindings.put(binding.getVarName(), binding.getExpr());
                this.killList.add(binding);
            }
            this.doSwitch(object.getIn());
            for (Binding binding : object.getBindings()) {
                this.bindings.remove(binding.getVarName());
            }
            return "";
        }

        @Override
        public String caseVarRef(VarRef object) {
            if (this.bindings.containsKey(object.getVarName())) {
                this.worklist.add(new Memo(object, this.bindings.get(object.getVarName())));
            }
            return "";
        }

        @Override
        public String defaultCase(EObject object) {
            for (EObject eObject : object.eContents()) {
                this.doSwitch(eObject);
            }
            return "";
        }

        static class Memo {
            VarRef varref;
            Expression value;

            Memo(VarRef var, Expression val) {
                this.varref = var;
                this.value = val;
            }
        }
    }
}

