/*
 * Decompiled with CFR 0.152.
 */
package fr.cnav.saturne.dsl.formules;

import fr.cnav.saturne.dsl.formules.Add;
import fr.cnav.saturne.dsl.formules.AlphaNum;
import fr.cnav.saturne.dsl.formules.And;
import fr.cnav.saturne.dsl.formules.Binding;
import fr.cnav.saturne.dsl.formules.Date;
import fr.cnav.saturne.dsl.formules.Diff;
import fr.cnav.saturne.dsl.formules.Div;
import fr.cnav.saturne.dsl.formules.Equals;
import fr.cnav.saturne.dsl.formules.Equiv;
import fr.cnav.saturne.dsl.formules.Error;
import fr.cnav.saturne.dsl.formules.Expression;
import fr.cnav.saturne.dsl.formules.FieldRef;
import fr.cnav.saturne.dsl.formules.FormulesFactory;
import fr.cnav.saturne.dsl.formules.FunctionCall;
import fr.cnav.saturne.dsl.formules.Greater;
import fr.cnav.saturne.dsl.formules.GreaterEqual;
import fr.cnav.saturne.dsl.formules.Imply;
import fr.cnav.saturne.dsl.formules.In;
import fr.cnav.saturne.dsl.formules.IteratorVariable;
import fr.cnav.saturne.dsl.formules.Let;
import fr.cnav.saturne.dsl.formules.Literal;
import fr.cnav.saturne.dsl.formules.Lower;
import fr.cnav.saturne.dsl.formules.LowerEqual;
import fr.cnav.saturne.dsl.formules.Mult;
import fr.cnav.saturne.dsl.formules.Not;
import fr.cnav.saturne.dsl.formules.Num;
import fr.cnav.saturne.dsl.formules.Or;
import fr.cnav.saturne.dsl.formules.Quantified;
import fr.cnav.saturne.dsl.formules.Quantifier;
import fr.cnav.saturne.dsl.formules.Sub;
import fr.cnav.saturne.dsl.formules.ValueList;
import fr.cnav.saturne.dsl.formules.VarRef;
import java.util.ArrayList;
import java.util.List;

public class FormulesGenerator {
    public Error error(String msg) {
        Error result = FormulesFactory.eINSTANCE.createError();
        result.setMsg(msg);
        return result;
    }

    public Or or(Expression ... operands) {
        Or result = FormulesFactory.eINSTANCE.createOr();
        int i = 0;
        while (i < operands.length) {
            result.getOperands().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public And and(Expression ... operands) {
        And result = FormulesFactory.eINSTANCE.createAnd();
        int i = 0;
        while (i < operands.length) {
            result.getOperands().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public Not not(Expression operand) {
        Not result = FormulesFactory.eINSTANCE.createNot();
        result.setOperand(operand);
        return result;
    }

    public Imply imply(Expression leftOp, Expression rightOp) {
        Imply result = FormulesFactory.eINSTANCE.createImply();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public Equiv equiv(Expression leftOp, Expression rightOp) {
        Equiv result = FormulesFactory.eINSTANCE.createEquiv();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public LowerEqual lowerEqual(Expression leftOp, Expression rightOp) {
        LowerEqual result = FormulesFactory.eINSTANCE.createLowerEqual();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public GreaterEqual greaterEqual(Expression leftOp, Expression rightOp) {
        GreaterEqual result = FormulesFactory.eINSTANCE.createGreaterEqual();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public Lower lower(Expression leftOp, Expression rightOp) {
        Lower result = FormulesFactory.eINSTANCE.createLower();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public Greater greater(Expression leftOp, Expression rightOp) {
        Greater result = FormulesFactory.eINSTANCE.createGreater();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public Diff diff(Expression leftOp, Expression rightOp) {
        Diff result = FormulesFactory.eINSTANCE.createDiff();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public Equals equals(Expression leftOp, Expression rightOp) {
        Equals result = FormulesFactory.eINSTANCE.createEquals();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public Quantified quantifiedEvery(Expression expression, IteratorVariable ... variables) {
        ArrayList<IteratorVariable> vars = new ArrayList<IteratorVariable>();
        IteratorVariable[] iteratorVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IteratorVariable var = iteratorVariableArray[n2];
            vars.add(var);
            ++n2;
        }
        return this.quantified("every", expression, vars);
    }

    public Quantified quantifiedSome(Expression expression, IteratorVariable ... variables) {
        ArrayList<IteratorVariable> vars = new ArrayList<IteratorVariable>();
        IteratorVariable[] iteratorVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IteratorVariable var = iteratorVariableArray[n2];
            vars.add(var);
            ++n2;
        }
        return this.quantified("some", expression, vars);
    }

    public Quantified quantifiedNone(Expression expression, IteratorVariable ... variables) {
        ArrayList<IteratorVariable> vars = new ArrayList<IteratorVariable>();
        IteratorVariable[] iteratorVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IteratorVariable var = iteratorVariableArray[n2];
            vars.add(var);
            ++n2;
        }
        return this.quantified("none", expression, vars);
    }

    public Quantified quantifiedNoneOrEvery(Expression expression, IteratorVariable ... variables) {
        ArrayList<IteratorVariable> vars = new ArrayList<IteratorVariable>();
        IteratorVariable[] iteratorVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IteratorVariable var = iteratorVariableArray[n2];
            vars.add(var);
            ++n2;
        }
        return this.quantified("none_or_every", expression, vars);
    }

    public Let let() {
        return FormulesFactory.eINSTANCE.createLet();
    }

    public In in(Expression leftOp, ValueList rightOp) {
        In result = FormulesFactory.eINSTANCE.createIn();
        result.setLeftOp(leftOp);
        result.setRightOp(rightOp);
        return result;
    }

    public ValueList valueList(Literal ... elements) {
        ValueList list = FormulesFactory.eINSTANCE.createValueList();
        Literal[] literalArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal = literalArray[n2];
            list.getValues().add((Object)literal);
            ++n2;
        }
        return list;
    }

    public Add add(Expression ... operands) {
        Add result = FormulesFactory.eINSTANCE.createAdd();
        int i = 0;
        while (i < operands.length) {
            result.getOperands().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public Sub sub(Expression ... operands) {
        Sub result = FormulesFactory.eINSTANCE.createSub();
        int i = 0;
        while (i < operands.length) {
            result.getOperands().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public Mult mult(Expression ... operands) {
        Mult result = FormulesFactory.eINSTANCE.createMult();
        int i = 0;
        while (i < operands.length) {
            result.getOperands().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public Div div(Expression ... operands) {
        Div result = FormulesFactory.eINSTANCE.createDiv();
        int i = 0;
        while (i < operands.length) {
            result.getOperands().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public FunctionCall functionCall(String name, Expression ... operands) {
        FunctionCall result = FormulesFactory.eINSTANCE.createFunctionCall();
        result.setName(name);
        int i = 0;
        while (i < operands.length) {
            result.getArguments().add((Object)operands[i]);
            ++i;
        }
        return result;
    }

    public FieldRef fieldRefByStr(String name) {
        FieldRef result = FormulesFactory.eINSTANCE.createFieldRef();
        result.setName(name);
        return result;
    }

    public FieldRef fieldRef(String name) {
        FieldRef result = FormulesFactory.eINSTANCE.createFieldRef();
        result.setName(name);
        return result;
    }

    public AlphaNum alphaNum(String value) {
        AlphaNum result = FormulesFactory.eINSTANCE.createAlphaNum();
        result.setValue(value);
        return result;
    }

    public Num num(String value) {
        Num result = FormulesFactory.eINSTANCE.createNum();
        result.setValue(value);
        return result;
    }

    public Date date(String value) {
        Date result = FormulesFactory.eINSTANCE.createDate();
        result.setValue(value);
        return result;
    }

    public Expression[] expressions(Expression ... elts) {
        return elts;
    }

    public FieldRef buildFieldRef(String name) {
        if (name == null) {
            throw new IllegalArgumentException("FormulesGenerator: buildFieldRef: can't build a field with null strings passed in.");
        }
        FieldRef result = this.fieldRef(name);
        return result;
    }

    public VarRef varRef(String varName) {
        VarRef varRef = FormulesFactory.eINSTANCE.createVarRef();
        varRef.setVarName(varName);
        return varRef;
    }

    public Binding binding(String varName, Expression expr) {
        Binding result = FormulesFactory.eINSTANCE.createBinding();
        result.setVarName(varName);
        result.setExpr(expr);
        return result;
    }

    public Let let(Expression expr, Binding ... bindings) {
        Let result = FormulesFactory.eINSTANCE.createLet();
        result.setIn(expr);
        int i = 0;
        while (i < bindings.length) {
            result.getBindings().add((Object)bindings[i]);
            ++i;
        }
        return result;
    }

    public IteratorVariable iteratorVariable(String varName, FieldRef element) {
        IteratorVariable result = FormulesFactory.eINSTANCE.createIteratorVariable();
        result.setVarName(varName);
        result.setElement(element);
        return result;
    }

    public Quantified quantified(String quantifier, Expression body, List<IteratorVariable> vars) {
        Quantified quantified = FormulesFactory.eINSTANCE.createQuantified();
        quantified.setExpression(body);
        for (IteratorVariable var : vars) {
            quantified.getVariables().add((Object)var);
        }
        if ("every".equals(quantifier)) {
            quantified.setQuantifier(Quantifier.EVERY);
        } else if ("some".equals(quantifier)) {
            quantified.setQuantifier(Quantifier.SOME);
        } else if ("none".equals(quantifier)) {
            quantified.setQuantifier(Quantifier.NONE);
        } else if ("none_or_every".equals(quantifier)) {
            quantified.setQuantifier(Quantifier.NONE_OR_EVERY);
        } else {
            throw new UnsupportedOperationException("Unknown quantifier: " + quantifier);
        }
        return quantified;
    }
}

